/*
 * Decompiled with CFR 0.152.
 */
package edu.usfca.syndiag;

import edu.usfca.syndiag.GraphicsEngine;
import edu.usfca.syndiag.SyntaxDiagramGenerator;
import java.awt.BasicStroke;
import java.awt.Font;

public class DefaultSyntaxDiagramGenerator
implements SyntaxDiagramGenerator {
    protected GraphicsEngine engine = null;

    public DefaultSyntaxDiagramGenerator() {
    }

    public DefaultSyntaxDiagramGenerator(GraphicsEngine engine) {
        this.engine = engine;
    }

    public void drawArrow(int x1, int y1, int x2, int y2) {
        if (x1 < x2) {
            this.engine.drawLine(x1, y1, x2, y2);
            int[] xCoordinates = new int[]{x2 - 8, x2 - 8, x2};
            int[] yCoordinates = new int[]{y2 - 3, y2 + 3, y2};
            this.engine.fillPolygon(xCoordinates, yCoordinates, 3);
        } else if (x1 > x2) {
            this.engine.drawLine(x1, y1, x2, y2);
            int[] xCoordinates = new int[]{x2 + 8, x2 + 8, x2};
            int[] yCoordinates = new int[]{y2 - 3, y2 + 3, y2};
            this.engine.fillPolygon(xCoordinates, yCoordinates, 3);
        } else if (y1 > y2) {
            this.engine.drawLine(x1, y1, x2, y2);
            int[] xCoordinates = new int[]{x2 - 3, x2 + 3, x2};
            int[] yCoordinates = new int[]{y2 + 8, y2 + 8, y2};
            this.engine.fillPolygon(xCoordinates, yCoordinates, 3);
        } else if (y1 < y2) {
            this.engine.drawLine(x1, y1, x2, y2);
            int[] xCoordinates = new int[]{x2 - 3, x2 + 3, x2};
            int[] yCoordinates = new int[]{y2 - 8, y2 - 8, y2};
            this.engine.fillPolygon(xCoordinates, yCoordinates, 3);
        }
    }

    public void drawDFConnLine(int x1, int y1, int x2, int y2) {
        this.engine.drawLine(x1, y1, x1, y2);
        this.drawArrow(x1, y2, x2, y2);
    }

    public void drawFUConnLine(int x1, int y1, int x2, int y2) {
        this.engine.drawLine(x1, y1, x2, y1);
        this.drawArrow(x2, y1, x2, y2);
    }

    public void drawDBConnLine(int x1, int y1, int x2, int y2) {
        this.engine.drawLine(x1, y1, x1, y2);
        this.drawArrow(x1, y2, x2, y2);
    }

    public void drawBUConnLine(int x1, int y1, int x2, int y2) {
        this.engine.drawLine(x1, y1, x2, y1);
        this.drawArrow(x2, y1, x2, y2);
    }

    public void drawBackConnLine(int x1, int y1, int x2, int y2, int h) {
        this.engine.drawLine(x2, y2, x2, y2 + h);
        this.engine.drawLine(x2, y2 + h, x1, y1 + h);
        this.drawArrow(x1, y1 + h, x1, y1);
    }

    public void drawForwardConnLine(int x1, int y1, int x2, int y2, int h) {
        this.engine.drawLine(x1, y1, x1, y1 - h);
        this.engine.drawLine(x1, y1 - h, x2, y2 - h);
        this.drawArrow(x2, y2 - h, x2, y2);
    }

    public void drawDotRect(int x, int y, int w, int h) {
        BasicStroke dotted = new BasicStroke(3.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        this.engine.drawRect(x, y, w, h, dotted);
    }

    public void drawLeftRangeRect(int x, int y, int w, int h) {
        this.engine.drawLine(x, y, x + w, y);
        this.engine.drawLine(x, y, x, y + h);
        this.engine.drawLine(x, y + h, x + w, y + h);
    }

    public void drawRightRangeRect(int x, int y, int w, int h) {
        this.engine.drawLine(x, y, x + w, y);
        this.engine.drawLine(x + w, y, x + w, y + h);
        this.engine.drawLine(x, y + h, x + w, y + h);
    }

    public void drawText(String str, Font f, int x, int y) {
        this.engine.drawString(str, x, y, f);
    }

    public void drawRule(int x1, int y1, int x2, int y2, int w, int s) {
        if (s == 0) {
            this.drawArrow(x1, y1 + 10, x2, y2 + 10);
            this.drawArrow(x1 + 40 + w, y1 + 10, x1 + 40 + w + 90, y1 + 10);
        } else {
            this.drawArrow(x1 + 40, y1 + 10, x2, y2 + 10);
            this.drawArrow(x1 + 40 + w, y1 + 10, x1 + 40 + w + 90, y1 + 10);
        }
    }

    public void drawBlock(int[] connPoint1, int[] connPoint2, int[] leftConnPoint, int[] rightConnPoint, int i) {
        if (i == 1) {
            this.engine.drawLine(connPoint1[0], connPoint1[1], leftConnPoint[0], connPoint1[1]);
            this.engine.drawLine(rightConnPoint[0], connPoint2[1], connPoint2[0], connPoint2[1]);
        } else {
            this.drawDFConnLine(connPoint1[0], connPoint1[1], leftConnPoint[0], leftConnPoint[1]);
            this.drawFUConnLine(rightConnPoint[0], rightConnPoint[1], connPoint2[0], connPoint2[1]);
        }
    }

    public void drawOptional(int[] connPoint1, int[] connPoint2, int h) {
        this.drawForwardConnLine(connPoint1[0] - 5, connPoint1[1], connPoint2[0] + 5, connPoint2[1], h);
    }

    public void drawClosure(int[] connPoint1, int[] connPoint2, int h) {
        this.drawForwardConnLine(connPoint1[0] - 5, connPoint1[1], connPoint2[0] + 5, connPoint2[1], 20);
        this.drawBackConnLine(connPoint1[0] - 5, connPoint1[1], connPoint2[0] + 5, connPoint2[1], h);
    }

    public void drawPClosure(int[] connPoint1, int[] connPoint2, int h) {
        this.drawBackConnLine(connPoint1[0] - 5, connPoint1[1], connPoint2[0] + 5, connPoint2[1], h);
    }

    public void drawRuleRef(int x, int y, int w, int h, String str) {
        this.engine.drawOval(x, y, w, h);
        this.drawText(str, new Font("Monospaces", 2, 14), x + 10, y + 15);
    }

    public void drawNot(int x, int y, int w, int h, String str) {
        this.engine.drawRect(x, y, w, h);
        this.drawText(str, new Font("Monospaces", 0, 14), x + 6, y + 15);
    }

    public void drawRange(int x, int y, int w, int h, String str, int pos) {
        if (pos == 1) {
            this.drawLeftRangeRect(x, y, w, h);
            this.drawText(String.valueOf(str) + "  ..", new Font("Monospaces", 0, 15), x + 14, y + 15);
        } else if (pos == 2) {
            this.drawRightRangeRect(x, y, w, h);
            this.drawText(str, new Font("Monospaces", 0, 14), x + 14, y + 15);
        }
    }

    public void drawTokenRef(int x, int y, int w, int h, String str) {
        this.engine.drawRect(x, y, w, h);
        this.drawText(str, new Font("Monospaces", 0, 14), x + 14, y + 15);
    }

    public void drawL(int x, int y, int w, int h, String str) {
        this.engine.drawRect(x, y, w, h);
        this.drawText(str, new Font("Monospaces", 0, 14), x + 14, y + 15);
    }

    public void drawWC(int x, int y, int w, int h, String str) {
        this.engine.drawRect(x, y, w, h);
        this.drawText(str, new Font("Monospaces", 0, 14), x + 14, y + 15);
    }

    public void beginRule(String str, int x, int y) {
        this.drawText(str, new Font("Monospaces", 1, 20), x, y);
    }

    public void continueRule(String str, int x, int y) {
        this.drawText(str, new Font("Monospaces", 2, 20), x, y);
    }

    public void endRule(int x1, int y1, int x2, int y2, int w, int s) {
        this.drawRule(x1, y1, x2, y2, w, s);
    }
}

