/*
 * Decompiled with CFR 0.152.
 */
package net.mark_malakanov.sdg2;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import edu.usfca.syndiag.ANTLRLexer;
import edu.usfca.syndiag.ANTLRParser;
import edu.usfca.syndiag.AdjustDimension;
import edu.usfca.syndiag.Draw;
import edu.usfca.syndiag.GrammarAST;
import edu.usfca.syndiag.SetDimension;
import edu.usfca.syndiag.SetLocation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;
import net.mark_malakanov.sdg2.DrawDemo;
import net.mark_malakanov.sdg2.HTMLandFilesBackGroundSaver;
import net.mark_malakanov.sdg2.HtmlSyntaxDiagramGenerator;

public class SdgBody {
    ASTFactory astFactory;
    AST initialGrammarTree;
    AST grammarTree;
    int diagramWidth;
    int diagramAltWidth;
    String diagramStyle = "Canonical";

    public void calcLayout(int dw, int daw) {
        try {
            this.diagramWidth = dw;
            this.diagramAltWidth = daw;
            this.grammarTree = this.astFactory.dupList(this.initialGrammarTree);
            if (this.initialGrammarTree == this.grammarTree) {
                this.grammarTree = null;
            }
            if (this.grammarTree.equalsTree(this.initialGrammarTree)) {
                this.grammarTree = this.grammarTree;
            }
            SetDimension sd = new SetDimension();
            if (this.diagramWidth > 0) {
                AdjustDimension ad = new AdjustDimension();
                ad.setWidth(this.diagramWidth);
                ad.setAltWidth(this.diagramAltWidth);
                ad.grammar(this.grammarTree);
            }
            sd.grammar(this.grammarTree);
            SetLocation sl = new SetLocation();
            sl.grammar(this.grammarTree);
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
    }

    public void load(InputStream inStr) throws TokenStreamException, RecognitionException, IOException {
        ANTLRLexer lexer = new ANTLRLexer(inStr);
        ANTLRParser parser = new ANTLRParser(lexer);
        parser.setASTNodeClass("edu.usfca.syndiag.GrammarAST");
        parser.grammar();
        this.initialGrammarTree = parser.getAST();
        this.astFactory = parser.getASTFactory();
        this.calcLayout(this.diagramWidth, this.diagramAltWidth);
    }

    public void saveAsFile(AST ast, String fileName) throws IOException {
        int width = ((GrammarAST)ast).getWidth() + 170;
        int height = ((GrammarAST)ast).getHeight() + 50;
        String fmt = "png";
        fmt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (fmt.equalsIgnoreCase("svg")) {
            DrawDemo svgPanel = new DrawDemo();
            svgPanel.setAST(ast);
            svgPanel.paintSvg(fileName);
            return;
        }
        BufferedImage image = new BufferedImage(width, height, 5);
        Graphics2D g = image.createGraphics();
        DrawDemo canvas = new DrawDemo();
        canvas.init();
        canvas.setAST(ast);
        canvas.setBackground(Color.white);
        canvas.setForeground(Color.black);
        canvas.setBounds(0, 0, width, height);
        canvas.setDiagramStyle(this.diagramStyle);
        g.setBackground(Color.white);
        g.setPaint(Color.gray);
        g.clearRect(0, 0, width, height);
        AffineTransform aT = g.getTransform();
        int dX = ((GrammarAST)ast).getX();
        int dY = ((GrammarAST)ast).getY();
        aT.translate(-dX + 20, -dY + 20);
        g.setTransform(aT);
        canvas.paint(g);
        g.dispose();
        System.err.println("save " + fileName);
        ImageIO.write((RenderedImage)image, fmt, new File(fileName));
        image.flush();
        image = null;
        System.gc();
    }

    public void saveAsHTMLandFiles(String dirName, String htmlName, String ext, String htmlTitle, String htmlHeader, String imgBorder, ProgressMonitor pm) throws InterruptedException, IOException {
        block6: {
            GrammarAST gast = (GrammarAST)this.grammarTree;
            GrammarAST[] rules = gast.getChildrenAsArray();
            File dir = new File(dirName);
            dir.mkdir();
            if (!htmlName.toLowerCase().endsWith(".html")) {
                htmlName = String.valueOf(htmlName) + ".html";
            }
            PrintWriter w = new PrintWriter(new BufferedOutputStream(new FileOutputStream(htmlName)));
            HtmlSyntaxDiagramGenerator hsdg = new HtmlSyntaxDiagramGenerator(w, dirName, ext, htmlTitle, htmlHeader, imgBorder);
            Draw draw = new Draw();
            draw.setDiagGen(hsdg);
            if (pm != null) {
                pm.setMaximum(rules.length);
            }
            for (int i = 0; i < rules.length; ++i) {
                GrammarAST rule = rules[i];
                String fn = rule.getFirstChild().getText();
                String fullName = String.valueOf(dirName) + "/" + fn + "." + ext;
                if (pm != null) {
                    pm.setProgress(i);
                    pm.setNote(fullName);
                    Thread.currentThread();
                    Thread.yield();
                    Thread.currentThread();
                    Thread.sleep(50L);
                    if (pm.isCanceled()) break;
                }
                try {
                    draw.grammar((AST)rule);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.saveAsFile((AST)rule, fullName);
                if (pm == null) continue;
                pm.setProgress(i + 1);
                pm.setNote(fullName);
                Thread.currentThread();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(50L);
                if (pm.isCanceled()) break;
            }
            w.println("</BODY>");
            w.println("</HTML>");
            w.flush();
            w.close();
            if (pm == null) break block6;
            pm.close();
        }
    }

    public void saveAsFiles(String dirName, String ext) throws IOException {
        GrammarAST gast = (GrammarAST)this.grammarTree;
        GrammarAST[] rules = gast.getChildrenAsArray();
        for (int i = 0; i < rules.length; ++i) {
            GrammarAST rule = rules[i];
            String fn = rule.getFirstChild().getText();
            this.saveAsFile((AST)rule, String.valueOf(fn) + "." + ext);
        }
    }

    public void saveAsHTMLandFilesInBkg(String dirName, String htmlName, String ext, String htmlTitle, String htmlHeader, String imgBorder, ProgressMonitor pm) throws InterruptedException, IOException {
        HTMLandFilesBackGroundSaver t = new HTMLandFilesBackGroundSaver(this, dirName, htmlName, ext, htmlTitle, htmlHeader, imgBorder);
        t.setProgressMonitor(pm);
        t.start();
    }
}

