/*
 * Decompiled with CFR 0.152.
 */
package net.mark_malakanov.sdg2;

import antlr.collections.AST;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import net.mark_malakanov.sdg2.About;
import net.mark_malakanov.sdg2.DiagramTypeDialog;
import net.mark_malakanov.sdg2.DrawDemo;
import net.mark_malakanov.sdg2.HTMLandFilesBackGroundSaver;
import net.mark_malakanov.sdg2.Main;
import net.mark_malakanov.sdg2.SaveToMultipleFilesDialog;
import net.mark_malakanov.sdg2.SdgBody;
import net.mark_malakanov.sdg2.UniversalFilter;
import net.mark_malakanov.sdg2.WidthDialog;

public class SwingForm
implements ActionListener {
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;
    AST ast;
    DrawDemo demo;
    JFrame frm;
    SdgBody sdgBody;
    JMenuItem menuItemSaveAs;
    JMenuItem menuItemSaveAsHTML;
    JMenuItem menuItemSetWidth;
    JMenuItem menuItemDiagStyle;

    static /* synthetic */ Class class$(String a) {
        try {
            Class<?> clazz = Class.forName(a);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public SwingForm(SdgBody sdgBody) {
        this.sdgBody = sdgBody;
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.getAccessibleContext().setAccessibleDescription("File functions");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open", 79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Open ANTLR grammar file");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As", 83);
        menuItem.setEnabled(false);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Save image to file");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.menuItemSaveAs = menuItem;
        menuItem = new JMenuItem("Save As HTML and Multiple Files", 83);
        menuItem.setEnabled(false);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuItem.getAccessibleContext().setAccessibleDescription("Save every rule to a separate file");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        this.menuItemSaveAsHTML = menuItem;
        menu.addSeparator();
        menuItem = new JMenuItem("Exit", 69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        JMenu optMenu = new JMenu("Options");
        optMenu.setMnemonic(79);
        optMenu.getAccessibleContext().setAccessibleDescription("Options");
        menuBar.add(optMenu);
        optMenu.addSeparator();
        menuItem = new JMenuItem("Set Width", 87);
        menuItem.setEnabled(false);
        menuItem.addActionListener(this);
        optMenu.add(menuItem);
        this.menuItemSetWidth = menuItem;
        menuItem = new JMenuItem("Diagram Style", 83);
        menuItem.setEnabled(false);
        menuItem.addActionListener(this);
        optMenu.add(menuItem);
        this.menuItemDiagStyle = menuItem;
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        helpMenu.getAccessibleContext().setAccessibleDescription("Help");
        menuBar.add(helpMenu);
        helpMenu.addSeparator();
        menuItem = new JMenuItem("About", 65);
        menuItem.addActionListener(this);
        helpMenu.add(menuItem);
        return menuBar;
    }

    public void createForm() {
        if (this.frm != null) {
            return;
        }
        this.frm = new JFrame("ANTLR syntax diagram");
        this.frm.setJMenuBar(this.createMenuBar());
        this.demo = new DrawDemo();
        JScrollPane sp = new JScrollPane(this.demo);
        this.frm.setContentPane(sp);
        this.frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingForm.this.frm.setVisible(false);
                SwingForm.this.frm.dispose();
                System.exit(0);
            }
        });
        this.frm.pack();
        this.frm.setSize(new Dimension(800, 600));
        this.frm.setVisible(!Main.isBlind);
    }

    public void draw(AST t) {
        this.ast = t;
        this.demo.init();
        this.demo.setDiagramStyle(this.sdgBody.diagramStyle);
        this.demo.setAST(this.ast);
        this.demo.repaint(this.demo.getVisibleRect());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals("Save As")) {
            try {
                JFileChooser chooser = new JFileChooser(".");
                IIORegistry iior = IIORegistry.getDefaultInstance();
                Iterator spi = iior.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = SwingForm.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, true);
                while (spi.hasNext()) {
                    ImageWriterSpi writerSpi = (ImageWriterSpi)spi.next();
                    String fn = writerSpi.getDescription(Locale.US);
                    String[] sfxs = writerSpi.getFileSuffixes();
                    UniversalFilter uf = new UniversalFilter(sfxs, fn);
                    chooser.addChoosableFileFilter(uf);
                }
                chooser.addChoosableFileFilter(new UniversalFilter("svg", "SVG Vector Image"));
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal != 0) return;
                this.frm.setCursor(new Cursor(3));
                this.sdgBody.saveAsFile(this.ast, chooser.getSelectedFile().getAbsolutePath());
                this.frm.setCursor(new Cursor(0));
                return;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        } else if (source.getText().equals("Open")) {
            try {
                JFileChooser chooser = new JFileChooser(".");
                chooser.addChoosableFileFilter(new UniversalFilter("g", "ANTLR grammar"));
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) return;
                String[] s2 = chooser.getSelectedFile().getName().split("\\.");
                Main.grammarName = s2[0];
                this.frm.setTitle("SDG2: " + Main.grammarName);
                this.frm.setCursor(new Cursor(3));
                this.sdgBody.load(new FileInputStream(chooser.getSelectedFile().getAbsolutePath()));
                this.menuItemSaveAs.setEnabled(true);
                this.menuItemSaveAsHTML.setEnabled(true);
                this.menuItemSetWidth.setEnabled(true);
                this.menuItemDiagStyle.setEnabled(true);
                this.draw(this.sdgBody.grammarTree);
                this.frm.setCursor(new Cursor(0));
                return;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        } else if (source.getText().equals("Exit")) {
            System.exit(0);
            return;
        } else if (source.getText().equals("Save As HTML and Multiple Files")) {
            SaveToMultipleFilesDialog smfd = new SaveToMultipleFilesDialog(this.frm, "Save As HTML and Multiple Files", true);
            smfd.setUniformName(Main.grammarName);
            smfd.pack();
            int x = this.frm.getWidth() / 2 - 200 + this.frm.getX();
            int y = this.frm.getHeight() / 2 - 200 + this.frm.getY();
            smfd.setLocation(x, y);
            smfd.setSize(400, 342);
            smfd.setVisible(true);
            if (!smfd.getResult().equals("OK")) return;
            try {
                HTMLandFilesBackGroundSaver t = new HTMLandFilesBackGroundSaver(this.sdgBody, smfd.getHtmlDirName(), smfd.getHtmlFileName(), smfd.getImgFormat(), smfd.getHtmlTitle(), smfd.getHtmlHeader(), smfd.getHtmlImgBorder());
                ProgressMonitor progressMonitor = new ProgressMonitor(this.frm, "Saving multiple files", "", 0, 0);
                progressMonitor.setMillisToDecideToPopup(10);
                progressMonitor.setMillisToPopup(0);
                t.setProgressMonitor(progressMonitor);
                t.start();
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else if (source.getText().equals("Set Width")) {
            WidthDialog wd = new WidthDialog(this.frm, "WidthDialog", true);
            wd.setDiagramWidth(this.sdgBody.diagramWidth);
            int x = this.frm.getWidth() / 2 - wd.getWidth() / 2 + this.frm.getX();
            int y = this.frm.getHeight() / 2 - wd.getHeight() / 2 + this.frm.getY();
            wd.setLocation(x, y);
            wd.setVisible(true);
            if (!wd.resultValue.equals("OK")) return;
            this.frm.setCursor(new Cursor(3));
            this.sdgBody.calcLayout(wd.getDiagramWidth(), this.sdgBody.diagramWidth - 300);
            this.draw(this.sdgBody.grammarTree);
            this.frm.setCursor(new Cursor(0));
            return;
        } else if (source.getText().equals("Diagram Style")) {
            DiagramTypeDialog sd = new DiagramTypeDialog(this.frm, "DiagramTypeDialog", true);
            sd.setDiagramStyle(this.sdgBody.diagramStyle);
            int x = this.frm.getWidth() / 2 - sd.getWidth() / 2 + this.frm.getX();
            int y = this.frm.getHeight() / 2 - sd.getHeight() / 2 + this.frm.getY();
            sd.setLocation(x, y);
            sd.setVisible(true);
            if (!sd.resultValue.equals("OK")) return;
            this.frm.setCursor(new Cursor(3));
            this.sdgBody.diagramStyle = sd.getDiagramStyle();
            this.draw(this.sdgBody.grammarTree);
            this.frm.setCursor(new Cursor(0));
            return;
        } else {
            if (!source.getText().equals("About")) return;
            JOptionPane.showMessageDialog(this.frm, new About(), "About", -1);
        }
    }
}

