/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.logging.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.logicalcobwebs.logging.Log;

public final class Jdk14Logger
implements Log {
    private Object logger = null;
    private Method logpMethod = null;
    private Method logpExMethod = null;
    private Method isLoggableMethod = null;
    private Method getStackTraceMethod = null;
    private Method getClassNameMethod = null;
    private Method getMethodNameMethod = null;
    private Object levelFINEST = null;
    private Object levelFINE = null;
    private Object levelINFO = null;
    private Object levelWARNING = null;
    private Object levelSEVERE = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    public Jdk14Logger(String name) {
        try {
            Class<?> loggerClass = Class.forName("java.util.logging.Logger");
            Class<?> levelClass = Class.forName("java.util.logging.Level");
            Method getLoggerMethod = loggerClass.getMethod("getLogger", class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String);
            this.logger = getLoggerMethod.invoke(null, name);
            this.logpMethod = this.logger.getClass().getMethod("logp", levelClass, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String);
            this.logpExMethod = this.logger.getClass().getMethod("logp", levelClass, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jdk14Logger.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Jdk14Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            this.isLoggableMethod = loggerClass.getMethod("isLoggable", levelClass);
            this.getStackTraceMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Jdk14Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getStackTrace", null);
            Class<?> stackTraceClass = Class.forName("java.lang.StackTraceElement");
            this.getClassNameMethod = stackTraceClass.getMethod("getClassName", null);
            this.getMethodNameMethod = stackTraceClass.getMethod("getMethodName", null);
            this.levelFINEST = levelClass.getField("FINEST").get(null);
            this.levelFINE = levelClass.getField("FINE").get(null);
            this.levelINFO = levelClass.getField("INFO").get(null);
            this.levelWARNING = levelClass.getField("WARNING").get(null);
            this.levelSEVERE = levelClass.getField("SEVERE").get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create Jdk14Logger: " + e.getMessage());
        }
    }

    private void log(Object level, String msg, Throwable ex) {
        Throwable dummyException = new Throwable();
        String cname = "unknown";
        String method = "unknown";
        try {
            Object[] locations = (Object[])this.getStackTraceMethod.invoke((Object)dummyException, null);
            if (locations != null && locations.length > 2) {
                cname = (String)this.getClassNameMethod.invoke(locations[2], null);
                method = (String)this.getMethodNameMethod.invoke(locations[2], null);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        try {
            if (ex == null) {
                this.logpMethod.invoke(this.logger, level, cname, method, msg);
            } else {
                this.logpExMethod.invoke(this.logger, level, cname, method, msg, ex);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Logging of message '" + msg + "' failed" + (ex != null ? ":" + ex.getMessage() : "."));
        }
    }

    public void debug(Object message) {
        this.log(this.levelFINE, String.valueOf(message), null);
    }

    public void debug(Object message, Throwable exception) {
        this.log(this.levelFINE, String.valueOf(message), exception);
    }

    public void error(Object message) {
        this.log(this.levelSEVERE, String.valueOf(message), null);
    }

    public void error(Object message, Throwable exception) {
        this.log(this.levelSEVERE, String.valueOf(message), exception);
    }

    public void fatal(Object message) {
        this.log(this.levelSEVERE, String.valueOf(message), null);
    }

    public void fatal(Object message, Throwable exception) {
        this.log(this.levelSEVERE, String.valueOf(message), exception);
    }

    public void info(Object message) {
        this.log(this.levelINFO, String.valueOf(message), null);
    }

    public void info(Object message, Throwable exception) {
        this.log(this.levelINFO, String.valueOf(message), exception);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(this.levelFINE);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(this.levelSEVERE);
    }

    public boolean isFatalEnabled() {
        return this.isLoggable(this.levelSEVERE);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(this.levelINFO);
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(this.levelFINEST);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(this.levelWARNING);
    }

    public void trace(Object message) {
        this.log(this.levelFINEST, String.valueOf(message), null);
    }

    public void trace(Object message, Throwable exception) {
        this.log(this.levelFINEST, String.valueOf(message), exception);
    }

    public void warn(Object message) {
        this.log(this.levelWARNING, String.valueOf(message), null);
    }

    public void warn(Object message, Throwable exception) {
        this.log(this.levelWARNING, String.valueOf(message), exception);
    }

    private boolean isLoggable(Object level) {
        try {
            return (Boolean)this.isLoggableMethod.invoke(this.logger, level);
        }
        catch (Exception e) {
            throw new RuntimeException("isLoggable call failed: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

