<%--
  ~ Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
  ~ All rights reserved.
  ~ 
  ~ Redistribution and use in source and binary forms, with or without modification,
  ~ are permitted provided that the following conditions are met:
  ~ 
  ~ 1. Redistributions of source code must retain the above copyright notice,
  ~    this list of conditions and the following disclaimer.
  ~ 2. Redistributions in binary form must reproduce the above copyright notice,
  ~    this list of conditions and the following disclaimer in the documentation
  ~    and/or other materials provided with the distribution.
  ~ 3. Neither the name of the pettan nor the names of its contributors may be used
  ~    to endorse or promote products derived from this software without specific
  ~    prior written permission.
  ~ 
  ~ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
  ~ EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  ~ OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
  ~ SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  ~ INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  ~ TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  ~ BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  ~ CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ~ ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  ~ DAMAGE.
  --%>

<%@ page pageEncoding="UTF-8" %>
<script>
Event.observe( window , 'load' , windowOnload , true )
<%if(作成){%>
	KHCDraggablize()
	Event.observe( $('KHC') , 'mouseover' , KHCMouseOver , true )
	Event.observe( $('KHC') , 'mouseout' , KHCMouseOut , true )
<%}%>

var ROOT = '<html:rewrite page=""/>'
var selectedMIPIdx = 0
var fukidasiConpaneOverSize = 80
var picIdx = 0
var CPActiveTabIdx = 0
var MIPIdx = 0
var fukidasiIdx = 0
var CPTabSeqNo = 1
var defZIndex = 500
/* 2008.07.23
var frontZIndexValue = 501
var rearZIndexValue = 500
*/
var basicMakeKomaShutterHeight = 400

var CPTabQuantity = 0
var bgFlg = false

var picHeightOnMousedown = 0
var picWidthOnMousedown = 0
var picLeftOnMousedown = 0
var picTopOnMousedown = 0

var fukiHeightOnMousedown = 0
var fukiWidthOnMousedown = 0
var fukiLeftOnMousedown = 0
var fukiTopOnMousedown = 0

var copingObject = null

var fukiImg = new Array()

var CPTabLHidden = new Array()
var CPTabRHidden = new Array()

function viewVariables(){
	var alertMsg = 
		"bgFlg = " + bgFlg + 
		"\nselectedMIPIdx = " + selectedMIPIdx + 
		"\nfukidasiConpaneOverSize = " + fukidasiConpaneOverSize + 
		"\npicIdx = " + picIdx + 
		"\nCPActiveTabIdx = " + CPActiveTabIdx + 
		"\nMIPIdx = " + MIPIdx + 
		"\nfukidasiIdx = " + fukidasiIdx + 
		"\nCPTabSeqNo = " + CPTabSeqNo + 
		"\nfrontZIndexValue = " + frontZIndexValue + 
		"\nrearZIndexValue = " + rearZIndexValue + 
		"\nbasicMakeKomaShutterHeight = " + basicMakeKomaShutterHeight + 
		"\nCPTabQuantity = " + CPTabQuantity + 
		"\npicHeightOnMousedown = " + picHeightOnMousedown + 
		"\npicWidthOnMousedown = " + picWidthOnMousedown + 
		"\npicLeftOnMousedown = " + picLeftOnMousedown + 
		"\npicTopOnMousedown = " + picTopOnMousedown + 
		"\nfukiHeightOnMousedown = " + fukiHeightOnMousedown + 
		"\nfukiWidthOnMousedown = " + fukiWidthOnMousedown + 
		"\nfukiLeftOnMousedown = " + fukiLeftOnMousedown + 
		"\nfukiTopOnMousedown = " + fukiTopOnMousedown
	alert( alertMsg )
}

/*2008.07.23 たぶんこの２つの関数はいらなくなるはず。
function frontZIndex(){ return frontZIndexValue++ }
function rearZIndex(){ return rearZIndexValue-- }
*/

function getCPTabSeqNo(){ return CPTabSeqNo++ }

function windowOnload(){
	<%if(作成){%>
		createIP()
		getMainImagePanel()
	<%}%>
	<%if( editTargetKoma != null ){%>
		putKomaOnJSP()
	<%}%>
}

<logic:iterate id="fukidasiImage" name="fukidasiImages" type="peta.dao.FukidasiImage" indexId="i">
	fukiImg['<bean:write name="fukidasiImage" property="fukidasiImageID"/>'] = <%=fukidasiImage.getJSON()%>
</logic:iterate>	
function KHCMouseOver(){
	$('triangleImg').src = $('triangleImg').src.replace( /0_/ , '1_' )
	$('KHCLImg').src = $('KHCLImg').src.replace( /0_/ , '1_' )
	$('KHCRImg').src = $('KHCRImg').src.replace( /0_/ , '1_' )
	$('KHCC').style.background = "url('" + ROOT + "/images/button/1_button38c.gif')"
}
function KHCMouseOut(){
	$('triangleImg').src = $('triangleImg').src.replace( /1_/ , '0_' )
	$('KHCLImg').src = $('KHCLImg').src.replace( /1_/ , '0_' )
	$('KHCRImg').src = $('KHCRImg').src.replace( /1_/ , '0_' )
	$('KHCC').style.background = "url('" + ROOT + "/images/button/0_button38c.gif')"
}

function KHCDraggablize(){
	$('KHC').draggable = new Draggable(
		'KHC',
		{snap:function( x , y ){
			var height = y - 1
			if( height < 1 ) height = 1
			setKomaHeight( height )
			if( y < 2 + IER/2 ) y = 2 + IER/2
			return[x,y]
		},
		constraint:'vertical',
		starteffect:null , endeffect:null}
	)
	Event.observe( $('KHC') , 'mousedown' , function(){ $('pageHeightAdjuster').style.height = '500px' } , true )
}

function setKomaHeight( height ){
	$('komaHeight').value = height
	$('komaHeightTextBox').value = height
	$('koma').style.height = height + 1 + IER/2
}


function preview(){
	window.open( '' , 'preview' )
	$('makeForm').action = ROOT + '/preview.peta'
	$('makeForm').target = 'preview'
	$('makeForm').submit()
}

<%if( usr != null && "A".equals(usr.getAuthority()) ){%>
function deleteImage(imageID){
	if( confirm('消しちゃうよ？') ){
		new Ajax.Request(
			ROOT + '/deleteImage.peta?imageID=' + imageID ,
			{ method:'get' , onFailure: function(){alert('削除に失敗しました。')}}
		)
		if( $('PPTD' + imageID) ) removeObj( $('PPTD' + imageID) )
		else if( $('BIPTD' + imageID) ) removeObj( $('BIPTD' + imageID) )
		return false
	}
	return true
}
<%}%>

function getAllCPTab(){
	var ary = new Array()
	for( var i = 0 ; i < CPTabSeqNo ; i++ ){
		if( $('CPTab' + i ) ) ary[ary.length] = $('CPTab' + i )
	}
	return ary
}

function inspectElementsStyle( style ){
	var tabs = getAllCPTab()
	for( i = 0 ; i < tabs.length ; i++ ){
		alert( tabs[i].id + " : " + tabs[i].obj.style[style] )
	}
}

/*
function getAllObjects(){
	var tabs = getAllCPTab()
}
*/

function frontZIndex(){
	return defZIndex + CPTabQuantity - 1
}


function moveFirstFront( type , i ){
	var executed = true
	while(executed)	executed = moveFront( type , i )
	/*
	var moveIdx = new Number( defZIndex + CPTabQuantity - 1 - $( type + i ).style.zIndex )
	$( type + i ).style.zIndex = moveIdx + new Number( $( type + i ).style.zIndex )
	var tabs = getAllCPTab()
	tabs.sortBy( function(obj){ return obj.obj.zIndex } )
	for( i = 0 ; i < moveIdx ; i++ ) tabs[i].obj.style.zIndex -= 1
	*/
}

function moveFirstRear( type , i ){
	var executed = true
	while(executed)	executed = moveRear( type , i )
}

function moveFront( type , i ){
	var zIndex = new Number( $( type + i ).style.zIndex ) + 1
	var tabs = getAllCPTab()
	for( j = 0 ; j < tabs.length ; j++ ){
		if( tabs[j].obj.style.zIndex == zIndex ){
			tabs[j].obj.style.zIndex = zIndex - 1
			$( tabs[j].type + 'ZIndex' + tabs[j].typeIdx ).value = zIndex - 1
			$( type + i ).style.zIndex = zIndex
			$( type + 'ZIndex' + i ).value = zIndex
			return true
		}
	}
	return false
}

function moveRear( type , i ){
	var zIndex = new Number( $( type + i ).style.zIndex ) - 1
	var tabs = getAllCPTab()
	for( j = 0 ; j < tabs.length ; j++ ){
		if( tabs[j].obj.style.zIndex == zIndex ){
			//alert( 'tabs[j].typeIdx : ' + tabs[j].typeIdx )
			tabs[j].obj.style.zIndex = zIndex + 1
			$( tabs[j].type + 'ZIndex' + tabs[j].typeIdx ).value = zIndex + 1
			$( type + i ).style.zIndex = zIndex
			$( type + 'ZIndex' + i ).value = zIndex
			return true
		}
	}
	return false
}

function switchBorder(that){
	if(that.checked) $('koma').style.borderColor = 'black'
	else $('koma').style.borderColor = 'white'
}

var maxKomaWidth = 920
function komaSizeChange( val , target ){
	var after = eval($(target).value) + val
	if( after < 0 ) after = 0
	//else if( after > maxKomaWidth && target == 'komaWidth') after = maxKomaWidth
	$(target).value = after
	reflectKomaSize()
}

function makeOnSubmit(){
	if( $('comicTitle') && $F('comicTitle').length < 1 ){
		alert("コミックのタイトルを入力してください！")
		return false
	}

	//投稿可能チェック
	var makerFreeFlgs = document.getElementsByName('makerFreeFlg');
	if( makerFreeFlgs.length != 0  ){
		var makerFreeFlagchecked = false
		for( i = 0 ; i < makerFreeFlgs.length ; i++ ){
			if( makerFreeFlgs[i].checked ) makerFreeFlagchecked = true
		}
		if( ! makerFreeFlagchecked ){
			alert('投稿可能なユーザを指定してください。')
			return false
		}
	}
	
	$('makeForm').action = ROOT + '/make.peta'
	$('makeForm').target = '_self'
	
	var finishMsg = 
		( $('notLoginToken') == null )?
			'作成したコマを投稿します。よろしいですか？' :
			'作成したコマを投稿します。\n「名無しさん」での投稿になりますが、よろしいですか？'
	return confirm(finishMsg)
}

function reflectKomaSize(){
	$('koma').style.width = eval($('komaWidth').value) + IER
	$('koma').style.height = eval($('komaHeight').value) + IER
	$('KHC').style.width = eval($('komaWidth').value) + 2
	$('komaOutsideDiv').style.width = eval($('komaWidth').value) + 2
}

function setColorNumber( color ){
	var rx = new RegExp("([0123456789]+),([0123456789]+),([0123456789]+)")
	color.match(rx)
	//alert( RegExp.$1 + RegExp.$2 + RegExp.$3 )
	$('bgColorR').value = RegExp.$1
	$('bgColorG').value = RegExp.$2
	$('bgColorB').value = RegExp.$3
	changeBgColor()
}

function changeBgColor(){
	var color = 'rgb(' + $F('bgColorR') + ',' + $F('bgColorG') + ',' + $F('bgColorB') + ')'
	$('bgColorHidden').value = color
	$('bgImageID').value = ''
	$('koma').style.background = color
	$('bgConpaneImageDiv').style.background = color
}

function resetBg(){
	$('bgColorHidden').value = 'white'
	$('bgImageID').value = ''
	$('bgConpaneImageDiv').style.background = 'white'
	$('koma').style.background = 'white'
}

//IP:ImagePanel
function createIP(){
	var w = new Window( {
		id : "IP",
		title: "<b>画像選択</b>",
		top: 50, left: 400,
		width: 500 , height: 300,
		minWidth: 500 , minHeight: 300,
		showEffect: Element.show,
		hideEffect: Element.hide,
		draggable: true,
		closable: false,
		maximizable: false,
		minimizable: false,
		parent:$('makeKomaDiv'),
		className: "alphacube"
	} )
	$('IP').obj = w
	$('IP').obj.setZIndex(12000)
	$('IP').appendChild($('imagePanelChild'))
	removeObj($('imagePanel'))
}

//FP:FukidasiPanel
/* 2008.05.02
function createFP(){
	var w = new Window( {
		id : "FP",
		title: "<b>フキダシ選択</b>",
		top: 300, left: 400,
		width: 500 , height: 350,
		minWidth: 500 , minHeight: 300,
		showEffect: Element.show,
		hideEffect: Element.hide,
		draggable: true,
		closable: false,
		maximizable: false,
		minimizable: false,
		className: "alphacube"
	} )
	$('FP').obj = w
	$('FP').obj.setZIndex(12000)
	$('FP').appendChild($('fukidasiImagePanelChild'))
	removeObj($('fukidasiImagePanel'))
}
createFP()
*/

function pictureFlash(i){
	flicker( $('pictureImage' + i) , 0.5 )
}

function switchPictureMovable( that , i ){
	if( !$('picture' + i).draggable ){
		HLFlicker($('picture' + i))
		pictureDraggablize(i)
	}else{
		HLFlicker($('picture' + i))
		$('picture' + i).draggable.destroy()
		$('picture' + i).draggable = null
	}
}

function eraseObject(){
	if( CPTabQuantity != 0 ){
		var type = $('CPTab' + CPActiveTabIdx).type
		var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
		var obj = $('CPTab' + CPActiveTabIdx).obj
		
		if( $(type + typeIdx).draggable ) $(type + typeIdx).draggable.destroy()
		removeObj($(type + typeIdx))
		removeObj($(type + 'Conpane' + typeIdx))
		//removeObj($('CPTab' + CPActiveTabIdx ).parentNode)
		removeObj($('CPTab' + CPActiveTabIdx ))
		
		var decrement = true
		for( r = CPActiveTabIdx - 1 ; r < CPTabSeqNo ; ){
			if( $('CPTab' + r ) ){
				changeCPActiveTab( r , 'erase' )
				break
			}
			if( r < 0 ) decrement = false
			decrement? r-- : r++ ;
		}
		CPTabQuantity--
		if( CPTabQuantity == 0 ){
			$('fukidasiImagePanel').hide()
			$('CPWFirstMsg').show()
		}

		var tabs = getAllCPTab()
		var zIndex = obj.style.zIndex
		for( i = 0 ; i < tabs.length ; i++ ){
			if( tabs[i].obj.style.zIndex > zIndex ){
				moveRearNoSwaping( tabs[i].type , tabs[i].typeIdx )
			}
		}
	}
}

function eraseAllObject(){
	while( CPTabQuantity != 0 ) eraseObject()
}

function clearKoma(){
	if( confirm('全ての画像・フキダシと背景を消去します。') ){
		eraseAllObject()
		resetBg()
	}
}

function moveRearNoSwaping( type , i ){//入れ替え無しで後ろに移動するだけ
	var zIndex = new Number( $( type + i ).style.zIndex ) - 1
	$( type + i ).style.zIndex = zIndex
	$( type + 'ZIndex' + i ).value = zIndex
}
/*
function moveRear( type , i ){
	var zIndex = new Number( $( type + i ).style.zIndex ) - 1
	var tabs = getAllCPTab()
	for( j = 0 ; j < tabs.length ; j++ ){
		if( tabs[j].obj.style.zIndex == zIndex ){
			//alert( 'tabs[j].typeIdx : ' + tabs[j].typeIdx )
			tabs[j].obj.style.zIndex = zIndex + 1
			$( tabs[j].type + 'ZIndex' + tabs[j].typeIdx ).value = zIndex + 1
			$( type + i ).style.zIndex = zIndex
			$( type + 'ZIndex' + i ).value = zIndex
			return true
		}
	}
	return false
}
*/

//CPTabLHidden


function changeCPActiveTab( i , cmd ){
	var conpaneName = $('CPTab' + i).type + 'Conpane'
	
	if( cmd != 'erase' ){
		var oi = CPActiveTabIdx
		if( $('CPTab' + oi) ){
			var activeConpaneID = $('CPTab' + oi).type + 'Conpane' + $('CPTab' + oi).typeIdx
			$( activeConpaneID ).style.display = 'none'
			$('CPTab' + oi).style.background = '#c0c0c0'
			$('CPTab' + oi).style.borderBottomColor = 'gray'
		}
	}
	
	if( CPTabQuantity != 0 ){
		var typeIdx = $('CPTab' + i).typeIdx
		$(conpaneName + typeIdx).style.display = 'block'
		$('CPTab' + i).style.background = '<%=conpaneBGColor%>'
		$('CPTab' + i).style.borderBottomColor = '<%=conpaneBGColor%>'
	}
	CPActiveTabIdx = i
	
	if( $('CPTab' + i).type == 'fukidasi' ) $('fukidasiImagePanel').show()
	else $('fukidasiImagePanel').hide()
	
}

function addCPTab( typeIdx , type ){
	var CPTabSeqNo = getCPTabSeqNo()
	var td = document.createElement('div')
	
	if( type == "fukidasi" )
		td.innerHTML = new Template( CPTabFukidasi ).evaluate( {i: CPTabSeqNo , n: typeIdx } )
	else if( type == "picture" )
		td.innerHTML = new Template( CPTab ).evaluate( {i: CPTabSeqNo , n: typeIdx } )
	else alert( "typeが不正です。type:" + type )
	
	//td.style.styleFloat = 'right'
	$( 'CPWTopTR' ).insertBefore( td.firstChild , $('CPTabScrollerR') )
	$( 'CPTab' + CPTabSeqNo ).type = type
	$( 'CPTab' + CPTabSeqNo ).typeIdx = typeIdx
	$( 'CPTab' + CPTabSeqNo ).obj = $( type + typeIdx )
	$( 'CPTab' + CPTabSeqNo ).conPane = $( type + 'Conpane' + typeIdx )
	
	//$('CPWMain').style.border = 'solid gray 1px'
	$('CPWFirstMsg').hide()
	
	changeCPActiveTab( CPTabSeqNo )
	CPTabQuantity++
}

/*
function CPTabScrollerSwitch(){
	var LS = $('CPTabScrollerL').style
	var RS = $('CPTabScrollerR').style
	if( CPTabQuantity == 0 ){
		//LS.visibility = 'hidden'
		//RS.visibility = 'hidden'
	}
	else if( CPTabQuantity < 10 ){
		//LS.visibility = 'hidden'
		//RS.visibility = 'hidden'
	}
	else{
		LS.visibility = 'visible'
		RS.visibility = 'visible'
	}
}

function scrollCPTab( direction ){
	if( direction == 'right');
	if( direction == 'left');
}
*/
function generateFukidasi(){
	//showWindow($('fukidasiImagePanel'))
	//$('FP').obj.show()
	$('fukidasiGenerateButton').disabled = true
	addFukidasi()
	$('fukidasiGenerateButton').disabled = false
}

function addPicture( makeEmpty ){
	if( PPLoadCompleted || makeEmpty ){
		if( $( 'mainImage' + selectedMIPIdx ) == null && ! makeEmpty ){
			$('tagSelect').options[0].selected = true
			getMainImagePanel()
			selectedMIPIdx = 0
		}
		else{
			picIdx++
			//ピクチャコンパネの追加。
			var div = document.createElement('div')
			div.id = 'pictureConpane' + picIdx
			div.className = 'pictureConpane'
			div.style.zIndex = 0
			div.innerHTML += new Template( pictureConpane ).evaluate( {i: picIdx} )
			$( 'CPWMain' ).insertBefore( div , $('fukidasiImagePanel') )
			
			//ピクチャの追加。
			div = document.createElement('div')
			div.innerHTML = new Template( pictureTemplate ).evaluate( {i: picIdx , n: CPTabSeqNo} )
			$('pictureArea').appendChild(div)
			
			$( 'pictureConpane' + picIdx ).show()
			pictureDraggablize( picIdx )

			addCPTab( picIdx , "picture" )
			
			if( ! makeEmpty ){
				//MIPの一番先頭をデフォルトにする。
				settingPicture( selectedMIPIdx )
				openIP( true )
			}

			//zIndexをセット。
			var zIndex = frontZIndex()
			$( 'pictureZIndex' + picIdx ).value = zIndex
			$( 'picture' + picIdx ).style.zIndex = zIndex

			pictureResizerDraggablize()
		}
	}
}

function addFukidasi( makeEmpty ){
	fukidasiIdx++

	//エフェクトコンパネの追加。	
	var div = document.createElement('div')
	div.id = 'fukidasiConpane' + fukidasiIdx
	div.style.zIndex = 0
	div.className = 'pictureConpane'
	div.innerHTML += new Template( fukidasiConpane ).evaluate( {i: fukidasiIdx} )
	$( 'CPWMain' ).insertBefore( div , $('fukidasiImagePanel') )
	
	//エフェクトオブジェクトの追加。	
	div = document.createElement('div')
	tpl = new Template( fukidasiTemplate )
	div.innerHTML = tpl.evaluate( {i:fukidasiIdx , n: CPTabSeqNo} )
	$('fukidasiArea').appendChild(div)
	
	addCPTab( fukidasiIdx , "fukidasi" )

	fukidasiDraggablize( fukidasiIdx )
	
	if( ! makeEmpty ) settingFukidasi( 0 )

	//zIndexをセット。
	var zIndex = frontZIndex()
	var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
	$( 'fukidasiZIndex' + typeIdx ).value = zIndex
	$( 'fukidasi' + typeIdx ).style.zIndex = zIndex

	fukidasiResizerDraggablize()
}

function selectMIPImage( that , i ){
	if( selectMIPImage.clicked ) selectMIPImage.clicked.style.borderColor = 'black'
	if( bgFlg ){
		$('koma').style.background = 'url(' + getSrcFromTMN( $('mainImage' + i).src ) + ')'
		$('bgConpaneImageDiv').style.background = 'url(' + $('mainImage' + i).src + ')'
		$('bgImageID').value = getExtensionRemoved(getFileName($('mainImage' + i).src))
		$('bgColorHidden').value = ''
	}
	else{
		$( 'pictureImage' + $('CPTab' + CPActiveTabIdx).typeIdx ).hide()
		settingPicture(i)
	}
	that.style.borderColor = 'orange'
	selectMIPImage.clicked = that
	selectedMIPIdx = i
}

/************************************************************
 * 画像が選択された時にパラメータをセットする。
 * このメソッドを変更した際は、以下の２メソッドにも影響が及ぶ可能性が高い。
 * savePicture：キャンセル時のために元のパラメータを保存しておく。
 * loadPicture：キャンセル時に元のパラメータを復元。
*************************************************************/
function settingPicture(i){
	var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
	
	$( 'pictureImage' + typeIdx ).style.width = $F( 'imageWidth' + i )
	$( 'pictureImage' + typeIdx ).style.height = $F( 'imageHeight' + i )
	$( 'pictureImage' + typeIdx ).defWidth = $F( 'imageWidth' + i )
	$( 'pictureImage' + typeIdx ).defHeight = $F( 'imageHeight' + i )
	$( 'pictureImage' + typeIdx ).ratio = cutPX($F( 'imageHeight' + i )) / cutPX($F( 'imageWidth' + i ))
	$( 'pictureWidth' + typeIdx ).value = cutPX($F( 'imageWidth' + i ))
	$( 'pictureHeight' + typeIdx ).value = cutPX($F( 'imageHeight' + i ))
	
	$( 'pictureImage' + typeIdx ).src = getSrcFromTMN( $('mainImage' + i).src )
	$( 'pictureConpaneImage' + typeIdx ).src = $('mainImage' + i).src
	$( 'CPTabImage' + CPActiveTabIdx ).src = $('mainImage' + i).src
	$( 'pictureImageID' + typeIdx ).value = getExtensionRemoved(getFileName($('mainImage' + i).src))
	
	var top = cutPX($( 'pictureImage' + typeIdx ).style.top)
	var left = cutPX($( 'pictureImage' + typeIdx ).style.left)

	$( 'pictureImageResizer1_' + typeIdx ).style.top = top
	$( 'pictureImageResizer1_' + typeIdx ).style.left = left
	$( 'pictureImageResizer2_' + typeIdx ).style.top = top
	$( 'pictureImageResizer2_' + typeIdx ).style.left = left + cutPX($F( 'imageWidth' + i )) - resizerSize
	$( 'pictureImageResizer3_' + typeIdx ).style.top = top + cutPX($F( 'imageHeight' + i )) - resizerSize
	$( 'pictureImageResizer3_' + typeIdx ).style.left = left + cutPX($F( 'imageWidth' + i )) - resizerSize
	$( 'pictureImageResizer4_' + typeIdx ).style.top = top + cutPX($F( 'imageHeight' + i )) - resizerSize
	$( 'pictureImageResizer4_' + typeIdx ).style.left = left

}

function settingFukidasi(i){
	var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
	
	var top = cutPX($( 'fukidasiImage' + typeIdx ).style.top)
	var left = cutPX($( 'fukidasiImage' + typeIdx ).style.left)
	
	if( $( 'fukidasi' + typeIdx ).widthPower == null && $( 'fukidasi' + typeIdx ).heightPower == null ){
		$( 'fukidasi' + typeIdx ).widthPower = 100
		$( 'fukidasiWidthPower' + typeIdx ).value = 100
		$( 'fukidasi' + typeIdx ).heightPower = 100
		$( 'fukidasiHeightPower' + typeIdx ).value = 100
		
		$( 'fukidasiImage' + typeIdx ).style.width = $F( 'fukidasiImageWidth' + i )
		$( 'fukidasiImage' + typeIdx ).style.height = $F( 'fukidasiImageHeight' + i )
		
		$( 'fukidasiImageResizer1_' + typeIdx ).style.top = top
		$( 'fukidasiImageResizer1_' + typeIdx ).style.left = left
		$( 'fukidasiImageResizer2_' + typeIdx ).style.top = top
		$( 'fukidasiImageResizer2_' + typeIdx ).style.left = left + cutPX($F( 'fukidasiImageWidth' + i )) - resizerSize
		$( 'fukidasiImageResizer3_' + typeIdx ).style.top = top + cutPX($F( 'fukidasiImageHeight' + i )) - resizerSize
		$( 'fukidasiImageResizer3_' + typeIdx ).style.left = left + cutPX($F( 'fukidasiImageWidth' + i )) - resizerSize
		$( 'fukidasiImageResizer4_' + typeIdx ).style.top = top + cutPX($F( 'fukidasiImageHeight' + i )) - resizerSize
		$( 'fukidasiImageResizer4_' + typeIdx ).style.left = left
	}
	else{
		var widthPower = Math.round( 100 * cutPX( $( 'fukidasiImage' + typeIdx ).style.width ) / cutPX( $F( 'fukidasiImageWidth' + i ) ) )
		$( 'fukidasi' + typeIdx ).widthPower = widthPower
		$( 'fukidasiWidthPower' + typeIdx ).value = widthPower
		
		var heightPower = Math.round( 100 * cutPX( $( 'fukidasiImage' + typeIdx ).style.height ) / cutPX( $F( 'fukidasiImageHeight' + i ) ) ) 
		$( 'fukidasi' + typeIdx ).heightPower = heightPower
		$( 'fukidasiHeightPower' + typeIdx ).value = heightPower
	}

	$( 'fukidasiImage' + typeIdx ).src = fukidasiImageSrc[i]
	
	$( 'fukidasi' + typeIdx ).defWidth = $F( 'fukidasiImageWidth' + i )
	$( 'fukidasi' + typeIdx ).defHeight = $F( 'fukidasiImageHeight' + i )

	$( 'serifTable' + typeIdx ).style.width =
		Math.round( cutPX( $F( 'fukidasiImageTextWidth' + i ) ) * $( 'fukidasi' + typeIdx ).widthPower / 100 )
	$( 'serifTable' + typeIdx ).style.height =
		Math.round( cutPX( $F( 'fukidasiImageTextHeight' + i ) ) * $( 'fukidasi' + typeIdx ).heightPower / 100 )
	$( 'serifTable' + typeIdx ).defWidth = $F( 'fukidasiImageTextWidth' + i )
	$( 'serifTable' + typeIdx ).defHeight = $F( 'fukidasiImageTextHeight' + i )
	$( 'serifTable' + typeIdx ).style.top =
		Math.round( cutPX( $F( 'fukidasiImageTop' + i ) ) * $( 'fukidasi' + typeIdx ).heightPower / 100 ) + cutPX( $( 'fukidasiImage' + typeIdx ).style.top )
	$( 'serifTable' + typeIdx ).style.left =
		Math.round( cutPX( $F( 'fukidasiImageLeft' + i ) ) * $( 'fukidasi' + typeIdx ).widthPower / 100 ) + cutPX( $( 'fukidasiImage' + typeIdx ).style.left )
	$( 'serifTable' + typeIdx ).defTop = $F( 'fukidasiImageTop' + i )
	$( 'serifTable' + typeIdx ).defLeft = $F( 'fukidasiImageLeft' + i )

	$( 'fukidasiImageID' + typeIdx ).value = $F( 'fukidasiImageIDOnImagePanel' + i )
	$( 'textTopOffset' + typeIdx ).value = cutPX($F( 'fukidasiImageTop' + i ))
	$( 'textLeftOffset' + typeIdx ).value = cutPX($F( 'fukidasiImageLeft' + i ))
	$( 'fukidasiWay' + typeIdx ).value = 0
	
	if( $F( 'fukidasiImageFontColor' + i ) != '' ){
		$( 'fukidasiFontColor' + typeIdx ).value = $F( 'fukidasiImageFontColor' + i )
		$('serifTd' + typeIdx).style.color = $F( 'fukidasiImageFontColor' + i )
	}
	else{
		$( 'fukidasiFontColor' + typeIdx ).value = 'black'
		$('serifTd' + typeIdx).style.color = 'black'
	}
	$( 'fukidasiOverConpane' + typeIdx ).style.top = top + 20
	$( 'fukidasiOverConpane' + typeIdx ).style.left = cutPX($F( 'fukidasiImageWidth' + i )) / 2 - fukidasiConpaneOverSize / 2 + left
}

/*
function settingFukidasi(i){
	var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
	
	var top = cutPX($( 'fukidasiImage' + typeIdx ).style.top)
	var left = cutPX($( 'fukidasiImage' + typeIdx ).style.left)
	
	if( $( 'fukidasiImage' + typeIdx ).widthPower == null && $( 'fukidasiImage' + typeIdx ).heightPower == null ){
		$( 'fukidasiImage' + typeIdx ).widthPower = 100
		$( 'fukidasiWidthPower' + typeIdx ).value = 100
		$( 'fukidasiImage' + typeIdx ).heightPower = 100
		$( 'fukidasiHeightPower' + typeIdx ).value = 100
		
		$( 'fukidasiImage' + typeIdx ).style.width = $F( 'fukidasiImageWidth' + i )
		$( 'fukidasiImage' + typeIdx ).style.height = $F( 'fukidasiImageHeight' + i )
		
		$( 'fukidasiImageResizer1_' + typeIdx ).style.top = top
		$( 'fukidasiImageResizer1_' + typeIdx ).style.left = left
		$( 'fukidasiImageResizer2_' + typeIdx ).style.top = top
		$( 'fukidasiImageResizer2_' + typeIdx ).style.left = left + cutPX($F( 'fukidasiImageWidth' + i )) - resizerSize
		$( 'fukidasiImageResizer3_' + typeIdx ).style.top = top + cutPX($F( 'fukidasiImageHeight' + i )) - resizerSize
		$( 'fukidasiImageResizer3_' + typeIdx ).style.left = left + cutPX($F( 'fukidasiImageWidth' + i )) - resizerSize
		$( 'fukidasiImageResizer4_' + typeIdx ).style.top = top + cutPX($F( 'fukidasiImageHeight' + i )) - resizerSize
		$( 'fukidasiImageResizer4_' + typeIdx ).style.left = left
	}
	else{
		var widthPower = Math.round( 100 * cutPX( $( 'fukidasiImage' + typeIdx ).style.width ) / cutPX( $F( 'fukidasiImageWidth' + i ) ) )
		$( 'fukidasiImage' + typeIdx ).widthPower = widthPower
		$( 'fukidasiWidthPower' + typeIdx ).value = widthPower
		
		var heightPower = Math.round( 100 * cutPX( $( 'fukidasiImage' + typeIdx ).style.height ) / cutPX( $F( 'fukidasiImageHeight' + i ) ) ) 
		$( 'fukidasiImage' + typeIdx ).heightPower = heightPower
		$( 'fukidasiHeightPower' + typeIdx ).value = heightPower
	}

	$( 'fukidasiImage' + typeIdx ).src = fukidasiImageSrc[i]
	
	$( 'fukidasi' + typeIdx ).defWidth = $F( 'fukidasiImageWidth' + i )
	$( 'fukidasi' + typeIdx ).defHeight = $F( 'fukidasiImageHeight' + i )

	$( 'serifTable' + typeIdx ).style.width =
		Math.round( cutPX( $F( 'fukidasiImageTextWidth' + i ) ) * $( 'fukidasiImage' + typeIdx ).widthPower / 100 )
	$( 'serifTable' + typeIdx ).style.height =
		Math.round( cutPX( $F( 'fukidasiImageTextHeight' + i ) ) * $( 'fukidasiImage' + typeIdx ).heightPower / 100 )
	$( 'serifTable' + typeIdx ).defWidth = $F( 'fukidasiImageTextWidth' + i )
	$( 'serifTable' + typeIdx ).defHeight = $F( 'fukidasiImageTextHeight' + i )
	$( 'serifTable' + typeIdx ).style.top =
		Math.round( cutPX( $F( 'fukidasiImageTop' + i ) ) * $( 'fukidasiImage' + typeIdx ).heightPower / 100 ) + cutPX( $( 'fukidasiImage' + typeIdx ).style.top )
	$( 'serifTable' + typeIdx ).style.left =
		Math.round( cutPX( $F( 'fukidasiImageLeft' + i ) ) * $( 'fukidasiImage' + typeIdx ).widthPower / 100 ) + cutPX( $( 'fukidasiImage' + typeIdx ).style.left )
	$( 'serifTable' + typeIdx ).defTop = $F( 'fukidasiImageTop' + i )
	$( 'serifTable' + typeIdx ).defLeft = $F( 'fukidasiImageLeft' + i )

	$( 'fukidasiImageID' + typeIdx ).value = $F( 'fukidasiImageIDOnImagePanel' + i )
	$( 'textTopOffset' + typeIdx ).value = cutPX($F( 'fukidasiImageTop' + i ))
	$( 'textLeftOffset' + typeIdx ).value = cutPX($F( 'fukidasiImageLeft' + i ))
	$( 'fukidasiWay' + typeIdx ).value = 0
	
	if( $F( 'fukidasiImageFontColor' + i ) != '' ){
		$( 'fukidasiFontColor' + typeIdx ).value = $F( 'fukidasiImageFontColor' + i )
		$('serifTd' + typeIdx).style.color = $F( 'fukidasiImageFontColor' + i )
	}
	else{
		$( 'fukidasiFontColor' + typeIdx ).value = 'black'
		$('serifTd' + typeIdx).style.color = 'black'
	}
	$( 'fukidasiOverConpane' + typeIdx ).style.top = top + 20
	$( 'fukidasiOverConpane' + typeIdx ).style.left = cutPX($F( 'fukidasiImageWidth' + i )) / 2 - fukidasiConpaneOverSize / 2 + left
}
*/

 

function pictureDraggablize( i ){
	if(!i) i = picIdx
	$('picture' + i).draggable = new Draggable(
		'picture' + i,
		{snap:function( x , y ){
			grid = ( $('gridMovement').checked )? $F('gridMovementPX') : 1
			topOffset = y + cutPX($('pictureImage' + i).style.top)
			$('pictureTopOffset' + i).value = topOffset - topOffset % grid
			leftOffset = x + cutPX($('pictureImage' + i).style.left)
			$('pictureLeftOffset' + i).value = leftOffset - leftOffset % grid
			x = x - x % grid
			y = y - y % grid
			return[x,y]
		},
		starteffect:null , endeffect:null}
	)
}

function fukidasiDraggablize( i ){
	if(!i) i = fukidasiIdx
	$('fukidasi' + i).draggable = new Draggable(
		'fukidasi' + i,
		{snap:function( x , y ){
			grid = ( $('gridMovement').checked )? $F('gridMovementPX') : 1
			topOffset = y + cutPX($('fukidasiImage' + i).style.top)
			$('topOffset' + i).value = topOffset - topOffset % grid
			leftOffset = x + cutPX($('fukidasiImage' + i).style.left)
			$('leftOffset' + i).value = leftOffset - leftOffset % grid
			x = x - x % grid
			y = y - y % grid
			return[x,y]
		},
		/* 2009.08.13 グリッドなしの場合の関数
		{snap:function( x , y ){
			$('topOffset' + i).value = y + cutPX($('fukidasiImage' + i).style.top)
			$('leftOffset' + i).value = x + cutPX($('fukidasiImage' + i).style.left)
			return[x,y]
		},
		*/
		starteffect:null , endeffect:null}
	)
}

var shiftKeyPushed = false

function pictureResizerDraggablize( i ){
	if(!i) i = picIdx
	
	<% for( int i = 1 ; i <= 4 ; i++ ){ %>
	Event.observe( $('pictureImageResizer<%=i%>_' + i) , 'mousedown' , function( e ){
		if( e.shiftKey ){
			shiftKeyPushed = true
		} else {
			shiftKeyPushed = false
		}
		picLeftOnMousedown = cutPX($('pictureImage' + i).style.left)
		picTopOnMousedown = cutPX($('pictureImage' + i).style.top)
		picHeightOnMousedown = cutPX($('pictureImage' + i).style.height)
		picWidthOnMousedown = cutPX($('pictureImage' + i).style.width)
	} , false )
	<%}%>
	
	$('pictureImageResizer1_' + i).draggable = new Draggable(
		'pictureImageResizer1_' + i,
		{snap:function( x , y ){
		
			var width = - x + picWidthOnMousedown + picLeftOnMousedown
			/*
			var height = - y + picHeightOnMousedown + picTopOnMousedown
			//比率固定版：var height = Math.round(width * $('pictureImage' + i).ratio)
			*/
			var height = ( shiftKeyPushed )?
				Math.round(width * $('pictureImage' + i).ratio) :
				- y + picHeightOnMousedown + picTopOnMousedown
			/*
			*/
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0
			
			$('pictureImage' + i).style.width = width
			$('pictureImage' + i).style.height = height
			
			//比率固定版：
			if( shiftKeyPushed ){
				y = Math.round( x * $('pictureImage' + i).ratio ) + picTopOnMousedown - Math.round( picLeftOnMousedown * $('pictureImage' + i).ratio )
			}
			
			$('pictureImage' + i).style.top = y
			$('pictureImage' + i).style.left = x
			
			$('pictureWidth' + i).value = width
			$('pictureHeight' + i).value = height
			$('pictureTopOffset' + i).value = y + cutPX($('picture' + i).style.top)
			$('pictureLeftOffset' + i).value = x + cutPX($('picture' + i).style.left)
			
			$('pictureImageResizer1_' + i ).style.top = y
			$('pictureImageResizer2_' + i ).style.top = y
			$('pictureImageResizer4_' + i ).style.left = x
			if( shiftKeyPushed ){
				$('pictureImageResizer3_' + i ).style.top = y + height - resizerSize
				$('pictureImageResizer4_' + i ).style.top = y + height - resizerSize
			}

			return[x,y]
		},
		constraint:'horizontal' ,
		starteffect:null , endeffect:null }
	)
	
	$('pictureImageResizer2_' + i).draggable = new Draggable(
		'pictureImageResizer2_' + i,
		{snap:function( x , y ){
			
			var width =  x + resizerSize - picLeftOnMousedown
			//var height = - y + picHeightOnMousedown + picTopOnMousedown
			//比率固定版：var height = Math.round(width * $('pictureImage' + i).ratio) :
			var height = ( shiftKeyPushed )?
				Math.round(width * $('pictureImage' + i).ratio) :
				- y + picHeightOnMousedown + picTopOnMousedown
		
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0
			
			$('pictureImage' + i).style.width = width
			$('pictureImage' + i).style.height = height
			
			/*比率固定版：
			*/
			if( shiftKeyPushed ){
				y = - Math.round( x * $('pictureImage' + i).ratio ) + picHeightOnMousedown + picTopOnMousedown -
					Math.round( resizerSize * $('pictureImage' + i).ratio ) +
					Math.round( picLeftOnMousedown * $('pictureImage' + i).ratio )
			}
			$('pictureImage' + i).style.top = y
			
			$('pictureWidth' + i).value = width
			$('pictureHeight' + i).value = height
			$('pictureTopOffset' + i).value = y + cutPX($('picture' + i).style.top)
			
			$('pictureImageResizer1_' + i ).style.top = y
			$('pictureImageResizer2_' + i ).style.top = y
			$('pictureImageResizer3_' + i ).style.left = x
			$('pictureImageResizer3_' + i ).style.top = picHeightOnMousedown + picTopOnMousedown - resizerSize
			$('pictureImageResizer4_' + i ).style.top = picHeightOnMousedown + picTopOnMousedown - resizerSize
			/*
			if( shiftKeyPushed ){
				$('pictureImageResizer3_' + i ).style.top = y + height
				$('pictureImageResizer4_' + i ).style.top = y + height
			}
			*/
			
			return[x,y]
		},
		constraint:'horizontal' ,
		starteffect:null , endeffect:null }
	)
	
	$('pictureImageResizer3_' + i).draggable = new Draggable(
		'pictureImageResizer3_' + i,
		{snap:function( x , y ){
		
			var width = x + resizerSize - picLeftOnMousedown
			//var height = y - picTopOnMousedown + resizerSize
			//比率固定版：var height = Math.round(width * $('pictureImage' + i).ratio)

			var height = ( shiftKeyPushed )?
				Math.round(width * $('pictureImage' + i).ratio) :
				y - picTopOnMousedown + resizerSize
			
			
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0
			
			$('pictureImage' + i).style.width = width
			$('pictureImage' + i).style.height = height
			
			$('pictureWidth' + i).value = width
			$('pictureHeight' + i).value = height
			
			$('pictureImageResizer2_' + i ).style.left = x
			$('pictureImageResizer3_' + i ).style.top = height - resizerSize + picTopOnMousedown
			$('pictureImageResizer4_' + i ).style.top =  height - resizerSize + picTopOnMousedown
			return[x,y]
		},
		constraint:'horizontal' ,
		starteffect:null , endeffect:null }
	)
	
	$('pictureImageResizer4_' + i).draggable = new Draggable(
		'pictureImageResizer4_' + i,
		{snap:function( x , y ){
			
			var width = picWidthOnMousedown - x + picLeftOnMousedown
			//var height = y - picTopOnMousedown + resizerSize
			//比率固定版：var height = Math.round(width * $('pictureImage' + i).ratio)

			var height = ( shiftKeyPushed )?
				Math.round(width * $('pictureImage' + i).ratio) :
				y - picTopOnMousedown + resizerSize

			if( width < 0 ) width = 0
			if( height < 0 ) height = 0
			
			$('pictureImage' + i).style.width = width
			$('pictureImage' + i).style.height = height
			$('pictureImage' + i).style.left = x
			
			$('pictureWidth' + i).value = width
			$('pictureHeight' + i).value = height
			$('pictureLeftOffset' + i).value = x + cutPX($('picture' + i).style.left)
			
			$('pictureImageResizer1_' + i ).style.left = x
			$('pictureImageResizer3_' + i ).style.top = height - resizerSize + picTopOnMousedown
			$('pictureImageResizer4_' + i ).style.top = height - resizerSize + picTopOnMousedown
			return[x,y]
		},
		constraint:'horizontal' ,
		starteffect:null , endeffect:null }
	)
	/*
	*/
}
	
function fukidasiResizerDraggablize( i ){
	if(!i) i = fukidasiIdx
	
	<% for( int i = 1 ; i <= 4 ; i++ ){ %>
	Event.observe( $('fukidasiImageResizer<%=i%>_' + i) , 'mousedown' , function(){
		fukiLeftOnMousedown = cutPX($('fukidasiImage' + i).style.left)
		fukiTopOnMousedown = cutPX($('fukidasiImage' + i).style.top)
		fukiHeightOnMousedown = cutPX($('fukidasiImage' + i).style.height)
		fukiWidthOnMousedown = cutPX($('fukidasiImage' + i).style.width)
	} , false )
	<%}%>
	
	$('fukidasiImageResizer1_' + i).draggable = new Draggable(
		'fukidasiImageResizer1_' + i,
		{snap:function( x , y ){
		
			var width = - x + fukiWidthOnMousedown + fukiLeftOnMousedown
			var height = - y + fukiHeightOnMousedown + fukiTopOnMousedown
			
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0

			$('fukidasi' + i).widthPower = Math.round( width / cutPX($('fukidasi' + i).defWidth) * 100 )
			$('fukidasi' + i).heightPower = Math.round( height / cutPX($('fukidasi' + i).defHeight) * 100 )
			
			$('fukidasiWidthPower' + i).value = $('fukidasi' + i).widthPower
			$('fukidasiHeightPower' + i).value = $('fukidasi' + i).heightPower
			
			$('topOffset' + i).value = y + cutPX( $('fukidasi' + i).style.top )
			$('leftOffset' + i).value = x + cutPX( $('fukidasi' + i).style.left )
			
			$('fukidasiImage' + i).style.width = width
			$('fukidasiImage' + i).style.height = height
			$('fukidasiImage' + i).style.left = x
			$('fukidasiImage' + i).style.top = y
			
			$( 'serifTable' + i ).style.width = Math.round( cutPX($( 'serifTable' + i ).defWidth) * $('fukidasi' + i).widthPower / 100 )
			$( 'serifTable' + i ).style.height = Math.round( cutPX($( 'serifTable' + i ).defHeight) * $('fukidasi' + i).heightPower / 100 )
			$( 'serifTable' + i ).style.top = y + Math.round( cutPX($( 'serifTable' + i ).defTop ) * $('fukidasi' + i).heightPower / 100 )
			$( 'serifTable' + i ).style.left = x + Math.round( cutPX($( 'serifTable' + i ).defLeft ) * $('fukidasi' + i).widthPower / 100 )
			
			$('fukidasiImageResizer2_' + i ).style.top = y
			$('fukidasiImageResizer4_' + i ).style.left = x

			$( 'fukidasiOverConpane' + i ).style.top = y + 20
			$( 'fukidasiOverConpane' + i ).style.left = Math.round( width / 2 ) - fukidasiConpaneOverSize / 2 + x
			
			return[x,y]
		},
		starteffect:null , endeffect:null }
	)
	
	$('fukidasiImageResizer2_' + i).draggable = new Draggable(
		'fukidasiImageResizer2_' + i,
		{snap:function( x , y ){
		
			var width = x - fukiLeftOnMousedown + resizerSize
			var height = - y + fukiHeightOnMousedown + fukiTopOnMousedown
			var top = y
			
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0

			$('fukidasi' + i).widthPower = Math.round( width / cutPX($('fukidasi' + i).defWidth) * 100 )
			$('fukidasi' + i).heightPower = Math.round( height / cutPX($('fukidasi' + i).defHeight) * 100 )
			
			$('fukidasiWidthPower' + i).value = $('fukidasi' + i).widthPower
			$('fukidasiHeightPower' + i).value = $('fukidasi' + i).heightPower
			
			$('topOffset' + i).value = top + cutPX( $('fukidasi' + i).style.top )
						
			$('fukidasiImage' + i).style.width = width
			$('fukidasiImage' + i).style.height = height
			$('fukidasiImage' + i).style.top = top
			
			$( 'serifTable' + i ).style.width = Math.round( cutPX($( 'serifTable' + i ).defWidth) * $('fukidasi' + i).widthPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.height = Math.round( cutPX($( 'serifTable' + i ).defHeight) * $('fukidasi' + i).heightPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.top = top + Math.round( cutPX($( 'serifTable' + i ).defTop ) * $('fukidasi' + i).heightPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.left = fukiLeftOnMousedown + Math.round( cutPX($( 'serifTable' + i ).defLeft ) * $('fukidasi' + i).widthPower / 100 ) + 'px'
			
			$('fukidasiImageResizer1_' + i ).style.top = y
			$('fukidasiImageResizer3_' + i ).style.left = x
			
			$( 'fukidasiOverConpane' + i ).style.top = top + 20
			$( 'fukidasiOverConpane' + i ).style.left = - ( Math.round( width / 2 ) ) - resizerSize + x
			
			return[x,y]
		},
		starteffect:null , endeffect:null }
	)
	
	$('fukidasiImageResizer3_' + i).draggable = new Draggable(
		'fukidasiImageResizer3_' + i,
		{snap:function( x , y ){
		
			var width = x - fukiLeftOnMousedown + resizerSize
			var height = y - fukiTopOnMousedown + resizerSize
			
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0

			$('fukidasi' + i).widthPower = Math.round( width / cutPX($('fukidasi' + i).defWidth) * 100 )
			$('fukidasi' + i).heightPower = Math.round( height / cutPX($('fukidasi' + i).defHeight) * 100 )
			
			$('fukidasiWidthPower' + i).value = $('fukidasi' + i).widthPower
			$('fukidasiHeightPower' + i).value = $('fukidasi' + i).heightPower
			
			$('fukidasiImage' + i).style.width = width
			$('fukidasiImage' + i).style.height = height
			
			$( 'serifTable' + i ).style.width = Math.round( cutPX($( 'serifTable' + i ).defWidth) * $('fukidasi' + i).widthPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.height = Math.round( cutPX($( 'serifTable' + i ).defHeight) * $('fukidasi' + i).heightPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.top = fukiTopOnMousedown + Math.round( cutPX($( 'serifTable' + i ).defTop ) * $('fukidasi' + i).heightPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.left = fukiLeftOnMousedown + Math.round( cutPX($( 'serifTable' + i ).defLeft ) * $('fukidasi' + i).widthPower / 100 ) + 'px'
			
			$('fukidasiImageResizer2_' + i ).style.left = x
			$('fukidasiImageResizer4_' + i ).style.top = y
			
			//$( 'fukidasiOverConpane' + i ).style.top = y + 20
			//$( 'fukidasiOverConpane' + i ).style.left = width / 2 - fukidasiConpaneOverSize / 2 + x
			
			//$( 'fukidasiOverConpane' + i ).style.top = top + 20
			//$( 'fukidasiOverConpane' + i ).style.left = - ( Math.round( width / 2 ) ) - resizerSize + x
			
			$( 'fukidasiOverConpane' + i ).style.top = fukiTopOnMousedown + 20
			$( 'fukidasiOverConpane' + i ).style.left = fukiLeftOnMousedown + Math.round( width / 2 ) - fukidasiConpaneOverSize / 2
			
			return[x,y]
		},
		starteffect:null , endeffect:null }
	)
	
	$('fukidasiImageResizer4_' + i).draggable = new Draggable(
		'fukidasiImageResizer4_' + i,
		{snap:function( x , y ){
		
			var width = - x + fukiWidthOnMousedown + fukiLeftOnMousedown
			var height = y - fukiTopOnMousedown + resizerSize
			var left = x
			
			if( width < 0 ) width = 0
			if( height < 0 ) height = 0

			$('fukidasi' + i).widthPower = Math.round( width / cutPX($('fukidasi' + i).defWidth) * 100 )
			$('fukidasi' + i).heightPower = Math.round( height / cutPX($('fukidasi' + i).defHeight) * 100 )

			$('fukidasiWidthPower' + i).value = $('fukidasi' + i).widthPower
			$('fukidasiHeightPower' + i).value = $('fukidasi' + i).heightPower
	
			$('leftOffset' + i).value = left + cutPX( $('fukidasi' + i).style.left )
	
			$('fukidasiImage' + i).style.width = width
			$('fukidasiImage' + i).style.height = height
			$('fukidasiImage' + i).style.left = left
	
			$( 'serifTable' + i ).style.width = Math.round( cutPX($( 'serifTable' + i ).defWidth) * $('fukidasi' + i).widthPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.height = Math.round( cutPX($( 'serifTable' + i ).defHeight) * $('fukidasi' + i).heightPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.top = fukiTopOnMousedown + Math.round( cutPX($( 'serifTable' + i ).defTop ) * $('fukidasi' + i).heightPower / 100 ) + 'px'
			$( 'serifTable' + i ).style.left = left + Math.round( cutPX($( 'serifTable' + i ).defLeft ) * $('fukidasi' + i).widthPower / 100 ) + 'px'
	
			$('fukidasiImageResizer1_' + i ).style.left = x
			$('fukidasiImageResizer3_' + i ).style.top = y
			
			//test1(Math.round( width / 2 ) - fukidasiConpaneOverSize / 2 + x)
			
			$( 'fukidasiOverConpane' + i ).style.top = fukiTopOnMousedown + 20
			$( 'fukidasiOverConpane' + i ).style.left = Math.round( width / 2 ) - fukidasiConpaneOverSize / 2 + x
			
			return[x,y]
		},
		starteffect:null , endeffect:null }
	)
}

function picVanishChange( i , val ){
	var vanishSec = eval($('picVanishBox'+i).value) + val
	if( vanishSec < 0 ) return;
	$('picVanishBox'+i).value = vanishSec
	$('picVanishHidden'+i).value = ( vanishSec * 10 )
}

function picVanishFunc( that , i ){
	try{$( 'picVanishHidden' + i ).value = that.value * 10}
	catch(e){$( 'picVanishHidden' + i ).value = 0}
}

function picDelayChange( i , val ){
	var delaySec = eval($('picDelayBox'+i).value) + val
	if( delaySec < 0 ) return;
	$('picDelayBox'+i).value = delaySec
	$('picDelayHidden'+i).value = ( delaySec * 10 )
}

function picDelayFunc( that , i ){
	try{$( 'picDelayHidden' + i ).value = that.value * 10}
	catch(e){$( 'picDelayHidden' + i ).value = 0}
}

function getMainImagePanel(){
	PPLoadCompleted = false
	if( $F('tagSelect') != "" ) new Ajax.Updater(
		'mainImagePanelInsertArea',
		ROOT + '/mainImagePanelInside.peta',
		{
			method : 'post' , postBody : Form.serialize( 'imageTagForm' ) ,
			onFailure : function(httpobj){alert(httpobj.responseText)},
			onComplete:function(){ PPLoadCompleted = true }
		}
	)
}

function mainImageUpload(){
	$('tagSelect').options[0].selected = true
	if( imageUploadOnSubmit() ){
		$('mainImageUploadForm').submit()
	}
}

function imageUploadOnSubmit(){
	if( !$F('imageFile') ){
		alert('参照ボタンを押して、アップロードする画像ファイルを指定して下さい。')
		return false
	}
	/* 2008.06.01 不要な気がするのでコメントアウト。
	else if( imageUploadOnSubmit.sendedImage == $F('imageFile') ){
		alert('さっきと同じ画像になってますよ。')
		return false
	}*/
	
	else{
		var ext = getExtension($F('imageFile')).toLowerCase()
		if( ext == 'gif' || ext == 'jpg' || ext == 'jpeg' ){
			$('tagSelect').options[0].selected = true
			imageUploadOnSubmit.sendedImage = $F('imageFile')
			return true
		}
		else{
			alert('申し訳ないけどgif、jpg、jpegの画像にしか対応してません。')
			return false
		}
	}
}

function openIP( newFlg , bgFlgArg ){
	$('IP').newFlg = newFlg
	bgFlg = bgFlgArg
	$('makeKomaShutter').style.height = basicMakeKomaShutterHeight + cutPX( $('koma').style.height )
	$('makeKomaShutter').show()
	if( bgFlg ) saveBG()
	else savePicture()
	$('IP').obj.show()
}

function decideIP(){
	$('makeKomaShutter').hide()
	$('IP').obj.hide()
	bgFlg = false
}

function cancelIP(){
	if( bgFlg ) restoreBG()
	else{
		if( $('IP').newFlg ) eraseObject()
		else loadPicture()
	}
	$('makeKomaShutter').hide()
	$('IP').obj.hide()
	bgFlg = false
}

function savePicture(){
	var memento = new Object()
	var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
	
	memento.styleWidth = $( 'pictureImage' + typeIdx ).style.width
	memento.styleHeight = $( 'pictureImage' + typeIdx ).style.height
	memento.defWidth = $( 'pictureImage' + typeIdx ).defWidth
	memento.defHeight = $( 'pictureImage' + typeIdx ).defHeight
	memento.ratio = $( 'pictureImage' + typeIdx ).ratio
	memento.widthValue = $( 'pictureWidth' + typeIdx ).value
	memento.heightValue = $( 'pictureHeight' + typeIdx ).value
	
	memento.src = $( 'pictureImage' + typeIdx ).src
	memento.conpaneSrc = $( 'pictureConpaneImage' + typeIdx ).src
	memento.tabSrc = $( 'CPTabImage' + CPActiveTabIdx ).src
	memento.imageID = $( 'pictureImageID' + typeIdx ).value
	
	<% for( int i = 1 ; i <= 4 ; i++ ){ %>
		memento.resizerLeft<%=i%> = $( 'pictureImageResizer<%=i%>_' + typeIdx ).style.left
		memento.resizerTop<%=i%> = $( 'pictureImageResizer<%=i%>_' + typeIdx ).style.top
	<%}%> 
	$('IP').memento = memento
}

function makePictureMemento( pic ){
	var memento = null
	memento = new Object()
	
	var width = pic.width
	var height = pic.height
	
	memento.styleWidth = width
	memento.styleHeight = height
	memento.defWidth = pic.image.width
	memento.defHeight = pic.image.height
	//2008.07.08 ratioは今使ってないので実装放棄。 $( 'pictureImage' + typeIdx ).ratio = memento.ratio
	
	memento.widthValue = width
	memento.heightValue = height
	
	memento.src = ROOT + pic.image.src
	memento.conpaneSrc = pic.image.tmnSrc
	memento.tabSrc = pic.image.tmnSrc
	memento.imageID = pic.imageID
	
	var left = pic.leftOffset
	var top = pic.topOffset

	memento.styleLeft = left
	memento.styleTop = top
	
	memento.resizer1Left = left 
	memento.resizer1Top = top
	memento.resizer2Left = left + width - resizerSize
	memento.resizer2Top = top
	memento.resizer3Left = left + width - resizerSize
	memento.resizer3Top = top + height - resizerSize
	memento.resizer4Left = left
	memento.resizer4Top = top + height - resizerSize

	return memento
}

function putKoma( koma ){
	/*
	for( i = 0 ; i < koma.picture.length ; i++ ){
		putPicture( koma.picture[i] )
	}
	for( i = 0 ; i < koma.fukidasi.length ; i++ ){
		putFukidasi( koma.fukidasi[i] )
	}
	*/
	var zIndexRev = new Number( CPTabQuantity )
	
	for( fuki in koma.fukidasi ) putFukidasi( koma.fukidasi[fuki] , zIndexRev )
	for( pic in koma.picture ) putPicture( koma.picture[pic] , zIndexRev )
	
	$('komaHeight').value = koma.komaHeight
	$('komaHeightTextBox').value = koma.komaHeight
	$('koma').style.height = koma.komaHeight + IER
	$('KHC').style.top = koma.komaHeight + 1
	$('koma').style.background = 'url(' + ROOT + koma.bgImageSrc + ')'
	$('bgConpaneImageDiv').style.background = 'url(' + koma.bgImageTmnSrc + ')'
	$('bgImageID').value = koma.bgImageID
	if( koma.borderFlg != '1'){
		$('borderFlg').checked = false
		switchBorder($('borderFlg'))
	}
}


function putKomaOnJSP(){
	<% if( editTargetKoma != null ) {%>
		<% request.setAttribute( "editTargetKoma" , editTargetKoma ); %>
		
		<logic:iterate id="pic" name="editTargetKoma" property="pictureList" type="peta.dao.Picture">
			putPicture( <%=pic.getJSON()%> )
		</logic:iterate>
		<logic:iterate id="fuki" name="editTargetKoma" property="fukidasiList" type="peta.dao.Fukidasi">
			putFukidasi( <%=fuki.getJSON()%> )
		</logic:iterate>
		
		var koma = <%= editTargetKoma.getJSON() %>
		
		$('komaHeight').value = koma.komaHeight
		$('komaHeightTextBox').value = koma.komaHeight
		$('koma').style.height = koma.komaHeight + IER
		$('KHC').style.top = koma.komaHeight + 1
		$('koma').style.background = 'url(' + ROOT + koma.bgImageSrc + ')'
		$('bgConpaneImageDiv').style.background = 'url(' + koma.bgImageTmnSrc + ')'
		$('bgImageID').value = koma.bgImageID
		if( koma.borderFlg != '1'){
			$('borderFlg').checked = false
			switchBorder($('borderFlg'))
		}
	<% } %>
}

function paste(){
	if( copingObject ) eval( 'put' + copingObject.type + '( copingObject )' )
}

function copyKoma( seqNO ){
	copingObject = $( seqNO ).JSObj
}

function copyPicture( typeIdx ){
	var pic = new Object()
	pic.type = 'Picture'
	pic.image =  new Object()
	
	pic.width = cutPX($( 'pictureImage' + typeIdx ).style.width)
	pic.height = cutPX($( 'pictureImage' + typeIdx ).style.height)
	
	pic.image.width = $( 'pictureImage' + typeIdx ).defWidth 
	pic.image.height = $( 'pictureImage' + typeIdx ).defHeight
	
	pic.image.src = $( 'pictureImage' + typeIdx ).src.replace('<%=peta.定数.ぺったんURL%>','')
	pic.image.tmnSrc = $( 'pictureConpaneImage' + typeIdx ).src
	pic.imageID = $( 'pictureImageID' + typeIdx ).value
	
	pic.link = $( 'pictureLink' + typeIdx ).value
	
	pic.leftOffset = 1
	pic.topOffset = 1

	copingObject = pic
}

function copyFukidasi( typeIdx ){
	var fuki = new Object()
	fuki.type = 'Fukidasi'
	fuki.image = new Object()
	
	fuki.topOffset = 1
	fuki.leftOffset = 1
	
	fuki.widthPower = $( 'fukidasi' + typeIdx ).widthPower
	fuki.heightPower = $( 'fukidasi' + typeIdx ).heightPower
	
	fuki.width = cutPX($( 'fukidasiImage' + typeIdx ).style.width)
	fuki.height = cutPX($( 'fukidasiImage' + typeIdx ).style.height)
	fuki.image.width = cutPX($( 'fukidasi' + typeIdx ).defWidth )
	fuki.image.height = cutPX($( 'fukidasi' + typeIdx ).defHeight )

	fuki.src = $( 'fukidasiImage' + typeIdx ).src.replace('<%=peta.定数.ぺったんURL%>','')
	
	fuki.image.textWidth = cutPX( $( 'serifTable' + typeIdx ).defWidth )
	fuki.image.textHeight = cutPX( $( 'serifTable' + typeIdx ).defHeight )
	
	fuki.fukidasiImageID = $( 'fukidasiImageID' + typeIdx ).value
	fuki.way = new Number( $( 'fukidasiWay' + typeIdx ).value )

	fuki.textTopOffset = new Number( $( 'textTopOffset' + typeIdx ).value )
	fuki.textLeftOffset = new Number( $( 'textLeftOffset' + typeIdx ).value )
	fuki.image.textTopOffset = new Number( $( 'textTopOffset' + typeIdx ).value )
	fuki.image.textLeftOffset = new Number( $( 'textLeftOffset' + typeIdx ).value )

	fuki.serif = $( 'serifBox' + typeIdx ).value
	fuki.fontColor = $( 'fukidasiFontColor' + typeIdx ).value
	fuki.fontSize = $( 'fukidasiFontSize' + typeIdx ).value
	fuki.textAlign = $( 'fukidasiTextAlign' + typeIdx ).value

	if( $( 'boldFont' + typeIdx ).checked ) fuki.fontWeight = 'bold'

	/*
	$( 'fukidasiFontColor' + typeIdx ).value = fuki.fontColor
	$( 'serifTd' + typeIdx ).style.color = fuki.fontColor

	$( 'serifTd' + typeIdx ).style.textAlign = fuki.textAlign
	
	if( fuki.fontWeight == 'bold' ){
		$( 'boldFont' + typeIdx ).checked = true
		$( 'serifTd' + typeIdx ).style.fontWeight = 'bold'
	}
	*/

	/*
	$( 'serifTable' + typeIdx ).style.top = Math.round( fuki.image.textTopOffset * fuki.heightPower / 100 )
	$( 'serifTable' + typeIdx ).style.left = Math.round( fuki.image.textLeftOffset * fuki.widthPower / 100 )
	$( 'serifTable' + typeIdx ).defTop = fuki.image.textTopOffset
	$( 'serifTable' + typeIdx ).defLeft = fuki.image.textLeftOffset
	*/
	
	/*
	var zIndex = fuki.zIndex + zIndexRev
	
	$( 'fukidasi' + typeIdx ).style.zIndex = zIndex
	$( 'fukidasiZIndex' + typeIdx ).value = zIndex
	$( 'fukidasiImageResizer1_' + typeIdx ).style.zIndex = zIndex
	$( 'fukidasiImageResizer2_' + typeIdx ).style.zIndex = zIndex
	$( 'fukidasiImageResizer3_' + typeIdx ).style.zIndex = zIndex
	$( 'fukidasiImageResizer4_' + typeIdx ).style.zIndex = zIndex
	$( 'serifTable' + typeIdx ).style.zIndex = zIndex
	$( 'fukidasiOverConpane' + typeIdx ).style.zIndex = zIndex
	*/
	
	copingObject = fuki
}

function putPicture( pic , zIndexRev ){
	if( zIndexRev == null ) zIndexRev = 0
	
	addPicture( true )
	var typeIdx = $( 'CPTab' + CPActiveTabIdx ).typeIdx
	
	var width = pic.width
	var height = pic.height
	
	$( 'pictureImage' + typeIdx ).style.width = width
	$( 'pictureImage' + typeIdx ).style.height = height
	$( 'pictureImage' + typeIdx ).defWidth = pic.image.width
	$( 'pictureImage' + typeIdx ).defHeight = pic.image.height
	
	if( pic.zIndex ){
		var zIndex = pic.zIndex + zIndexRev
		$( 'picture' + typeIdx ).style.zIndex = zIndex
		$( 'pictureZIndex' + typeIdx ).value = zIndex
		$( 'pictureImageResizer1_' + typeIdx ).style.zIndex = zIndex
		$( 'pictureImageResizer2_' + typeIdx ).style.zIndex = zIndex
		$( 'pictureImageResizer3_' + typeIdx ).style.zIndex = zIndex
		$( 'pictureImageResizer4_' + typeIdx ).style.zIndex = zIndex
	}
	
	$( 'pictureWidth' + typeIdx ).value = width
	$( 'pictureHeight' + typeIdx ).value = height
	
	$( 'pictureImage' + typeIdx ).src = ROOT + pic.image.src
	$( 'pictureConpaneImage' + typeIdx ).src = pic.image.tmnSrc
	$( 'CPTabImage' + CPActiveTabIdx ).src = pic.image.tmnSrc
	$( 'pictureImageID' + typeIdx ).value = pic.imageID
	
	$( 'pictureLink' + typeIdx ).value = pic.link
	
	var left = pic.leftOffset
	var top = pic.topOffset

	$( 'pictureImage' + typeIdx ).style.top = top
	$( 'pictureImage' + typeIdx ).style.left = left
	$( 'pictureTopOffset' + typeIdx ).value = top
	$( 'pictureLeftOffset' + typeIdx ).value = left

	$( 'pictureImageResizer1_' + typeIdx ).style.left = left
	$( 'pictureImageResizer1_' + typeIdx ).style.top = top
	$( 'pictureImageResizer2_' + typeIdx ).style.left = left + width - resizerSize
	$( 'pictureImageResizer2_' + typeIdx ).style.top = top
	$( 'pictureImageResizer3_' + typeIdx ).style.left = left + width - resizerSize
	$( 'pictureImageResizer3_' + typeIdx ).style.top = top + height - resizerSize
	$( 'pictureImageResizer4_' + typeIdx ).style.left = left
	$( 'pictureImageResizer4_' + typeIdx ).style.top = top + height - resizerSize
}

function putFukidasi( fuki , zIndexRev ){
	
	//showProps( fuki )
	
	if( zIndexRev == null ) zIndexRev = 0

	addFukidasi( true )
	var typeIdx = $('CPTab' + CPActiveTabIdx).typeIdx
	
	var top = fuki.topOffset
	var left = fuki.leftOffset
	
	$( 'fukidasi' + typeIdx ).widthPower = fuki.widthPower
	$( 'fukidasiWidthPower' + typeIdx ).value = fuki.widthPower
	$( 'fukidasi' + typeIdx ).heightPower = fuki.heightPower
	$( 'fukidasiHeightPower' + typeIdx ).value = fuki.heightPower
	
	$( 'fukidasiImage' + typeIdx ).style.width = fuki.width
	$( 'fukidasiImage' + typeIdx ).style.height = fuki.height
	$( 'fukidasi' + typeIdx ).defWidth = fuki.image.width + 'px'
	$( 'fukidasi' + typeIdx ).defHeight = fuki.image.height + 'px'
	
	$( 'fukidasi' + typeIdx ).style.top = top
	$( 'topOffset' + typeIdx ).value = top
	$( 'fukidasi' + typeIdx ).style.left = left
	$( 'leftOffset' + typeIdx ).value = left
	
	$( 'fukidasiImageResizer1_' + typeIdx ).style.top = 0
	$( 'fukidasiImageResizer1_' + typeIdx ).style.left = 0
	$( 'fukidasiImageResizer2_' + typeIdx ).style.top = 0
	$( 'fukidasiImageResizer2_' + typeIdx ).style.left = - resizerSize + fuki.width
	$( 'fukidasiImageResizer3_' + typeIdx ).style.top = - resizerSize + fuki.height
	$( 'fukidasiImageResizer3_' + typeIdx ).style.left = - resizerSize + fuki.width
	$( 'fukidasiImageResizer4_' + typeIdx ).style.top = - resizerSize + fuki.height
	$( 'fukidasiImageResizer4_' + typeIdx ).style.left = 0
		
	$( 'fukidasiImage' + typeIdx ).src = ROOT + fuki.src
	
	$( 'serifTable' + typeIdx ).style.width = Math.round( fuki.image.textWidth * fuki.widthPower / 100 )
	$( 'serifTable' + typeIdx ).style.height = Math.round( fuki.image.textHeight * fuki.heightPower / 100 )
	$( 'serifTable' + typeIdx ).defWidth = fuki.image.textWidth
	$( 'serifTable' + typeIdx ).defHeight = fuki.image.textHeight

	$( 'serifTable' + typeIdx ).style.top = Math.round( fuki.image.textTopOffset * fuki.heightPower / 100 )
	$( 'serifTable' + typeIdx ).style.left = Math.round( fuki.image.textLeftOffset * fuki.widthPower / 100 )
	$( 'serifTable' + typeIdx ).defTop = fuki.image.textTopOffset
	$( 'serifTable' + typeIdx ).defLeft = fuki.image.textLeftOffset
	
	$( 'serifBox' + typeIdx ).value = fuki.serif
	syncTextLogic( typeIdx )
	
	$( 'fukidasiImageID' + typeIdx ).value = fuki.fukidasiImageID
	$( 'textTopOffset' + typeIdx ).value = fuki.textTopOffset
	$( 'textLeftOffset' + typeIdx ).value = fuki.textLeftOffset
	$( 'fukidasiWay' + typeIdx ).value = fuki.way
	
	$( 'fukidasiFontColor' + typeIdx ).value = fuki.fontColor
	$( 'serifTd' + typeIdx ).style.color = fuki.fontColor
	
	$( 'fukidasiOverConpane' + typeIdx ).style.top = 20
	$( 'fukidasiOverConpane' + typeIdx ).style.left = fuki.width / 2 - fukidasiConpaneOverSize / 2
	
	if( fuki.zIndex ){
		var zIndex = fuki.zIndex + zIndexRev
		
		$( 'fukidasi' + typeIdx ).style.zIndex = zIndex
		$( 'fukidasiZIndex' + typeIdx ).value = zIndex
		$( 'fukidasiImageResizer1_' + typeIdx ).style.zIndex = zIndex
		$( 'fukidasiImageResizer2_' + typeIdx ).style.zIndex = zIndex
		$( 'fukidasiImageResizer3_' + typeIdx ).style.zIndex = zIndex
		$( 'fukidasiImageResizer4_' + typeIdx ).style.zIndex = zIndex
		$( 'serifTable' + typeIdx ).style.zIndex = zIndex
		$( 'fukidasiOverConpane' + typeIdx ).style.zIndex = zIndex
	}
		
	$( 'fukidasiFontSize' + typeIdx ).value = fuki.fontSize
	$( 'serifTd' + typeIdx ).style.fontSize = fuki.fontSize + "pt";

	$( 'fukidasiFontColor' + typeIdx ).value = fuki.fontColor
	$( 'serifTd' + typeIdx ).style.color = fuki.fontColor

	$( 'fukidasiTextAlign' + typeIdx ).value = fuki.textAlign
	$( 'serifTd' + typeIdx ).style.textAlign = fuki.textAlign
	
	if( fuki.fontWeight == 'bold' ){
		$( 'boldFont' + typeIdx ).checked = true
		$( 'serifTd' + typeIdx ).style.fontWeight = 'bold'
	}
}

function loadPicture(){
	var memento = $('IP').memento 
	var typeIdx = $('CPTab' + CPActiveTabIdx ).typeIdx
	
	$( 'pictureImage' + typeIdx ).style.width = memento.styleWidth
	$( 'pictureImage' + typeIdx ).style.height = memento.styleHeight
	$( 'pictureImage' + typeIdx ).defWidth = memento.defWidth
	$( 'pictureImage' + typeIdx ).defHeight = memento.defHeight
	$( 'pictureImage' + typeIdx ).ratio = memento.ratio
	
	$( 'pictureWidth' + typeIdx ).value = memento.widthValue
	$( 'pictureHeight' + typeIdx ).value = memento.heightValue
	  
	$( 'pictureImage' + typeIdx ).src = memento.src
	$( 'pictureConpaneImage' + typeIdx ).src = memento.conpaneSrc
	$( 'CPTabImage' + CPActiveTabIdx ).src = memento.tabSrc
	$( 'pictureImageID' + typeIdx ).value = memento.imageID
}

function saveBG(){
	var memento = new Object()
	memento.bg = $('koma').style.background
	memento.companeBg = $('bgConpaneImageDiv').style.background
	memento.bgImageID = $('bgImageID').value
	memento.bgColor = $('bgColorHidden').value
	$('IP').memento = memento
}

function restoreBG(){
	var memento = $('IP').memento
	$('koma').style.background = memento.bg
	$('bgConpaneImageDiv').style.background = memento.companeBg
	$('bgImageID').value = memento.bgImageID
	$('bgColorHidden').value = memento.bgColor
}


function attachLink( that ){
	var d = document
	var w = window
	var t = ''
	if(d.selection) t = d.selection.createRange().text
	else if(w.selection) t = w.selection.createRange().text
	else if(w.getSelection) t = w.getSelection()
	else if(d.getSelection) t = d.getSelection()
	alert(t)
}

/*
function fukidasiFlash(i){
	flicker( $('fukidasiImage' + i) , 1 , 2000 )
}
*/
/*
$( 'serifTable' + i ).style.top = Math.round( cutPX($( 'serifTable' + i ).defTop ) * $('fukidasi' + i).heightPower / 100 ) + 'px'
$( 'serifTable' + i ).style.left = Math.round( cutPX($( 'serifTable' + i ).defLeft ) * $('fukidasi' + i).widthPower / 100 ) + 'px'
*/

function switchSerifMovable( that , i ){
	if( !that.draggable ){
		that.draggable = new Draggable('serifTable' + i,
			{snap:function( x , y ){
				$('textTopOffset' + i).value = Math.round( y / $('fukidasi' + i).heightPower * 100 )
				$('textLeftOffset' + i).value = Math.round( x / $('fukidasi' + i).widthPower * 100 )
				return[x,y]
			},
		starteffect:null , endeffect:null})
		HLFlicker($('serifTable' + i))
	}else{
		HLFlicker($('serifTable' + i))
		that.draggable.destroy()
		that.draggable = null
	}
}

function switchFukidasiMovable( that , i ){
	if( !$('fukidasi' + i).draggable ){
		HLFlicker($('fukidasi' + i))
		fukidasiDraggablize(i)
	}else{
		HLFlicker($('fukidasi' + i))
		$('fukidasi' + i).draggable.destroy()
		$('fukidasi' + i).draggable = null
	}
}

function sizingFukidasi( different , i ){
	if( that.checked ) addRule( "#serifTd" + i , "font-weight:bold;" )
	else addRule( "#serifTd" + i , "font-weight:normal;" )
}

function fukidasiTurnPanelOn(i){
	//alert(EIWayVariety[$F( 'fukidasiImageID' + i )])
	if( EIWayVariety[$F( 'fukidasiImageID' + i )] > 0 ){
		$( 'fukidasiTurnPanel' + i ).style.display = 'block'
	}
}

function fukidasiTurnPanelOff(i){
	if( EIWayVariety[$F( 'fukidasiImageID' + i )] > 0 ){
		$( 'fukidasiTurnPanel' + i ).style.display = 'none'
	}
}

function turnFukidasiRight(i){
	var variety = EIWayVariety[$F( 'fukidasiImageID' + i )]
	$( 'fukidasiImage' + i ).src.match(/_w([0123456789]+)/)
	var way = eval( RegExp.$1 ) + 1
	if( way == variety ) way = 0
	$( 'fukidasiImage' + i ).src = $( 'fukidasiImage' + i ).src.replace( /_w[0123456789]+/ , '_w' + way )
	$( 'fukidasiWay' + i ).value = way
}

function turnFukidasiLeft(i){
	var variety = EIWayVariety[$F( 'fukidasiImageID' + i )]
	$( 'fukidasiImage' + i ).src.match(/_w([0123456789]+)/)
	var way = eval( RegExp.$1 ) - 1
	if( way < 0 ) way = variety - 1
	$( 'fukidasiImage' + i ).src = $( 'fukidasiImage' + i ).src.replace( /_w[0123456789]+/ , '_w' + way )
	$( 'fukidasiWay' + i ).value = way
}

function selectEIPImage( that , i ){
	if( selectEIPImage.clicked ) selectEIPImage.clicked.style.borderColor = '#ffffff'
	that.style.borderColor = 'red'
	settingFukidasi(i)
	selectEIPImage.clicked = that
}

function delayChange( i , val ){
	var delaySec = eval($('delayBox'+i).value) + val
	if( delaySec < 0 ) return;
	$('delayBox'+i).value = delaySec
	$('delayHidden'+i).value = ( delaySec * 10 )
}

function delayFunc( that , i ){
	try{$( 'delayHidden' + i ).value = that.value * 10}
	catch(e){$( 'delayHidden' + i ).value = 0}
}

function vanishChange( i , val ){
	var vanishSec = eval($('vanishBox'+i).value) + val
	if( vanishSec < 0 ) return;
	$('vanishBox'+i).value = vanishSec
	$('vanishHidden'+i).value = ( vanishSec * 10 )
}

function vanishFunc( that , i ){
	try{$( 'vanishHidden' + i ).value = that.value * 10}
	catch(e){$( 'vanishHidden' + i ).value = 0}
}

function changeFontSize( value , i ){
	$('serifTd' + i).style.fontSize = value + "pt";
	//addRule( "#serifTd" + i , "font-size:" + value + "pt;" )
}

function changeFontColor( value , i ){
	//addRule( "#serifTd" + i , "color:" + value + ";" )
	$('serifTd' + i).style.color = value
}

function changeTextAlign( value , i ){
	//addRule( "#serifTd" + i , "text-align:" + value + ";" )
	$('serifTd' + i).style.textAlign = value
}

function boldFontFunc( that , i ){
	//if( that.checked ) addRule( "#serifTd" + i , "font-weight:bold;" )
	//else addRule( "#serifTd" + i , "font-weight:normal;" )
	if( that.checked ) $('serifTd' + i).style.fontWeight = 'bold'
	else $('serifTd' + i).style.fontWeight = 'normal'
}

function syncText( that , i ){
	if( that.syncTimer == null ) that.syncTimer = setInterval( "syncTextLogic(" + i + ")" , 200 )
}
function syncTextLogic( i ){
	$('serifTd' + i).innerHTML = switchBreak( $('serifBox' + i).value )
}
function stopSyncText( that ){
	if( that.syncTimer != null ){
		clearInterval( that.syncTimer )
		that.syncTimer = null
	}
}
function changeFukidasiImage( i ){
	if( $('EIPtargetOption' + i).selected ) switchBlockDisplay($('fukidasiImagePanel'))
	else{
		$('EIPtargetOption' + i).selected = true
		$('fukidasiImagePanel').show()
	}
}

/*
function titleLogoLinkConfirm(){
	$('titleLogoLink').onclick = function(){return confirm('トップページに移動します。\n作成中のページは消えちゃいますがよろしいですか？')}
}
setTimeout( titleLogoLinkConfirm , 20000 )
*/
</script>