<%--
  ~ Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
  ~ All rights reserved.
  ~ 
  ~ Redistribution and use in source and binary forms, with or without modification,
  ~ are permitted provided that the following conditions are met:
  ~ 
  ~ 1. Redistributions of source code must retain the above copyright notice,
  ~    this list of conditions and the following disclaimer.
  ~ 2. Redistributions in binary form must reproduce the above copyright notice,
  ~    this list of conditions and the following disclaimer in the documentation
  ~    and/or other materials provided with the distribution.
  ~ 3. Neither the name of the pettan nor the names of its contributors may be used
  ~    to endorse or promote products derived from this software without specific
  ~    prior written permission.
  ~ 
  ~ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
  ~ EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  ~ OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
  ~ SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  ~ INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  ~ TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  ~ BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  ~ CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ~ ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  ~ DAMAGE.
  --%>

<%@ page language="java" import="java.lang.*,java.util.*" 
	pageEncoding="UTF-8" %>
<%@include file="../inc/commonDirective.jsp" %>
<script type="text/javascript">
//汎用ライブラリ。
//prototype.js、script.aculo.usに依存。
//2006.07.23頃 作成開始。
//2007.06.13   大幅に改造。

function pushOutside( obj ){
	obj.style.position = 'absolute'
	obj.style.left = -9999
}

function pullInside( obj ){
	obj.style.position = 'static'
	obj.style.left = 0
}

//大文字アルファベットでランダムな文字列を作る。
function rubbish( len ){
	if( len == null ) len = 20
	var result = ""
	for( var i = 0 , max = ( Math.random()*(len-1) ) + 1 ; i < max ; i++ ){
		result += String.fromCharCode( Math.floor( Math.random() * 25 ) + 65 )
	}
	return result
}

function leftVisibleTimer( id , time , left ){
	if( ! left ) left = 'auto';
	else left += 'px'
	return setTimeout('$(\"' + id + '\").style.left = \"' + left + '\"',time)
}

function leftHiddenTimer( id , time ){
	return setTimeout('$(\"' + id + '\").style.left = \"-9999px\"',time)
}

//ブロック要素のDisplay属性をnone←→displayで切り替える。
function switchBlockDisplay( target ){
	if( target.style.display == 'none' ) target.style.display = 'block'
	else target.style.display = 'none'
}

//Opacityを1→0→1とする関数。連打防止機能付き。
//対象（obj）以外の指定はオプション。
function flicker( obj , dur , interval ){
	if( !dur ) dur = 0.5 //エフェクトの時間。1で1秒。
	if( !interval ) interval = dur * 2 * 1000 //連打間隔。デフォルトはエフェクトの時間が終わるまで。
	if( !obj.waiting ){
		new Effect.Opacity( obj ,{ duration:dur/2 , from:1 , to:0 })
		new Effect.Opacity( obj ,{ duration:dur/2 , from:0 , to:1 , delay:dur/2 })
		setTimeout( function(){ obj.waiting = false} , interval )
		obj.waiting = true
	}
}

//Highlightさせる関数。連打防止機能付き。
//対象（obj）以外の指定はオプション。
function HLFlicker( obj , dur , interval ){
	if( !dur ) dur = 0.5 //エフェクトの時間。1で1秒。
	if( !interval ) interval = dur * 2 * 1000 //連打間隔。デフォルトはエフェクトの時間が終わるまで。
	if( !obj.waiting ){
		new Effect.Highlight( obj ,{ duration:dur })
		setTimeout( function(){ obj.waiting = false} , interval )
		obj.waiting = true
	}
}

/********************************************************
２つの関数を交互に呼ぶ関数。
点滅、フェードイン＆アウト等用。
javascriptの本持ってきてから実装すべし。

//var func1 = "&('fukidasi1').hide()"
//var func2 = "$('fukidasi0').show()"

//AC = Alternative Call の略。
function AC( func1 , func2 , speed ){
	var pac = new 

	setTimeout( "alert('sss');alert('aaa')" , speed )
	this.a = 2
	alternativeCall.b = 3
//	alert( alternativeCall )
//	alert( this )
}
function privateAC(){
}
//alternativeCall( func1 , func2 , 50 )

********************************************************/

//Event.observe()を複数オブジェクトに対してまとめて行うメソッド。
//setObservers( 'mouseover' , functionName , true, $('a'), $('b'), $('b')... ) )
//のように指定して下さい。
//2007.12.08 原因が全くわからないけど、IEでもFFでも失敗するので置いとく。
/*
function setObservers( eventName , func , flag ){
	var length = arguments.length
	//alert(length)
	for( i = 3 ; i < length ; i++ ){
		alert($(arguments[i]))
		alert("observe:" + i + ":" + arguments[i] )
		Event.observe( eventName , func , flag , $(arguments[i]) )
		alert("success observing:" + i + ":" + arguments[i] )
	}
}
*/

function showProps( obj ){
	var msg = ''
	for( prop in obj ) msg += prop + ':' + obj[prop] + '\n'
	alert(msg)
}

function switchBreak( str ){
	return str.replace(/\n/g,'<br>')
}

function getExtension( fileName ){
	var split = fileName.split('.')
	return split[ split.length - 1 ]
}

function getExtensionRemoved( fileName ){
	return fileName.split('.')[0]
}

function getFileName( filePath ){
	var splitFilePath = filePath.split('/')
	return splitFilePath[splitFilePath.length-1]
}

//受け取ったオブジェクトの子をすべて消去する。
function removeChildren( obj ){	while( obj.hasChildNodes() )obj.removeChild( obj.firstChild )}

//指定idのオブジェクトをメモリから除去する。
function removeObj(id){$(id).parentNode.removeChild($(id))}

//innerHTMLを空にする。
function empty(id){$(id).innerHTML = ''}
function clearInnerHTML(id){ $(id).innerHTML = '' }

//moboに関する関数と変数。
function mi(){ return G_moboIndex++ }
var G_moboIndex = 0
var G_obom = new Array()
//メッセージをちょっとずつ出す関数、リメイク版。
//moboは message one by one の略。
//speedの指定はオプション。
function mobo( msg , target , speed ){
	if(speed == null) speed = 50
	removeChildren(target)
	var i = mi()
	var elem = new Object()
	G_obom[i] = elem
	G_obom[i].msg = msg
	G_obom[i].target = target
	G_obom[i].speed = speed
	G_obom[i].msgIndex = 0
	G_obom[i].index = i
	G_obom[i].timer = setInterval( "exeMobo(G_obom[" + i +"])" , speed )
}

function exeMobo( obom ){
	if( obom.msgIndex < obom.msg.length ){
		obom.target.innerHTML += obom.msg.charAt(obom.msgIndex)
		obom.msgIndex++
	}
	else{
		clearInterval( obom.timer )
		if( !delete G_obom[obom.index] ) alert('mobo delete error!')
	}
}

// セレクトボックスで選択されたoptionのラベルをセットするメソッドです。
// selectObj : セレクトボックスオブジェクト
// targetObj : ラベルをセットする対象となるオブジェクト
// （使用例）
// <select onchange="setSelectedText( this, $('prefectureName') )">
// <input type="hidden" id="prefectureName">
function setSelectedText( selectObj , targetObj ){
	var label = selectObj.options[selectObj.selectedIndex].text
	if( label == '--' ) targetObj.value = ''
	else targetObj.value = label
}

// CSS操作関数。
// from http://bmky.net/diary/log/1342.html
function addRule( selector, property ) {
 if( document.styleSheets[0].addRule ) //IE
  document.styleSheets[0].addRule( selector, "{" + property + "}" );
 else if( document.styleSheets[0].insertRule ) //Mozilla
  document.styleSheets[0].insertRule( selector + "{" + property + "}", document.styleSheets[0].cssRules.length );
 else
  return false;
}

function setOpacity(id,opacity){
	if( $(id).style.filter ) $(id).style.filter = 'alpha(opacity=' + opacity +  ')';
	if( $(id).style.mozOpacity ) $(id).style.mozOpacity = ( opacity / 100 );
	if( $(id).style.opacity ) $(id).style.opacity = ( opacity / 100 );
}

//指定idのオブジェクトを画面からfadeoutし、その後メモリからも除去します。
function fadeRemove(id){
	new Effect.Fade($(id));
	setTimeout("removeObj(" + id + ")",3000);
}

/************ 2007.06.13 timers ************/
function vHiddenTimer(id,time){return setTimeout('$(\"' + id + '\").style.visibility = \"hidden\"',time)}
function vVisibleTimer(id,time){return setTimeout('$(\"' + id + '\").style.visibility = \"visible\"',time)}
function displayNoneTimer(id,time){return setTimeout('$(\"' + id + '\").style.display = \"none\"',time)}
function displayBlockTimer(){return setTimeout('$(\"' + id + '\").style.display = \"block\"',time)}
function fadeoutTimer(id,time){return setTimeout('new Effect.Fade($(\"' + id + '\"))',time)}
function fadeinTimer(id,time){return setTimeout('new Effect.Appear($(\"' + id + '\"))',time)}
function hideOpaTimer(id,time){return setTimeout('setOpacity(' + id + ',' + 0 + ')', time )}
function appearOpaTimer(id,time){return setTimeout('setOpacity(' + id + ',' + 100 + ')', time )}
/************ 2007.06.13 timers ************/

//イベントの発生源であるオブジェクトへの参照を返す関数。
function getTarget(e){
	if(e.target)return e.target;
	else{return e.srcElement;}
}

function randomSelect(array){
	rNum = Math.floor( Math.random() * array.length );
	return array[rNum];
}

//座標を求める関数、その１。
//x,y座標をプロパティとして持ったオブジェクトを返す。
function getElemPos(elem){
	var obj = new Object();
	obj.x = elem.offsetLeft;
	obj.y = elem.offsetTop;
	while(elem.offsetParent){
		elem = elem.offsetParent;
		obj.x += elem.offsetLeft;
		obj.y += elem.offsetTop;
	}	
	return obj;
}

//座標を求める関数、その２。
//座標が指定されていない要素のときにautoが返ってしまう？
function getDynamicStyle(obj,style){
	var node = obj;
	if(!document.getElementById)return;
	if(node.currentStyle){
		return node.currentStyle[style];
	} else if(document.defaultView){
		return document.defaultView.getComputedStyle(node,'').getPropertyValue(style); 
	} else {
		return null 
	} 
}

//バブリングの停止、その後デフォルトイベントアクションの停止。
function stopDefaultAndPropagation(e){
	if(e.stopPropagation){
		e.stopPropagation();
	}
	if(window.event){
		window.event.cancelBubble = true;
	}
	if(e.preventDefault()){
		e.preventDefault();
	}
	if(window.event){
		window.event.returnValue = false;
	}
}
</script>