<%--
  ~ Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
  ~ All rights reserved.
  ~ 
  ~ Redistribution and use in source and binary forms, with or without modification,
  ~ are permitted provided that the following conditions are met:
  ~ 
  ~ 1. Redistributions of source code must retain the above copyright notice,
  ~    this list of conditions and the following disclaimer.
  ~ 2. Redistributions in binary form must reproduce the above copyright notice,
  ~    this list of conditions and the following disclaimer in the documentation
  ~    and/or other materials provided with the distribution.
  ~ 3. Neither the name of the pettan nor the names of its contributors may be used
  ~    to endorse or promote products derived from this software without specific
  ~    prior written permission.
  ~ 
  ~ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
  ~ EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  ~ OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
  ~ SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  ~ INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  ~ TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  ~ BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  ~ CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ~ ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  ~ DAMAGE.
  --%>

<%@ page language="java" import="java.util.*,ninnik.util.Utils,peta.dao.*" pageEncoding="UTF-8" %>
<%@ include file="./inc/commonDirective.jsp" %>
<%@page import="org.apache.commons.lang.StringUtils;"%>
<bean:define id="jspName" value="usrpage" type="String"/>
<bean:define id="isMyPage" name="isMyPage" type="Boolean"/>
<bean:define id="dispUsr" name="dispUsr" type="Usr"/>
<bean:define id="総ページ数" name="総ページ数" type="Integer"/>
<bean:define id="pageNO" name="pageNO" type="Integer"/>
<%! int colNum = 5; %>
<%! int imgColNum = 7; %>
<html:html>
<head>
<title><bean:write name="dispUsr" property="usrName"/>さんの投稿した画像 - <bean:message key="title" bundle="depEnv"/></title>
<script type="text/javascript" src="pages/gatherer/make_js_gat.jsp"></script>
<%@ include file="./inc/commonHeader.jsp" %>
<%@ include file="./css/usrImage.css" %>
</head>

<body>
<%@ include file="./inc/commonBody.jsp" %>

<div id="main">

	<%@ include file="./inc/headerL.jsp" %>
	<%@ include file="./inc/headerC.jsp" %>
	<%@ include file="./inc/headerR.jsp" %>
	
	<h3>
		<bean:write name="dispUsr" property="usrName"/>さんが投稿した画像
		（<bean:write name="総画像数"/>）
	</h3>
	
	<%=Utils.space(20)%>
	
	<html:form styleId="updateImageTagForm" action="/updateImageTag" onsubmit="return false">
		
		<div style="margin:auto;border:solid #aaaaaa 1px;width:500px;padding:10px;">
			<div style="text-align:left;">
			タグは５つまでつけることができます。
			下の入力欄にタグを入力し、タグをつけたいところを選んで「タグ更新」ボタンを押してください。
			タグを消したい場合、なにも入力せずに消したいタグにチェックを入れて「タグ更新」を押して下さい。
			</div>
			<br/>
			タグ：<input type="text" name="tagText" id="tagText" maxlength="8" style="width:120px;"/>
			<input type="button" value="タグ更新" onclick="updateImageTag()"/>
			
			<%=Utils.space(20)%>
		
			<b>既存のタグ</b>（クリックでタグが入力されます）<br/>
			<logic:iterate name="usedTags" id="usedTag" type="java.lang.String">
				<a href="javascript:void(0)" onclick="$('tagText').value='<%=usedTag%>'"><%=usedTag%></a>&nbsp;
			</logic:iterate>
		</div>
		
		<%=Utils.space(20)%>
		<%@include file="inc/usrImagePager.jsp" %>
		<%=Utils.space(20)%>

		<%{int i = 0;%>	
		<table style="width:900px;">
			<logic:iterate id="image" name="images" type="Image">
				<%if( i%imgColNum == 0 ){%><tr><%}%>
				<td class="usrImage" id="usrImage<bean:write name="image" property="imageID"/>">
					<div class="used">
						使用回数：<span style="font-size:12pt;"><bean:write name="image" property="used"/></span>&nbsp;回
					</div>
					<img src="<%= Utils.getサムネイル絶対URL(image) %>" class="uploadedImg"/>
					<div style="text-align:left;font-size:8pt;white-space:nowrap;">
						<input type="hidden" id="imgTagImageID<%=i%>" name="imageTag[<%=i%>].imageID" value="<bean:write name="image" property="imageID"/>" disabled="disabled"/>
						<%for( int t = 1 ; t <= 5 ; t++ ){%>
							<div style="height:20px;" onmouseover="this.style.background='#fff0a0'" onmouseout="this.style.background='transparent'" onclick="$('imgTagSeq<%=i%>_<%=t%>').checked = true,$('imgTagImageID<%=i%>').disabled = false">
								<input type="radio" id="imgTagSeq<%=i%>_<%=t%>" name="imageTag[<%=i%>].seq" value="<%=t%>" onclick="$('imgTagImageID<%=i%>').disabled = false"/>
								<span id="tag<%=i%>_<%=t%>"><%= ( t < image.getTags().size() )? image.getTags().get(t) : "" %></span>
							</div>
						<%}%>
					</div>
					<input style="font-size:8pt;width:100px;" type="button" value="選択を解除" onclick="cancelRadio(<%=i%>)"/><br/>
					<%if( usr != null && ( "A".equals(usr.getAuthority()) || isMyPage ) ){ %>
						<input style="font-size:8pt;width:100px;" type="button" value="削除" onclick="deleteImage(<bean:write name="image" property="imageID"/>)"/><br/>
					<%}%>
				</td>
				<%if( i%imgColNum == imgColNum - 1 ){%></tr><%}%>
				<%i++;%>
			</logic:iterate>
			<%
			//空のTDを詰めて最後にTRを足す。
			int empty = imgColNum - i%imgColNum;
			if( empty != 0 ){
				StringBuilder sb = new StringBuilder();
				for( int r = 0 ; r < empty ; r++ ){
					sb.append("<td class='usrImage'><div style='width:100px;'>&nbsp;</div></td>");
				}
				sb.append("</tr>");
				out.print(sb.toString());
			}
			%>
		</table>
		<%}%>
	</html:form>
	
	<%@include file="inc/usrImagePager.jsp" %>
	<%=Utils.space(20)%>
	<a href="<html:rewrite page="<%="/usr" + dispUsr.getUsrID()%>"/>"><b style="font-size:20pt;"><bean:write name="dispUsr" property="usrName"/>さんのページに戻る</b></a>
	<%=Utils.space(20)%>
	<hr style=""/>
	<a href="<bean:message key="link.top" bundle="depEnv"/>">トップページへ</a>
	<%=Utils.space(20)%>
	
</div>
<script>

function cancelRadio(i){
	$('imgTagImageID' + i).disabled = true
	for( t = 1 ; t <= 5 ; t++ ) $( 'imgTagSeq' + i + '_' + t ).checked = false
}

function updateImageTag(){

	new Ajax.Request( '<html:rewrite page="/updateImageTag.peta"/>',
		{
			method : 'post',
			parameters : Form.serialize("updateImageTagForm"),
			onSuccess : updateImageTagOnSuccess ,
			//onSuccess : function(){location.reload()} ,
			onFailure : function(){alert('タグの更新に失敗しました。')}
		}
	)
}
function updateImageTagOnSuccess(){
	for( i = 0 ; ; i++ ){
		if( document.getElementById( 'imgTagImageID' + i ) ){
			for( t = 1 ; t <= 5 ; t++ ){
				if( $( 'imgTagSeq' + i + '_' + t ).checked ){
					$( 'tag' + i + '_' + t ).innerHTML = $F('tagText')
					$( 'imgTagSeq' + i + '_' + t ).checked = false
					$('imgTagImageID' + i).disabled = true
				}
			}
		}
		else break
	}
	$('tagText').value = ""
}

<%if( usr != null && "A".equals(usr.getAuthority()) ){%>
function deleteImage(imageID){
	if( confirm('この画像を消しちゃってもいいですか？') ){
		new Ajax.Request(
			'<html:rewrite page="/deleteImage.peta"/>?imageID=' + imageID ,
			{ method:'get' , onFailure: function(){alert('削除に失敗しました。')}}
		)
		if( $('usrImage' + imageID) ) $('usrImage' + imageID).innerHTML = ''
		return false
	}
	return true
}
<%}%>
</script>

<%@ include file="./inc/googleAnalytics.jsp" %>
</body>
</html:html>