<%--
  ~ Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
  ~ All rights reserved.
  ~ 
  ~ Redistribution and use in source and binary forms, with or without modification,
  ~ are permitted provided that the following conditions are met:
  ~ 
  ~ 1. Redistributions of source code must retain the above copyright notice,
  ~    this list of conditions and the following disclaimer.
  ~ 2. Redistributions in binary form must reproduce the above copyright notice,
  ~    this list of conditions and the following disclaimer in the documentation
  ~    and/or other materials provided with the distribution.
  ~ 3. Neither the name of the pettan nor the names of its contributors may be used
  ~    to endorse or promote products derived from this software without specific
  ~    prior written permission.
  ~ 
  ~ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
  ~ EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  ~ OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
  ~ SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  ~ INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  ~ TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  ~ BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  ~ CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ~ ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  ~ DAMAGE.
  --%>

<%@ page language="java" import="java.lang.*,java.util.*,ninnik.util.Utils,peta.dao.*" pageEncoding="UTF-8" %>
<%@ include file="./inc/commonDirective.jsp" %>

<bean:define id="jspName" value="view" type="String"/>
<bean:define id="p" name="page" type="Koma"/>
<bean:define id="comic" name="comic" type="Comic"/>
<bean:define id="author" name="author" type="Usr"/>
<bean:define id="goNext" type="String"><%= "/viewNext.peta?komaID=" + p.getKomaID() + "&comicID=" + comic.getComicID() %></bean:define>
<bean:define id="goPrevious" type="String"><%= "/viewPrevious.peta?komaID=" + p.getKomaID() %></bean:define>

<%
Boolean inIFrame = 
	( request.getAttribute("inIFrame") == null )?
	inIFrame = Boolean.FALSE :
	(Boolean)request.getAttribute("inIFrame");
String previewFlg = (String)request.getAttribute("previewFlg");
//String previewFlg = (String)request.getAttribute("previewFlg");
%>



<html:html>
<head>
<title>
<bean:write name="comic" property="title"/> 
<bean:write name="p" property="seqNO"/>コマ目 - <bean:message key="title" bundle="depEnv"/>
</title>
<% if( !inIFrame ){ %>
	<script type="text/javascript" src="pages/gatherer/normal_js_gat.jsp"></script>
	<%@ include file="./inc/commonHeader.jsp" %>
<% } else { %>
	<%@ include file="css/common.css" %>
<% } %>
</head>
<body>
<% if( !inIFrame ){ %><%@ include file="./inc/commonBody.jsp" %><% } %>
<%if(!inIFrame){%>
<div id="main">
<%}%>
	<%if( !inIFrame && !"1".equals(previewFlg) ){%>
		<%@ include file="./inc/headerL.jsp" %>
		<%if( "0".equals(comic.getType()) ){%>
			<%@ include file="./inc/headerCView.jsp" %>
		<%}else{%>
			<%@ include file="./inc/headerC.jsp" %>
		<%}%>
		<%@ include file="./inc/headerR.jsp" %>
		<html:errors/>
	<%}%>
	
	<%--★★ ページ ★★--%>
	<div>
	
		<%if( ! inIFrame ){%>
			<%-- ★コマの上★ --%>
			<h3>
				<bean:write name="comic" property="title"/>&nbsp;
				<% if( !"1".equals(previewFlg) ){%><bean:write name="p" property="seqNO"/>コマ目<%}%>
			</h3>
			<span class="h3Font">
			&nbsp;&nbsp;<bean:write name="p" property="birthday" format="yyyy/MM/dd HH:mm"/>
			</span>
			<%if( comic.getAutoMoveSec() != 0 || p.getAutoMoveSec() != 0 ){%>
			&nbsp;&nbsp;&nbsp;
			<input type="button" onclick="stopAutoMove()" value="自動進行停止"/>
			<%}%>
		<%}%>
		
		<% int ei = 0;%>
		<% int pi = 0;%>
		<%@ include file="./inc/viewKoma.jsp" %>
		
		<%= isDeleted? "<br/><br/><br/><span style='color:red;font-weight:bold;'>このページは現在閲覧できません。</span><br/><br/><br/>" : ""  %>
		<%if( !inIFrame && !"1".equals(previewFlg) ){%>
			投稿者：
			<a href="<html:rewrite page="<%="/usr" + author.getUsrID()%>"/>" title="<bean:write name="author" property="usrName"/>さんのユーザページに飛びます。"><b><bean:write name="author" property="usrName"/></b></a>
			&nbsp;&nbsp;
			ページビュー：<b><bean:write name="p" property="pageView"/></b>
			&nbsp;&nbsp;
			投稿許可：<b><%="0".equals(comic.getMakerFreeFlg())? "作成者のみ" : "誰でも" %></b>
			&nbsp;&nbsp;
			<br/><br/>
			<%@ include file="./inc/埋め込み.jsp" %>	
		<%}%>
	
	</div>
	
	<%if( !inIFrame && !"1".equals(previewFlg) ){%>
		<br/><br/>
		
		<%--★★ コマ削除 ★★--%>
		<%if( usr != null ){%>
			<%if( usr.getUsrID().equals(author.getUsrID()) || "A".equals( usr.getAuthority() ) ){%>
				<html:form action="/pageDispSwitch" method="POST">
					<input type="submit" value="<%=isDeleted? "削除取消" : "削除" %>" style="height:30px;" />
					<input type="hidden" name="komaID" value="<bean:write name="p" property="komaID"/>"/>
				</html:form>
				<br/><br/>
			<%}%>
		<%}%>

		<logic:equal name="comic" property="type" value="1">
			<span style="font-size:18pt;">
				<a href="<html:rewrite page="<%="/comic" + comic.getComicID() + "#" + p.getSeqNO()%>"/>" title="<bean:write name="comic" property="title"/>に戻ります。"><b><bean:write name="comic" property="title"/></b></a>
			</span>
		</logic:equal>
		
		<%--★★ コミックのtypeが1の時はコメント欄非表示 ★★--%>
		<div style="<logic:equal name="comic" property="type" value="1">display:none;</logic:equal>">
			
			<%--★★ コメント表示部 ★★--%>
			<strong>コメント</strong>
			<div class="come">
				<logic:iterate id="come" name="comes" type="Come" indexId="i">
					<div class="comeHeader">
						<b><%=i+1%>&nbsp;.&nbsp;
						<logic:equal name="come" property="accountNameFlg" value="1">
							<a href="<html:rewrite page="/usrPage.peta?usrID="/><%=come.getUsrID()%>" title="<bean:write name="come" property="name"/>さんのユーザページに飛びます。"><bean:write name="come" property="name"/></a>
						</logic:equal>
						<logic:notEqual name="come" property="accountNameFlg" value="1">
							<span style="color:black;"><bean:write name="come" property="name"/></span>
						</logic:notEqual>
						</b>
						&nbsp;<bean:write name="come" property="regDate" format="yyyy/MM/dd(E) HH:mm:ss"/>
					</div>
					<%=come.getStatement()%><br><br>
				</logic:iterate>
			
				<%--★★ コメント投稿フォーム ★★
				<html:form action="/come" method="POST" onsubmit="return checkComeOnSubmit()" styleId="comeForm">
					<table style="width:500px;margin:auto;">
						<tr>
							<td>名前</td>
							<td>
								<%if(usr != null){%>
								<html:text property="name" maxlength="20" style="width:200px;" disabled="true" styleId="commentName"/>
								<input type="checkbox" checked="checked" name="accountNameFlg" value="1" onclick="$('commentName').disabled = !$('commentName').disabled">
								ユーザ名「<%=usr.getUsrName()%>」で投稿
								<%}else{%>
								<html:text property="name" maxlength="20" style="width:200px;"/>
								<%}%>
							</td>
						</tr>
						<tr>
							<td>コメント</td>
							<td>
								<html:textarea styleId="come" property="come" style="width:400px;height:100px;"></html:textarea>
							</td>
						</tr>
					</table>
					<div style="text-align:center;width:500px;">
						<html:submit styleId="commentSubmit" value="コメント投稿" style="width:200px;height:30px;"/>
					</div>
					<input type="hidden" name="komaID" value="<bean:write name="p" property="komaID" />"/>
				</html:form>
				<br/>
				--%>
			
			</div>
		
			<%--★スペース★--%><div style="height:20px;">&nbsp;</div>
			
		</div>
		
		<hr style=""/>
		<a href="<bean:message key="link.top" bundle="depEnv"/>">トップページへ</a>
		
		<%--★スペース★--%><div style="height:20px;">&nbsp;</div>
	<%}%>
	
</div>

<% if( !inIFrame ){ %>
<script>

function checkComeOnSubmit(){
	if( $F('come') == "" ){
		alert('コメントが空です。') 
		return false
	}
	$('commentSubmit').disabled = true
	return true
}

function stopAutoMove(){
	clearTimeout(autoMove.timer)
}

function autoMove(){
	<logic:greaterThan name="nextPageCount" value="0">
		location.href='<html:rewrite page="<%=goNext%>"/>'
	</logic:greaterThan>
	<logic:lessEqual name="nextPageCount" value="0">
		autoMove.timer = location.href='<html:rewrite page="/makeStart.peta?comicID="/><%=comic.getComicID()%>'
	</logic:lessEqual>
}

<logic:notEqual name="comic" property="autoMoveSec" value="0">
	autoMove.timer = setTimeout("autoMove()",(<bean:write name="comic" property="autoMoveSec"/>*1000))
</logic:notEqual>
<logic:notEqual name="page" property="autoMoveSec" value="0">
	stopAutoMove()
	autoMove.timer = setTimeout("autoMove()",(<bean:write name="page" property="autoMoveSec"/>*1000))
</logic:notEqual>

function onClickEval( evaluation ){
	location.href = '<html:rewrite page="<%= "/evaluate.peta?komaID=" + p.getKomaID() + "&evaluation="%>"/>' + evaluation
}

function goPrevious( goTopFlg ){
	if( goTopFlg ){
		location.href = '/'
		return false
	}
	location.href = '<html:rewrite page="<%=goPrevious%>"/>'
	return false
}

</script>
<% } %>
<% if( !inIFrame ){ %><%@ include file="./inc/googleAnalytics.jsp" %><% } %>
</body>
<% if( !inIFrame ){ %><%@ include file="./js_jsp/view.js" %><% } %>
</html:html>