/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package ninnik.util;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;

import peta.定数;
import peta.dao.Usr;

public class MailSender {
    /*
     * private static final String host = "pettan.jp"; private static final
     * String usr = "hedachi"; private static final String from =
     * "hedachi@****.jp"; private static final String encode = "iso-2022-jp";
     * private static final String 管理者メールアドレス = "fukuda_82@****.jp"; private
     * static final String NO_USR = "ユーザ名：情報なし";
     */

    public static void sendErrorMail(Exception e, HttpServletRequest request) {
        String ip = "IP:" + request.getRemoteAddr();
        String requestURI = "URL:" + request.getRequestURI();
        Usr u = (Usr) request.getSession().getAttribute("usr");
        String usrName = "ユーザ名：" + u.getUsrName();

        /*
         * 本当は
         * Map<String, String[]>
         * Set<Strgin>
         * だが，とりあえずwarningを消しておく
         */
        Map<?, ?> paraMap = request.getParameterMap();
        Set<?> keys = paraMap.keySet();
        StringBuilder sb = new StringBuilder();
        sb.append("- request parameters -");
        for (Object key : keys) {
            String[] values = (String[]) paraMap.get(key);
            sb.append("\n" + key + " = ");
            for (int i = 0; i < values.length; i++)
                sb.append(values[i] + " ");
        }
        sb.append("\n");
        sendErrorMail(e,
                new String[] { ip, usrName, requestURI, sb.toString() });
    }

    private static void sendErrorMail(Exception e, String[] infos) {
        StringBuilder 本文 = new StringBuilder();
        本文.append(e.getMessage() + "　＠　" + 定数.TIMESTAMP.format(new Date())
                + "\n\n");
        for (String info : infos)
            本文.append(info + "\n");
        本文.append("スタックトレース\n");
        for (StackTraceElement s : e.getStackTrace())
            本文.append(s + "\n");

        String env = ConfigManager.getDependEnv().getString("environment");

        send("fukuda_82@****.jp", env + "／Exception発生：" + e.getClass(), 本文
                .toString());
    }

    public static void notify(String 題) {
        send("fukuda_82@****.jp", 題, "");
    }

    public static void send(String 送信先, String 題, String 本文) {
        try {
            Properties props = System.getProperties();

            props.put("mail.smtp.host", "pettan.jp");
            props.put("mail.host", "pettan.jp");
            props.put("mail.from", "hedachi@****.jp");

            Session session = Session.getDefaultInstance(props, null);

            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom(new InternetAddress("hedachi@****.jp",
                    "ぺったん", "iso-2022-jp"));
            mimeMessage.setRecipients(Message.RecipientType.TO, 送信先);

            mimeMessage.setSubject(題, "iso-2022-jp");

            mimeMessage.setText(本文, "iso-2022-jp");
            mimeMessage.setHeader("Content-Type",
                    "text/plain;charset=iso-2022-jp");
            mimeMessage.setSentDate(new Date());

            Transport.send(mimeMessage);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
