/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package ninnik.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import peta.定数;
import peta.dao.Fukidasi;
import peta.dao.FukidasiImage;
import peta.dao.Image;

public class Utils {
    // private static final int _100 = 100;
    private static String hatebuLink1 = "<a href='http://b.hatena.ne.jp/entry/";
    private static String hatebuLink2 = "'><img style='border-style:none;' src='http://b.hatena.ne.jp/entry/image/";
    private static String hatebuLink3 = "'></a>";

    private static Pattern コマ範囲パターン = Pattern.compile("([0123456789]+)-(.*)");

    private static Pattern IMG_WAY_PATTERN = Pattern
            .compile("(.*_w)([0123456789]+)(.*)");

    public static String getHatebuLink(String url) {
        return hatebuLink1 + 定数.ぺったんURL + url + hatebuLink2 + 定数.ぺったんURL + url
                + hatebuLink3;
    }

    public static String getTwittime(Date date) {
        Date now = new Date();
        Long 差 = Long.valueOf((now.getTime() - date.getTime()) / 60000L);

        if (差.longValue() == 0L)
            return "1分以内";
        if (差.longValue() <= 60L)
            return 差 + "分前";

        if (差.longValue() < 1440L) {
            Long 差時間 = Long.valueOf(差.longValue() / 60L);
            Long 差分 = Long.valueOf(差.longValue() % 60L);
            return 差時間 + "時間" + 差分 + "分前";
        }

        return 定数.TIMESTAMP.format(date);
    }

    public static boolean 評価ＯＫ(Date d) {
        Calendar ca = Calendar.getInstance();
        ca.add(13, -30);
        return !d.after(ca.getTime());
    }

    public static void closeStreams(Object[] streams) throws Exception {
        boolean 引数がへん = false;
        Object[] arrayOfObject = streams;
        int j = streams.length;
        for (int i = 0; i < j; i++) {
            Object stream = arrayOfObject[i];
            if (stream != null)
                if ((stream instanceof InputStream)) {
                    ((InputStream) stream).close();
                } else if ((stream instanceof OutputStream)) {
                    ((OutputStream) stream).close();
                } else {
                    if (stream == null)
                        continue;
                    引数がへん = true;
                }
        }
        if (引数がへん)
            throw new IllegalArgumentException("引数にへんなオブジェクトが入ってるようです。");
    }

    public static String get拡張子(String fileName) {
        String[] spritFileName = fileName.split("[.]");
        if (spritFileName.length < 2)
            return "";
        return spritFileName[(spritFileName.length - 1)];
    }

    public static String cut拡張子(String fileName)
            throws IllegalArgumentException {
        int cutLength = get拡張子(fileName).length() + 1;
        int returnLength = fileName.length() - cutLength;
        return StringUtils.left(fileName, returnLength);
    }

    public static String makeサムネイル名(Image image) {
        return image.getImageID() + ".tmn" + "." + image.getExtension();
    }

    public static String getサムネイル絶対URL(Image image) {
        if (image == null)
            return "Thawing gracier!";
        if ((image.getHeight().intValue() > 100)
                || (image.getWidth().intValue() > 100)) {
            return 定数.ぺったんURL + "/images/uploaded/tmn/" + image.getImageID()
                    + ".tmn" + "." + image.getExtension();
        }
        return get画像絶対URL(image);
    }

    public static String get画像絶対URL(Image image) {
        if (image == null)
            return null;
        return 定数.ぺったんURL + "/images/uploaded" + get画像名(image);
    }

    public static String get画像名(Image image) {
        if (image == null)
            return null;
        return "/" + image.getImageID() + "." + image.getExtension();
    }

    public static String get画像名NoSlash(Image image) {
        if (image == null)
            return null;
        return image.getImageID() + "." + image.getExtension();
    }

    public static String get画像名(FukidasiImage image) {
        return "/" + image.getName() + "." + image.getExtension();
    }

    public static String get画像名(Fukidasi fukidasi) {
        FukidasiImage image = fukidasi.getFukidasiImage();
        String imgName = image.getName();
        if (fukidasi.getWay().intValue() != 0) {
            imgName = setWay(imgName, fukidasi.getWay());
        }
        return "/" + imgName + "." + image.getExtension();
    }

    public static Integer[] コマ範囲算出(String reqKoma) {
        Matcher m = コマ範囲パターン.matcher(reqKoma);
        m.matches();
        Integer[] コマ範囲 = new Integer[2];
        コマ範囲[0] = Integer.valueOf(Integer.parseInt(m.group(1)));
        if (NumberUtils.isNumber(m.group(2)))
            コマ範囲[1] = Integer.valueOf(Integer.parseInt(m.group(2)));
        return コマ範囲;
    }

    public static String setWay(String imgName, Integer way) {
        Matcher m = IMG_WAY_PATTERN.matcher(imgName);
        m.matches();
        return m.group(1) + way + m.group(3);
    }

    public static void make100サムネイル(Image image) throws Exception {
        int width = image.getWidth().intValue();
        int height = image.getHeight().intValue();

        if ((width > 100) || (height > 100)) {
            if (width == height) {
                width = 100;
                height = 100;
            } else if (width > height) {
                double w = width;
                double h = height;
                double 倍率 = w / 100.0D;
                w = 100.0D;
                h /= 倍率;
                width = (int) w;
                height = (int) h;
            } else {
                double w = width;
                double h = height;
                double 倍率 = h / 100.0D;
                h = 100.0D;
                w /= 倍率;
                width = (int) w;
                height = (int) h;
            }
            ProcessBuilder pb = new ProcessBuilder(new String[] {
                    定数.imagemagickパス + "convert", "-thumbnail",
                    width + "x" + height,
                    "\"" + 定数.画像ディレクトリパス + get画像名NoSlash(image) + "\"",
                    "\"" + 定数.画像ディレクトリパス + "tmn/" + makeサムネイル名(image) + "\"" });

            System.out.println(pb.command());
            pb.start();
        }
    }

    public static List<String> makeStringList(String[] strings) {
        List<String> retList = new ArrayList<String>();
        Collections.addAll(retList, strings);
        return retList;
    }

    public static String makeRecentlySerif(String serif) {
        serif = serif.replaceAll("<br>", "　");
        if (serif.length() > 20)
            serif = StringUtils.left(serif, 20) + "...";
        return serif;
    }

    public static String escapeToHTML(String input) {
        String ret = input;
        ret = ret.replaceAll("&", "&amp;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        ret = ret.replaceAll("\r\n", "<br>");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("'", "&#39;");
        return ret;
    }

    public static String unescapeFromHTML(String input) {
        String ret = input;
        ret = ret.replaceAll("&amp;", "&");
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("<br>", "\\\\n");
        ret = ret.replaceAll("&quot;", "\\\"");
        ret = ret.replaceAll("&#39;", "\\'");
        return ret;
    }

    public static String space(int height) {
        return "<div style='height:" + height + "px'>&nbsp;</div>";
    }
}
