/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package ninnik.util.plugin;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

import javax.servlet.ServletException;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public class ScheduledTaskPlugin implements PlugIn {
    private static final Long ミリ秒での一日 = Long.valueOf(86400000L);

    private final ScheduledExecutorService scheduler = Executors
            .newScheduledThreadPool(1);
    private ScheduledFuture<?> リセッタハンドル;

    public void destroy() {
        this.リセッタハンドル.cancel(true);
    }

    public void init(ActionServlet servlet, ModuleConfig config)
            throws ServletException {
        コマ評価リセット();
    }

    public void コマ評価リセット() {
        Runnable リセッタ = new Runnable() {
            public void run() {
                peta.コマ評価Manager.全ユーザのコマ評価 = new HashMap<String, Set<Long>>();

                System.out.println("コマ評価リセットが実行されました");
            }
        };
        Calendar ca = Calendar.getInstance();
        ca.set(11, 0);
        ca.set(12, 0);
        ca.add(6, 1);
        Date 明日の０時 = ca.getTime();
        Long 初回リセットまでのミリ秒数 = Long.valueOf(明日の０時.getTime()
                - System.currentTimeMillis());

        this.リセッタハンドル = this.scheduler.scheduleAtFixedRate(リセッタ, 初回リセットまでのミリ秒数
                .longValue(), ミリ秒での一日.longValue(), TimeUnit.MILLISECONDS);
    }

    public void beepForAnHour() {
        Runnable beeper = new Runnable() {
            public void run() {
                System.out.println("beep");
            }
        };
        final ScheduledFuture<?> beeperHandle = this.scheduler.scheduleAtFixedRate(
                beeper, 10L, 10L, TimeUnit.SECONDS);

        this.scheduler.schedule(new Runnable() {
            public void run() {
                beeperHandle.cancel(true);
            }
        }, 3600L, TimeUnit.SECONDS);
    }
}
