/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/
package peta;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ninnik.util.SessionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import peta.dao.Usr;
import peta.exception.ActionErrors例外;

public abstract class Petaction extends Action {
    public final ActionForward execute(ActionMapping map, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        Session sess = null;
        ActionForward af = null;
        Transaction tran = null;
        try {
            sess = SessionManager.getSession();

            HttpSession httpSess = request.getSession();
            if ((httpSess.getAttribute("usr") == null)
                    && (httpSess.getLastAccessedTime() == httpSess
                            .getCreationTime())) {
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (("rubbish".equals(cookie.getName()))
                                && (StringUtils.isNotBlank(cookie.getValue()))) {
                            Query q = sess
                                    .createQuery("from Usr where rubbish = :rubbish");
                            q.setString("rubbish", cookie.getValue());
                            Usr u = (Usr) q.uniqueResult();
                            httpSess.setAttribute("usr", u);
                        }

                    }

                }

            }

            af = exec(map, form, request, response, sess, tran);
        } catch (Exception e) {
            if (tran != null)
                tran.rollback();
            e.printStackTrace();
        } finally {
            if (sess != null)
                sess.close();
        }
        return af;
    }

    public abstract ActionForward exec(ActionMapping paramActionMapping,
            ActionForm paramActionForm,
            HttpServletRequest paramHttpServletRequest,
            HttpServletResponse paramHttpServletResponse, Session paramSession,
            Transaction paramTransaction) throws Exception;

    protected ActionErrors例外 saveManyErrors(HttpServletRequest request,
            String[] errNames) {
        ActionErrors errors = new ActionErrors();
        for (String errName : errNames)
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE",
                    new ActionMessage(errName));
        saveErrors(request, errors);
        return new ActionErrors例外(errNames.toString());
    }

    protected ActionErrors例外 saveOneErrors(HttpServletRequest request,
            String errName) {
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_MESSAGE",
                new ActionMessage(errName));
        saveErrors(request, errors);
        return new ActionErrors例外(errName);
    }
}
