/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninnik.util.Utils;
import org.apache.commons.lang.StringUtils;

public class Fukidasi implements KomaElement {
    private Long fukidasiID;
    private Long komaID;
    private Long fukidasiImageID;
    private Integer topOffset;
    private Integer leftOffset;
    private Integer fontSize;
    private String fontColor;
    private String fontWeight;
    private String serif;
    private Integer delay;
    private Integer vanish;
    private Integer zIndex;
    private Integer way;
    private Integer textLeftOffset;
    private Integer textTopOffset;
    private String textAlign;
    private Integer widthPower;
    private Integer heightPower;
    private FukidasiImage fukidasiImage;

    public String getJSON() {
        String JSON = "{'type':'Fukidasi','fukidasiID':"
                + getFukidasiID()
                + ","
                + "'komaID':"
                + getKomaID()
                + ","
                + "'fukidasiImageID':"
                + getFukidasiImageID()
                + ","
                + "'topOffset':"
                + getTopOffset()
                + ","
                + "'leftOffset':"
                + getLeftOffset()
                + ","
                + "'fontSize':"
                + getFontSize()
                + ","
                + "'fontColor':'"
                + getFontColor()
                + "',"
                + "'fontWeight':'"
                + getFontWeight()
                + "',"
                + "'serif':'"
                + getSerif().replaceAll("'", "\\\\'").replaceAll("\r\n",
                        "\\\\n")
                + "',"
                + "'delay':"
                + getDelay()
                + ","
                + "'vanish':"
                + getVanish()
                + ","
                + "'komaID':"
                + getKomaID()
                + ","
                + "'zIndex':"
                + getZIndex()
                + ","
                + "'way':"
                + getWay()
                + ","
                + "'textLeftOffset':"
                + getTextLeftOffset()
                + ","
                + "'textTopOffset':"
                + getTextTopOffset()
                + ","
                + "'textAlign':'"
                + getTextAlign()
                + "',"
                + "'widthPower':'"
                + getWidthPower()
                + "',"
                + "'heightPower':"
                + getHeightPower()
                + ","
                + "'width':"
                + getWidthPower().intValue()
                        * getFukidasiImage().getWidth().intValue() / 100
                + ","
                + "'height':"
                + getHeightPower().intValue()
                        * getFukidasiImage().getHeight().intValue() / 100 + ","
                + "'src':'/images/fukidasi" + Utils.get画像名(this) + "',"
                + "'image':" + getFukidasiImage().getJSON() + "}";
        return JSON;
    }

    public Integer getHeightPower() {
        return this.heightPower;
    }

    public void setHeightPower(Integer heightPower) {
        this.heightPower = heightPower;
    }

    public Integer getWidthPower() {
        return this.widthPower;
    }

    public void setWidthPower(Integer widthPower) {
        this.widthPower = widthPower;
    }

    public Integer getVanishSecond() {
        return Integer.valueOf(this.delay.intValue() + this.vanish.intValue());
    }

    public Fukidasi() {
        if (getFontColor() == null)
            setFontColor("black");
        if (getFontSize() == null)
            setFontSize(Integer.valueOf(12));
        if (getFontWeight() == null)
            setFontWeight("normal");
        if (getLeftOffset() == null)
            setLeftOffset(Integer.valueOf(0));
        if (getTopOffset() == null)
            setTopOffset(Integer.valueOf(0));
        if (getDelay() == null)
            setDelay(Integer.valueOf(0));
        if (StringUtils.isEmpty(getSerif()))
            setSerif("");
    }

    public String getDispSerif() {
        Pattern pattern = Pattern.compile("(http://[a-zA-Z0-9/:?=&;%_.#-]+)");
        Matcher matcher = pattern.matcher(getSerif());
        return matcher.replaceAll("<a href=\"$1\" target=\"_parent\">$1</a>");
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Long getFukidasiID() {
        return this.fukidasiID;
    }

    public void setFukidasiID(Long fukidasiID) {
        this.fukidasiID = fukidasiID;
    }

    public Long getFukidasiImageID() {
        return this.fukidasiImageID;
    }

    public void setFukidasiImageID(Long fukidasiImageID) {
        this.fukidasiImageID = fukidasiImageID;
    }

    public Integer getLeftOffset() {
        return this.leftOffset;
    }

    public void setLeftOffset(Integer left) {
        this.leftOffset = left;
    }

    public Long getKomaID() {
        return this.komaID;
    }

    public void setKomaID(Long komaID) {
        this.komaID = komaID;
    }

    public Integer getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(Integer top) {
        this.topOffset = top;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getSerif() {
        return this.serif;
    }

    public void setSerif(String serif) {
        this.serif = serif;
    }

    public FukidasiImage getFukidasiImage() {
        return this.fukidasiImage;
    }

    public void setFukidasiImage(FukidasiImage fukidasiImage) {
        this.fukidasiImage = fukidasiImage;
    }

    public Integer getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(Integer index) {
        this.zIndex = index;
    }

    public Integer getTextLeftOffset() {
        return this.textLeftOffset;
    }

    public void setTextLeftOffset(Integer textLeftOffset) {
        this.textLeftOffset = textLeftOffset;
    }

    public Integer getTextTopOffset() {
        return this.textTopOffset;
    }

    public void setTextTopOffset(Integer textTopOffset) {
        this.textTopOffset = textTopOffset;
    }

    public Integer getWay() {
        return this.way;
    }

    public void setWay(Integer way) {
        this.way = way;
    }

    public Integer getVanish() {
        return this.vanish;
    }

    public void setVanish(Integer vanish) {
        this.vanish = vanish;
    }

    public int compareTo(Object object) {
        KomaElement e = (KomaElement) object;
        if (getZIndex().intValue() < e.getZIndex().intValue()) {
            return -1;
        }
        if (getZIndex().intValue() > e.getZIndex().intValue()) {
            return 1;
        }
        return 0;
    }
}
