/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import ninnik.util.Utils;

public class FukidasiImage {
    private Long fukidasiImageID;
    private String name;
    private Integer uploaderID;
    private String extension;
    private Integer width;
    private Integer height;
    private String explanation;
    private Integer textLeftOffset;
    private Integer textTopOffset;
    private Integer textWidth;
    private Integer textHeight;
    private Integer makableFlg;
    private Integer priority;
    private Integer wayVariety;
    private String borderVariety;
    private String fontColor;

    public String getJSON() {
        String JSON = "{'fukidasiImageID':" + getFukidasiImageID() + ","
                + "'name':'" + getName() + "'," + "'uploaderID':"
                + getUploaderID() + "," + "'extension':'" + getExtension()
                + "'," + "'width':" + getWidth() + "," + "'height':"
                + getHeight() + "," + "'explanation':'" + getExplanation()
                + "'," + "'textLeftOffset':" + getTextLeftOffset() + ","
                + "'textTopOffset':" + getTextTopOffset() + ","
                + "'textWidth':" + getTextWidth() + "," + "'textHeight':"
                + getTextHeight() + "," + "'wayVariety':" + getWayVariety()
                + "," + "'fontColor':'" + getFontColor() + "',"
                + "'src':'/images/fukidasi" + Utils.get画像名(this) + "'" + "}";
        return JSON;
    }

    public String[] getBorderVarietyAry() {
        return getBorderVariety().split(",");
    }

    public String getBorderVariety() {
        return this.borderVariety;
    }

    private void setBorderVariety(String borderVariety) {
        this.borderVariety = borderVariety;
    }

    public Integer getWayVariety() {
        return this.wayVariety;
    }

    private void setWayVariety(Integer wayVariety) {
        this.wayVariety = wayVariety;
    }

    public Integer getMakableFlg() {
        return this.makableFlg;
    }

    private void setMakableFlg(Integer makableFlg) {
        this.makableFlg = makableFlg;
    }

    public Integer getPriority() {
        return this.priority;
    }

    private void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getTextHeight() {
        return this.textHeight;
    }

    private void setTextHeight(Integer textHeight) {
        this.textHeight = textHeight;
    }

    public Integer getTextLeftOffset() {
        return this.textLeftOffset;
    }

    private void setTextLeftOffset(Integer textLeftOffset) {
        this.textLeftOffset = textLeftOffset;
    }

    public Integer getTextTopOffset() {
        return this.textTopOffset;
    }

    private void setTextTopOffset(Integer textTopOffset) {
        this.textTopOffset = textTopOffset;
    }

    public Integer getTextWidth() {
        return this.textWidth;
    }

    private void setTextWidth(Integer textWidth) {
        this.textWidth = textWidth;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public Long getFukidasiImageID() {
        return this.fukidasiImageID;
    }

    private void setFukidasiImageID(Long fukidasiImageID) {
        this.fukidasiImageID = fukidasiImageID;
    }

    public String getExtension() {
        return this.extension;
    }

    private void setExtension(String extension) {
        this.extension = extension;
    }

    public Integer getHeight() {
        return this.height;
    }

    private void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getUploaderID() {
        return this.uploaderID;
    }

    private void setUploaderID(Integer uploaderID) {
        this.uploaderID = uploaderID;
    }

    public Integer getWidth() {
        return this.width;
    }

    private void setWidth(Integer width) {
        this.width = width;
    }

    public String getExplanation() {
        return this.explanation;
    }

    private void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }
}
