/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.Query;
import org.hibernate.Session;

public class ImageTag implements Serializable {
    private static final long serialVersionUID = -3633456484285291999L;
    private Long imageTagID;
    private Integer seq;
    private Long imageID;
    private String tag;

    public static List<Object[]> getTagRankingAndCount(Session sess) {
        String hql = "select tag , count(*) as c from ImageTag where tag <> '' group by tag order by c desc";
        Query q = sess.createQuery(hql);
        return q.list();
    }

    public static List<String> getTagRanking(Session sess) {
        String hql = "select tag from ImageTag where tag <> '' group by tag order by count(*) desc";
        Query q = sess.createQuery(hql);
        return q.list();
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 39).append(getSeq())
                .append(getImageID()).toHashCode();
    }

    public boolean equals(Object o) {
        boolean b = false;
        if ((o != null) && (ImageTag.class.isAssignableFrom(o.getClass()))) {
            ImageTag i = (ImageTag) o;
            EqualsBuilder builder = new EqualsBuilder().append(getSeq(),
                    i.getSeq()).append(getImageID(), i.getImageID());
            b = builder.isEquals();
        }
        return b;
    }

    public Long getImageID() {
        return this.imageID;
    }

    public void setImageID(Long imageID) {
        this.imageID = imageID;
    }

    public Long getImageTagID() {
        return this.imageTagID;
    }

    public void setImageTagID(Long imageTagID) {
        this.imageTagID = imageTagID;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}
