/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ninnik.util.Utils;
import org.hibernate.Query;
import org.hibernate.Session;

public class Koma extends DateComparable {
//    private static final String white = "white";
    private Long komaSID;
    private Long komaID;
    private Long comicID;
    private Integer authorID;
    private Integer evalGood;
    private Date birthday;
    private Integer seqNO;
    private Integer autoMoveSec;
    private Integer komaWidth;
    private Integer komaHeight;
    private String borderFlg;
    private Long bgImageID;
    private String bgColor;
    private String delFlg;
    private Integer pageView;
    private String authorIP;
    private Integer nextPageCount;
    private List<Fukidasi> fukidasiList;
    private List<Picture> pictureList;
    private Usr author;
    private Comic comic;
    private Image bgImage;
    private Image coverImage;

    public void fetchKomaElems(Session sess) {
        Query q = sess.createQuery("from Fukidasi where komaID = :komaID");
        q.setLong("komaID", getKomaSID().longValue());
        setFukidasiList(q.list());

        q = sess.createQuery("from Picture where komaID = :komaID");
        q.setLong("komaID", getKomaSID().longValue());
        setPictureList(q.list());
    }

    public String getJSON() {
        String JSON = "{'type':'Koma','komaID':" + getKomaID() + ","
                + "'comicID':" + getComicID() + "," + "'authorID':"
                + getAuthorID() + "," + "'evalGood':" + getEvalGood() + ","
                + "'birthday':new Date('" + getBirthday() + "')," + "'seqNO':"
                + getSeqNO() + "," + "'autoMoveSec':" + getAutoMoveSec() + ","
                + "'komaWidth':" + getKomaWidth() + "," + "'komaHeight':"
                + getKomaHeight() + "," + "'borderFlg':'" + getBorderFlg()
                + "'," + "'bgImageID':" + getBgImageID() + "," + "'bgColor':'"
                + getBgColor() + "'," + "'fukidasi':" + getFukidasiListJSON()
                + "," + "'picture':" + getPictureListJSON() + ","
                + "'bgImageSrc':'" + "/images/uploaded"
                + Utils.get画像名(getBgImage()) + "'," + "'bgImageTmnSrc':'"
                + Utils.getサムネイル絶対URL(getBgImage()) + "'," + "'pageView':"
                + getPageView() + "}";
        return JSON;
    }

    private String getFukidasiListJSON() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int f = getFukidasiList().size();
        sb.append("{");
        for (Fukidasi fuki : getFukidasiList()) {
            sb.append(i + ":" + fuki.getJSON() + (f - 1 == i ? "" : ","));
            i++;
        }
        sb.append("}");
        return sb.toString();
    }

    private String getPictureListJSON() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int f = getPictureList().size();
        sb.append("{");
        for (Picture pic : getPictureList()) {
            sb.append(i + ":" + pic.getJSON() + (f - 1 == i ? "" : ","));
            i++;
        }
        sb.append("}");
        return sb.toString();
    }

    public Koma() {
        setEvalGood(Integer.valueOf(0));

        setDelFlg("0");
        setBirthday(new Date());
        setFukidasiList(new ArrayList<Fukidasi>());
        setAutoMoveSec(Integer.valueOf(0));
        setPageView(Integer.valueOf(0));
        setBgColor("white");
    }

    public Integer getAuthorID() {
        return this.authorID;
    }

    public void setAuthorID(Integer authorID) {
        this.authorID = authorID;
    }

    public Long getKomaID() {
        return this.komaID;
    }

    public void setKomaID(Long komaID) {
        this.komaID = komaID;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public void setBgImage(Image bgImage) {
        this.bgImage = bgImage;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public Integer getEvalGood() {
        return this.evalGood;
    }

    public void setEvalGood(Integer evalGood) {
        this.evalGood = evalGood;
    }

    public Long getComicID() {
        return this.comicID;
    }

    public void setComicID(Long comicID) {
        this.comicID = comicID;
    }

    public List<Fukidasi> getFukidasiList() {
        return this.fukidasiList;
    }

    public void setFukidasiList(List<Fukidasi> fukidasiList) {
        this.fukidasiList = fukidasiList;
    }

    public Usr getAuthor() {
        return this.author;
    }

    public void setAuthor(Usr author) {
        this.author = author;
    }

    public Integer getAutoMoveSec() {
        return this.autoMoveSec;
    }

    public void setAutoMoveSec(Integer autoMoveSec) {
        this.autoMoveSec = autoMoveSec;
    }

    public Integer getKomaHeight() {
        return this.komaHeight;
    }

    public void setKomaHeight(Integer komaHeight) {
        this.komaHeight = komaHeight;
    }

    public Integer getKomaWidth() {
        return this.komaWidth;
    }

    public void setKomaWidth(Integer komaWidth) {
        this.komaWidth = komaWidth;
    }

    public String getBorderFlg() {
        return this.borderFlg;
    }

    public void setBorderFlg(String borderFlg) {
        this.borderFlg = borderFlg;
    }

    public Long getBgImageID() {
        return this.bgImageID;
    }

    public void setBgImageID(Long bgImageID) {
        this.bgImageID = bgImageID;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public List<Picture> getPictureList() {
        return this.pictureList;
    }

    public void setPictureList(List<Picture> pictureList) {
        this.pictureList = pictureList;
    }

    public Image getCoverImage() {
        return this.coverImage;
    }

    public void setCoverImage(Image coverImage) {
        this.coverImage = coverImage;
    }

    public Integer getNextPageCount() {
        return this.nextPageCount;
    }

    public void setNextPageCount(Integer nextPageCount) {
        this.nextPageCount = nextPageCount;
    }

    public String getDelFlg() {
        return this.delFlg;
    }

    public void setDelFlg(String delFlg) {
        this.delFlg = delFlg;
    }

    public Integer getPageView() {
        return this.pageView;
    }

    public void setPageView(Integer pageView) {
        this.pageView = pageView;
    }

    Date getDateForCompare() {
        return getBirthday();
    }

    public Integer getSeqNO() {
        return this.seqNO;
    }

    public void setSeqNO(Integer seqNO) {
        this.seqNO = seqNO;
    }

    public Comic getComic() {
        return this.comic;
    }

    public void setComic(Comic comic) {
        this.comic = comic;
    }

    public String getAuthorIP() {
        return this.authorIP;
    }

    public void setAuthorIP(String authorIP) {
        this.authorIP = authorIP;
    }

    public Long getKomaSID() {
        return this.komaSID;
    }

    public void setKomaSID(Long komaSID) {
        this.komaSID = komaSID;
    }
}
