/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

public class Picture implements KomaElement {
    private Long pictureID;
    private Long komaID;
    private Long imageID;
    private Integer width;
    private Integer height;
    private Integer topOffset;
    private Integer leftOffset;
    private Integer delay;
    private Integer zIndex;
    private Integer vanish;
    private String link;
    private Image image;

    public String getJSON() {
        String JSON = "{'type':'Picture','pictureID':" + getPictureID() + ","
                + "'komaID':" + getKomaID() + "," + "'imageID':" + getImageID()
                + "," + "'width':" + getWidth() + "," + "'height':"
                + getHeight() + "," + "'topOffset':" + getTopOffset() + ","
                + "'leftOffset':" + getLeftOffset() + "," + "'delay':"
                + getDelay() + "," + "'zIndex':" + getZIndex() + ","
                + "'link':'" + getLink() + "'," + "'image':"
                + getImage().getJSON() + "}";
        return JSON;
    }

    public Integer getVanishSecond() {
        return Integer.valueOf(this.delay.intValue() + this.vanish.intValue());
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Long getImageID() {
        return this.imageID;
    }

    public void setImageID(Long imageID) {
        this.imageID = imageID;
    }

    public Integer getLeftOffset() {
        return this.leftOffset;
    }

    public void setLeftOffset(Integer leftOffset) {
        this.leftOffset = leftOffset;
    }

    public Long getKomaID() {
        return this.komaID;
    }

    public void setKomaID(Long komaID) {
        this.komaID = komaID;
    }

    public Long getPictureID() {
        return this.pictureID;
    }

    public void setPictureID(Long pictureID) {
        this.pictureID = pictureID;
    }

    public Integer getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(Integer topOffset) {
        this.topOffset = topOffset;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(Integer index) {
        this.zIndex = index;
    }

    public Integer getVanish() {
        return this.vanish;
    }

    public void setVanish(Integer vanish) {
        this.vanish = vanish;
    }

    public int compareTo(Object object) {
        KomaElement e = (KomaElement) object;
        if (getZIndex().intValue() < e.getZIndex().intValue()) {
            return -1;
        }
        if (getZIndex().intValue() > e.getZIndex().intValue()) {
            return 1;
        }
        return 0;
    }
}
