/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import java.io.Serializable;
import java.util.Date;
import ninnik.util.SessionManager;
import org.hibernate.Session;
import peta.form.LoginForm;

public class Usr implements Serializable {
    private static final long serialVersionUID = -5467810055832916055L;
    private Integer usrID;
    private String usrName;
    private String usrPassword;
    private Date lastEvaluateTime;
    private Date registerTime;
    private String mail;
    private String registerIP;
    private String rubbish;
    private Integer pageView;
    private String twitterID;
    private String twitterPassword;
    private static Usr nameless;
    private String authority;

    public static Usr getNameless() {
        if (nameless != null)
            return nameless;
        Session sess = SessionManager.getSession();
        nameless = (Usr) sess.get(Usr.class, Integer.valueOf(1));
        return nameless;
    }

    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        Usr that = (Usr) obj;
        if (getUsrID().equals(that.getUsrID()))
            return true;
        return getUsrName().equals(that.getUsrName());
    }

    public Usr() {
        setRegisterTime(new Date());
        setLastEvaluateTime(new Date(0L));
    }

    public String toString() {
        return "ID " + getUsrID() + " : " + getUsrName();
    }

    public Usr(LoginForm form) {
        this();
        setUsrName(form.getUsrName());
        setUsrPassword(form.getUsrPassword());
        setMail(form.getMail());
        setPageView(Integer.valueOf(0));
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public Date getLastEvaluateTime() {
        return this.lastEvaluateTime;
    }

    public void setLastEvaluateTime(Date lastEvaluateTime) {
        this.lastEvaluateTime = lastEvaluateTime;
    }

    public String getUsrName() {
        return this.usrName;
    }

    public void setUsrName(String usrName) {
        this.usrName = usrName;
    }

    public String getUsrPassword() {
        return this.usrPassword;
    }

    public void setUsrPassword(String usrPassword) {
        this.usrPassword = usrPassword;
    }

    public Date getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Integer getUsrID() {
        return this.usrID;
    }

    public void setUsrID(Integer usrID) {
        this.usrID = usrID;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getRegisterIP() {
        return this.registerIP;
    }

    public void setRegisterIP(String registerIP) {
        this.registerIP = registerIP;
    }

    public String getRubbish() {
        return this.rubbish;
    }

    public void setRubbish(String rubbish) {
        this.rubbish = rubbish;
    }

    public Integer getPageView() {
        return this.pageView;
    }

    public void setPageView(Integer pageView) {
        this.pageView = pageView;
    }

    public String getTwitterID() {
        return this.twitterID;
    }

    public void setTwitterID(String twitterID) {
        this.twitterID = twitterID;
    }

    public String getTwitterPassword() {
        return this.twitterPassword;
    }

    public void setTwitterPassword(String twitterPassword) {
        this.twitterPassword = twitterPassword;
    }
}
