/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.form;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.hibernate.Query;
import org.hibernate.Session;
import peta.dao.Usr;

public class LoginForm extends ActionForm {
    private static final long serialVersionUID = 9191997817614945894L;
    private String usrName;
    private String usrPassword;
    private String mail;
    private String twitterID;
    private String twitterPassword;
    private String comment;
    private String process;
    private String rubbish;
    private String ログイン後の画面更新なしフラグ;

    public ActionErrors validate(ActionMapping mapping,
            HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        return errors;
    }

    public String check(Session sess, Usr usr) {
        if (StringUtils.isBlank(getUsrName()))
            return "エラー・ユーザ名空";
        if (StringUtils.isBlank(getMail()))
            return "エラー・メールアドレス空";

        if (usr == null) {
            Query nameQ = sess
                    .createQuery("select count(*) from Usr where usrName = :usrName");
            nameQ.setString("usrName", getUsrName());
            Number nameC = (Number) nameQ.uniqueResult();
            if (nameC.intValue() > 0)
                return "エラー・ユーザ名重複";

            Query mailQ = sess
                    .createQuery("select count(*) from Usr where mail = :mail");
            mailQ.setString("mail", getMail());
            Number mailC = (Number) mailQ.uniqueResult();
            if (mailC.intValue() > 0)
                return "エラー・メールアドレス重複";
        } else {
            Query usrQ = sess
                    .createQuery("select usrName , usrID from Usr where usrName = :usrName");
            usrQ.setString("usrName", getUsrName());
            List<?> usrNames = usrQ.list();
            if (usrNames.size() > 1)
                return "エラー・致命的なエラー";
            if ((usrNames.size() == 1)
                    && (!((Object[]) usrNames.get(0))[1].equals(usr.getUsrID())))
                return "エラー・ユーザ名重複";

            Query mailQ = sess
                    .createQuery("select mail , usrID from Usr where mail = :mail");
            mailQ.setString("mail", getMail());
            List<?> mailUsrs = mailQ.list();
            if (mailUsrs.size() > 1)
                return "エラー・致命的なエラー";
            if ((mailUsrs.size() == 1)
                    && (!((Object[]) mailUsrs.get(0))[1].equals(usr.getUsrID())))
                return "エラー・メールアドレス重複";
        }

        return "";
    }

    public String getログイン後の画面更新なしフラグ() {
        return this.ログイン後の画面更新なしフラグ;
    }

    public void setログイン後の画面更新なしフラグ(String ログイン後の画面更新なしフラグ) {
        this.ログイン後の画面更新なしフラグ = ログイン後の画面更新なしフラグ;
    }

    public String getRubbish() {
        return this.rubbish;
    }

    public void setRubbish(String rubbish) {
        this.rubbish = rubbish;
    }

    public LoginForm() {
        setProcess("ログイン");
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getUsrName() {
        return this.usrName;
    }

    public void setUsrName(String usrName) {
        this.usrName = usrName;
    }

    public String getUsrPassword() {
        return this.usrPassword;
    }

    public void setUsrPassword(String usrPassword) {
        this.usrPassword = usrPassword;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getTwitterID() {
        return this.twitterID;
    }

    public void setTwitterID(String twitterID) {
        this.twitterID = twitterID;
    }

    public String getTwitterPassword() {
        return this.twitterPassword;
    }

    public void setTwitterPassword(String twitterPassword) {
        this.twitterPassword = twitterPassword;
    }
}
