/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.struts.action.ActionForm;
import peta.dao.Fukidasi;
import peta.dao.Picture;

public class MakeForm extends ActionForm {
    private static final long serialVersionUID = -7104641522032241752L;
    private Long comicID;
    private String title;
    private Integer pageAutoMoveSec;
    private Integer comicAutoMoveSec;
    private String borderFlg;
    private Integer komaWidth;
    private Integer komaHeight;
    private Long bgImageID;
    private String makerFreeFlg;
    private String bgColor;
    private String comicType;
    private String delFlg;
    private Integer editSeqNO;
    private List<Fukidasi> fukidasis;
    private List<Picture> pictures;

    public MakeForm() {
        this.fukidasis = new ArrayList<Fukidasi>();
        this.pictures = new ArrayList<Picture>();
    }

    public Picture getPicture(int i) {
        while (this.pictures.size() <= i)
            this.pictures.add(new Picture());
        return (Picture) this.pictures.get(i);
    }

    public void setPicture(Picture picture) {
        this.pictures.add(picture);
    }

    public Fukidasi getFukidasi(int i) {
        while (this.fukidasis.size() <= i)
            this.fukidasis.add(new Fukidasi());
        return (Fukidasi) this.fukidasis.get(i);
    }

    public void setFukidasi(Fukidasi fukidasi) {
        this.fukidasis.add(fukidasi);
    }

    public List<Fukidasi> getFukidasis() {
        return this.fukidasis;
    }

    public void setFukidasis(List<Fukidasi> fukidasis) {
        this.fukidasis = fukidasis;
    }

    public List<Picture> getPictures() {
        return this.pictures;
    }

    public void setPictures(List<Picture> pictures) {
        this.pictures = pictures;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getComicAutoMoveSec() {
        return this.comicAutoMoveSec;
    }

    public void setComicAutoMoveSec(Integer comicAutoMoveSec) {
        this.comicAutoMoveSec = comicAutoMoveSec;
    }

    public Integer getPageAutoMoveSec() {
        return this.pageAutoMoveSec;
    }

    public void setPageAutoMoveSec(Integer pageAutoMoveSec) {
        this.pageAutoMoveSec = pageAutoMoveSec;
    }

    public String getBorderFlg() {
        return this.borderFlg;
    }

    public void setBorderFlg(String borderFlg) {
        this.borderFlg = borderFlg;
    }

    public Integer getKomaHeight() {
        return this.komaHeight;
    }

    public void setKomaHeight(Integer komaHeight) {
        this.komaHeight = komaHeight;
    }

    public Integer getKomaWidth() {
        return this.komaWidth;
    }

    public void setKomaWidth(Integer komaWidth) {
        this.komaWidth = komaWidth;
    }

    public Long getBgImageID() {
        return this.bgImageID;
    }

    public void setBgImageID(Long bgImageID) {
        this.bgImageID = bgImageID;
    }

    public String getMakerFreeFlg() {
        return this.makerFreeFlg;
    }

    public void setMakerFreeFlg(String makerFreeFlg) {
        this.makerFreeFlg = makerFreeFlg;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public Long getComicID() {
        return this.comicID;
    }

    public void setComicID(Long comicID) {
        this.comicID = comicID;
    }

    public String getComicType() {
        return this.comicType;
    }

    public void setComicType(String comicType) {
        this.comicType = comicType;
    }

    public String getDelFlg() {
        return this.delFlg;
    }

    public void setDelFlg(String delFlg) {
        this.delFlg = delFlg;
    }

    public Integer getEditSeqNO() {
        return this.editSeqNO;
    }

    public void setEditSeqNO(Integer editSeqNO) {
        this.editSeqNO = editSeqNO;
    }
}
