#!/usr/bin/perl
#####################################################################
# Function: ja.pm
#
#
# 概要:
# PG-REX 便利ツールから呼び出すメッセージの集まり
# JPN ロケール用
# 
# 特記事項:
# なし
#
# Copyright (c) 2012-2017, NIPPON TELEGRAPH AND TELEPHONE CORPORATION
#
#####################################################################
use warnings;
use strict;

use constant {

    MASTERSTART_USAGE  => <<_MASTERSTART_USAGE_,
PG-REX を Master として起動するツールです
Master として起動したいノードで実行します

Usage:
  pg-rex_master_start [-h] [-v] [CrmFilePath] 

CrmFilePath       初回起動時のみ crm ファイルのファイルパスを指定します

Options:
  -h, --help      Usage を表示して終了します
  -v, --version   バージョン情報を表示して終了します

_MASTERSTART_USAGE_

    MASTERSTART_MS0001  => "Ctrl+C は本プログラムでは無効です\n",
    MASTERSTART_MS0002  => "指定された crm ファイルが存在しません\n",
    MASTERSTART_MS0004  => "crm ファイルの読み込みに失敗したためスクリプトを終了します\n",
    MASTERSTART_MS0007  => "[0]. Pacemaker および Corosync が停止していることを確認\n",
    MASTERSTART_MS0008  => "...[NG]\n",
    MASTERSTART_MS0009  => "自身のノードで Pacemaker または Corosync が稼働しています\n".
                           "Master 起動処理を中止します\n",
    MASTERSTART_MS0010  => "...[OK]\n",
    MASTERSTART_MS0011  => "[0]. 稼働中の Master が存在していないことを確認\n",
    MASTERSTART_MS0013  => "相手のノードで Master が稼働中です\n".
                           "Master 起動処理を中止します\n",
    MASTERSTART_MS0014  => "[0]. 起動禁止フラグの存在を確認\n",
    MASTERSTART_MS0015  => "起動禁止フラグ \"[0]\" が存在するため Master の起動処理を中止します\n",
    MASTERSTART_MS0016  => "[0] 配下に既に cib ファイルがあります\n".
                           "削除して反映しても宜しいでしょうか？ (y/N) ",
    MASTERSTART_MS0017  => "スクリプトを終了します\n",
    MASTERSTART_MS0018  => "[0]. [1] 配下の cib ファイルを削除\n",
    MASTERSTART_MS0019  => "[0]. Pacemaker 起動\n",
    MASTERSTART_MS0020  => "[0]. crm ファイルの反映\n",
    MASTERSTART_MS0021  => "Pacemaker 起動確認処理のタイムアウト時間([0]秒)を経過したためスクリプトを終了します\n".
                           "[1] が起動していません\n".
                           "Pacemaker の状態の詳細は、crm_mon コマンドで確認してください\n",
    MASTERSTART_MS0022  => "[0]. Master の起動確認\n",
    MASTERSTART_MS0023  => "Pacemaker の起動中にリソース故障が発生しました\n".
                           "Pacemaker の状態の詳細は、crm_mon コマンドを用いて確認してください\n",
    MASTERSTART_MS0026  => "ノード([0])が Master として起動しました\n",
    MASTERSTART_MS0027  => "[0]. Master として稼働することが出来るかを確認\n",
    MASTERSTART_MS0028  => "自身のノードの [0]-data-status の値が \"[1]\" になっています\n".
                           "[0]-data-status が初回起動などでまだ登録されていない状態か \"LATEST\" か \"STREAMING|SYNC\" の値でないと\n".
                           "DB クラスタが最新でない可能性があるため、Master として稼働することができません\n".
                           "Master 起動処理を中止します\n",
    MASTERSTART_MS0029  => "root@[0]'s password:",
    MASTERSTART_MS0030  => "\nパスワードが入力されました\n",
    MASTERSTART_MS0032  => "crm ファイルの Pacemaker への反映に失敗したためスクリプトを終了します\n".
                           "Pacemaker を停止し、[0] の内容を確認してください\n",
    MASTERSTART_MS0033  => "crm ファイルにリソース ID \"[0]\" の \"[1]\" のパラメータが存在していません\n",
    MASTERSTART_MS0034  => "pg-rex_slave_startで巻き戻しに失敗したDBクラスタのため起動できません。\n",

    SLAVESTART_USAGE  => <<_SLAVESTART_USAGE_,
PG-REX を Slave として起動するツールです
Slave として起動したいノードで実行します

Usage:
  pg-rex_slave_start [[-n] [-r] [-b | -f] | -c] [-d] [-s] [-o OPTIONS] [-h] [-v]

Options:
  -n, --normal                    現在のDBクラスタを使用して Slave を起動します
  -r, --rewind                    現在のDBクラスタに相手 (Master) ノードと
                                  同期したうえでレプリケーションを行えるように、
                                  巻き戻し後、Slave を起動します
  -b, --basebackup                相手ノードをMasterとしてベースバックアップを
                                  取得後、Slave として起動します
  -f, --force                     -b オプションに同じ。廃止予定
  -d, --dry-run                   データの変更とノードの起動の実行を伴わず、
                                  表示のみを行います
  -c, --check-only                DB クラスタの状態確認までを実施します
  -s, --shared-archive-directory  Master と Slave でアーカイブディレクトリを
                                  共有しているものとして動作します
  -o, --options=OPTIONS           pg_basebackup に渡すオプションを指定します
  -h, --help                      Usage を表示して終了します
  -v, --version                   バージョン情報を表示して終了します

_SLAVESTART_USAGE_
    
    SLAVESTART_MS0001   => "Ctrl+C は本プログラムでは無効です\n",
    SLAVESTART_MS0002   => "相手のノードと同じクラスタ認証ファイルを配置する必要があります: [0]\n",
    SLAVESTART_MS0004   => "[0]. Pacemaker および Corosync が停止していることを確認\n",
    SLAVESTART_MS0005   => "...[NG]\n",
    SLAVESTART_MS0006   => "自身のノードで Pacemaker または Corosync が稼働しています\n".
                           "Slave の起動処理を中止します\n",
    SLAVESTART_MS0007   => "...[OK]\n",
    SLAVESTART_MS0008   => "[0]. 稼働中の Master が存在していることを確認\n",
    SLAVESTART_MS0010   => "相手のノードで Master が稼働していません\n".
                           "Slave の起動処理を中止します\n",
    SLAVESTART_MS0011   => "[0]. IC-LAN が接続されていることを確認\n",
    SLAVESTART_MS0012   => "IC-LAN の接続応答がありません\n",
    SLAVESTART_MS0013   => "[0]. 起動禁止フラグが存在しないことを確認\n",
    SLAVESTART_MS0014   => "起動禁止フラグ \"[0]\" が存在するため Slave の起動処理を中止します\n".
                           "前回停止時に Master として稼働していた可能性があるので Slave として起動していいかどうかを確認してください\n",
    SLAVESTART_MS0015   => "[0]. Master からベースバックアップ取得\n",
    SLAVESTART_MS0018   => "readlink コマンドの実行に失敗しました\n",
    SLAVESTART_MS0019   => "[0]. Master のアーカイブディレクトリと同期\n",
    SLAVESTART_MS0020   => "[0]. [1] 配下のファイルを削除\n",
    SLAVESTART_MS0021   => "[0]. Slave の起動 (アーカイブリカバリ対象 WAL セグメント数: [1])\n",
    SLAVESTART_MS0022   => "[0]. Slave の起動確認\n",
    SLAVESTART_MS0024   => "Pacemaker の起動中にリソース故障が発生しました\n".
                           "Pacemaker の状態の詳細は、crm_mon コマンドで確認してください\n",
    SLAVESTART_MS0029   => "ノード([0])が Slave として起動しました\n",
    SLAVESTART_MS0032   => "アーカイブディレクトリにファイルが存在するため処理を継続できません: [0]\n",
    SLAVESTART_MS0033   => "DB クラスタが存在していません\n",
    SLAVESTART_MS0034   => "[0]. DB クラスタの状態を確認\n",
    SLAVESTART_MS0035   => "DB クラスタのバージョンが取得できません\n",
    SLAVESTART_MS0036   => "DB クラスタのバージョン ([0]) が PostgreSQL サーバのバージョン ([1]) と一致していません\n",
    SLAVESTART_MS0037   => "自身のノードと相手のノードでデータベース識別子が異なっています ([0] != [1])\n",
    SLAVESTART_MS0038   => "自身のノードの タイムラインID のほうが相手のノードの タイムラインID よりも大きくなっています ([0] > [1])\n",
    SLAVESTART_MS0039   => "自身のノードに WAL ファイルが存在しません: [0]\n",
    SLAVESTART_MS0040   => "相手のノードに WAL ファイルが存在しません: [0]\n",
    SLAVESTART_MS0041   => "自身のノードの XLOG の位置のほうが相手のノードの XLOG の位置よりも進んでいます ([0] > [1])\n",
    SLAVESTART_MS0042   => "相手のノードに最新のタイムライン履歴ファイルが存在しません: [0]\n",
    SLAVESTART_MS0043   => "相手のノードのタイムラインIDに対応するタイムライン履歴ファイル \"[0]\" に自身のノードのタイムラインIDを通った履歴が残っていません\n",
    SLAVESTART_MS0044   => "相手ノードは自身のノードのLSNより以前に昇格しています\n",
    SLAVESTART_MS0045   => "自身のノードをベースバックアップから再構築してください\n",
    SLAVESTART_MS0046   => "Pacemaker 起動確認処理のタイムアウト時間([0]秒)を経過したためスクリプトを終了します\n",
    SLAVESTART_MS0047   => "[0] の同期レプリケーション状態が確立されていません\n".
                           "[0] の状態を確認してください\n",
    SLAVESTART_MS0048   => "[0] が起動していません\n".
                           "Pacemaker の状態の詳細は、crm_mon コマンドで確認してください\n",
    SLAVESTART_MS0049   => "アーカイブディレクトリのタイムライン履歴ファイルが処理できません (未知の拡張子: [0])\n",
    SLAVESTART_MS0050   => "[0].[1] 現在のDBクラスタのまま起動が可能か確認\n",
    SLAVESTART_MS0051   => "[0].[1] 巻き戻しを実行することで起動が可能か確認\n",
    SLAVESTART_MS0052   => "[0].[1] ベースバックアップを取得することが可能か確認\n",
    SLAVESTART_MS0053   => "自身のノードと相手のノードのタイムラインID([0])の分岐点が異なっています\n",
    SLAVESTART_MS0054   => "自身のノードに recovery.conf ファイルが存在します: [0]\n",
    SLAVESTART_MS0055   => "相手ノードの full_page_writes は有効である必要があります\n",
    SLAVESTART_MS0056   => "DBクラスタが --data-checksums 付きで作成されているか、wal_log_hints が on である必要があります\n",
    SLAVESTART_MS0057   => "pg_rewind を実行可能な状態にできません - pg_rewind 以外の方法を使ってください\n",
    SLAVESTART_MS0058   => "\n指定された起動方法に実行可能なものがありませんでした\n",
    SLAVESTART_MS0059   => "\n以下の方法で起動が可能です\n",
    SLAVESTART_MS0060   => "n) 現在のDBクラスタのままSlaveを起動\n",
    SLAVESTART_MS0061   => "r) 現在のDBクラスタを巻き戻してSlaveを起動\n",
    SLAVESTART_MS0062   => "b) ベースバックアップを取得してSlaveを起動\n",
    SLAVESTART_MS0063   => "q) Slaveの起動を中止する\n",
    SLAVESTART_MS0064   => "起動方法を選択してください([0]) ",
    SLAVESTART_MS0065   => "Slave の起動処理を中止します\n",
    SLAVESTART_MS0066   => "選択範囲外の入力がありました\n",
    SLAVESTART_MS0067   => "\n現在のDBクラスタのまま起動します。\n\n",
    SLAVESTART_MS0068   => "\n巻き戻し実行後に起動します。\n\n",
    SLAVESTART_MS0069   => "\nベースバックアップ取得後に起動します。\n\n",
    SLAVESTART_MS0070   => "[0]. DBクラスタの巻き戻し\n",
    SLAVESTART_MS0071   => "自身のノードを巻き戻します\n",
    SLAVESTART_MS0072   => "相手ノードとの分岐点まで状態を戻すことができないため pg_rewind は利用できません\n",
    SLAVESTART_MS0073   => "ssh の接続に失敗しました([0])\n - 巻き戻しを中断します\n",
    SLAVESTART_MS0074   => "pg_rewind が相手のノードへの接続に失敗しました\n - 相手ノードの sshd_config で TCP Forwarding が無効になっている可能性があります\n",
    SLAVESTART_MS0075   => "pg-rex_slave_startで巻き戻しに失敗したDBクラスタです。\n",
    SLAVESTART_MS0076   => "アーカイブディレクトリに相手のノードの XLOG の位置よりも進んだ WAL ファイルが存在します\n",
    SLAVESTART_MS0099   => "内部エラー\n",

    STOP_USAGE  => <<_STOP_USAGE_,
PG-REX の Master または Slave を停止するツールです
停止したいノードで実行します

Usage:
  pg-rex_stop [-f] [-h] [-v]

Options:
  -f, --fast      停止前に CHECKPOINT と sync コマンドを実行しません
  -h, --help      Usage を表示して終了します
  -v, --version   バージョン情報を表示して終了します

_STOP_USAGE_
    
    STOP_MS0001         => "Ctrl+C は本プログラムでは無効です\n",
    STOP_MS0004         => "既に Pacemaker および Corosync は停止しているため停止処理を終了します\n",
    STOP_MS0005         => "PostgreSQL の状態を確認できませんでした\n".
                           "Pacemaker を停止します\n",
    STOP_MS0006         => "Master を停止します\n",
    STOP_MS0007         => "Slave を停止します\n",
    STOP_MS0009         => "スクリプトを停止します\n",
    STOP_MS0010         => "1. Pacemaker 停止\n",
    STOP_MS0011         => "...[OK]\n",
    STOP_MS0012         => "2. Pacemaker 停止確認\n",
    STOP_MS0013         => "...[NG]\n",
    STOP_MS0014         => "Pacemaker の停止確認処理のタイムアウト時間([0]秒)を経過したのでスクリプトを終了します\n".
                           "Pacemaker および Corosync のプロセスが正常に停止されているかを確認してください\n",
    STOP_MS0015         => "ノード([0])で Pacemaker を停止しました\n",
    STOP_MS0016         => "PG-REX の [0] ([1])を停止しました\n",
    STOP_MS0018         => "Slave がまだ起動しています\n",
    STOP_MS0019         => "系切り替えが目的の場合は pg-rex_switchover コマンドの使用を推奨します\n",
    STOP_MS0020         => "今停止すると F/O しますが本当に停止しても宜しいですか？ (y/N) ",

    ARCHDELETE_USAGE  => <<_ARCDELETE_USAGE_,
PG-REX 運用中に作成された、不要なアーカイブログを削除するツールです

Usage:
  pg-rex_archivefile_delete {-m|-r} [-f] [-D DBclusterFilepath] [-h] [-v]
                            [[Hostname:]BasebackupPath]

Hostname        ベースバックアップが存在するリモートサーバを指定します

BasebackupPath  ベースバックアップの場所の絶対パスを指定します

Options:
  -m, --move                         移動モードで実行します
  -r, --remove                       削除モードで実行します
  -f, --force                        アーカイブログの削除を問い合わせ無しで
                                     実行します
  -D, --dbcluster=DBclusterFilepath  両系で使用している DB クラスタの場所の
                                     絶対パスを指定します
  -h, --help                         Usage を表示して終了します
  -v, --version                      バージョン情報を表示して終了します

_ARCDELETE_USAGE_
    
    ARCHDELETE_MS0001   => "Ctrl+C は本プログラムでは無効です\n",
    ARCHDELETE_MS0002   => "移動モードか 削除モードのどちらか片方を指定してください\n",
    ARCHDELETE_MS0003   => "\n**** 1. 実行準備 ****\n",
    ARCHDELETE_MS0004   => "移動モードで実行します\n",
    ARCHDELETE_MS0005   => "削除モードで実行します\n",
    ARCHDELETE_MS0006   => "バックアップパスのフォーマットが不正です : \"[0]\"\n",
    ARCHDELETE_MS0007   => "ベースバックアップが存在するリモートサーバを入力してください\n".
                           "(入力しなければ \"localhost\" を設定します)\n".
                           "> ",
    ARCHDELETE_MS0008   => "リモートサーバの入力が不正です : \"[0]\"\n",
    ARCHDELETE_MS0009   => "ベースバックアップの場所の絶対パスを入力してください\n".
                           "(入力しなければバックアップ指定無しとして実行されアーカイブが削除されるため、\n".
                           " 以前に取得したベースバックアップが使用できなくなります)\n".
                           "> ",
    ARCHDELETE_MS0010   => "ベースバックアップの場所の絶対パスの入力が不正です : \"[0]\"\n",
    ARCHDELETE_MS0011   => "リモートサーバ \"[0]\" 、ベースバックアップの場所 \"[1]\" を指定しました\n".
                           "よろしいでしょうか (y/N) : ",
    ARCHDELETE_MS0012   => "スクリプトを終了します\n",
    ARCHDELETE_MS0013   => "環境設定ファイル (pg-rex_tools.conf) を読み込みます\n",
    ARCHDELETE_MS0015   => "両系のノード名を取得します\n",
    ARCHDELETE_MS0016   => "cib.xml ファイルを読み込みます\n",
    ARCHDELETE_MS0018   => "ベースバックアップの場所を指定せずに実行すると、\n".
                           "自身のノード \"[0]\" と相手のノード \"[1]\" の\n".
                           "現時点の PGDATA \"[2]\" を基準にしてアーカイブログを削除することになります\n".
                           "アーカイブログを削除しますか (y/N) : ",
    ARCHDELETE_MS0019   => "\n**** 2. WAL ファイル名の取得 ****\n",
    ARCHDELETE_MS0020   => "指定されたバックアップからリカバリを行うために必要な最初の WAL ファイル名を取得します\n",
    ARCHDELETE_MS0021   => "ディレクトリ \"[0]\" が存在しません\n",
    ARCHDELETE_MS0022   => "バックアップラベルファイル \"[0]\" の一行目のフォーマットが正しくありません\n",
    ARCHDELETE_MS0023   => " \"[0]\" \n",
    ARCHDELETE_MS0024   => "自身のノード \"[0]\" の現時点の PGDATA \"[1]\" からリカバリに必要な最初の WAL ファイル名を取得します\n",
    ARCHDELETE_MS0025   => "pg_controldata の結果が空のためリカバリに必要な最初の WAL ファイル名を取得できません\n",
    ARCHDELETE_MS0026   => "相手のノード \"[0]\" の現時点の PGDATA \"[1]\" からリカバリに必要な最初の WAL ファイル名を取得します\n",
    ARCHDELETE_MS0027   => "\n**** 3. 削除基準の算出 ****\n",
    ARCHDELETE_MS0028   => "削除基準がないためスクリプトを終了します\n",
    ARCHDELETE_MS0029   => "削除基準を \"[0]\" としました\n",
    ARCHDELETE_MS0030   => "\n**** 4. アーカイブログの削除 ****\n",
    ARCHDELETE_MS0031   => "アーカイブディレクトリ \"[0]\" の確認に失敗しました\n",
    ARCHDELETE_MS0032   => "削除対象のリストに \"[0]\" を追加します\n",
    ARCHDELETE_MS0033   => "削除対象のリストが空のためスクリプトを終了します\n",
    ARCHDELETE_MS0034   => "移動先ディレクトリ \"[0]\" が既に存在しています\n",
    ARCHDELETE_MS0035   => "移動先ディレクトリ \"[0]\" の作成に失敗しました\n",
    ARCHDELETE_MS0036   => "移動先ディレクトリ \"[0]\" の postgres ユーザへの変更に失敗しました\n",
    ARCHDELETE_MS0037   => "移動先ディレクトリ \"[0]\" を作成しました\n",
    ARCHDELETE_MS0038   => "ファイル \"[0]\" の移動に失敗しました\n",
    ARCHDELETE_MS0039   => " -- 移動 -- [0] \n",
    ARCHDELETE_MS0040   => "アーカイブログの移動に成功しました\n".
                           "移動モード実行のため、移動したファイルは \"[0]\" に格納されています\n",
    ARCHDELETE_MS0041   => "ファイル \"[0]\" の削除に失敗しました\n",
    ARCHDELETE_MS0042   => " -- 削除 -- [0] \n",
    ARCHDELETE_MS0043   => "アーカイブログの削除に成功しました\n",
    ARCHDELETE_MS0044   => "DB クラスタの場所の絶対パスを取得できませんでした\n".
                           "-D オプションで DB クラスタの場所の絶対パスを指定してください\n",
    ARCHDELETE_MS0045   => "\n**** 4. アーカイブログの移動 ****\n",
    ARCHDELETE_MS0046   => "ベースバックアップ格納先サーバへの ssh 接続に失敗しました\n",

    SWITCHOVER_USAGE  => <<_SWITCHOVER_USAGE_,
PG-REX の系切り替えを実行するツールです
  
Usage:
  pg-rex_switchover [-h] [-v]
  
Options:
  -h, --help      Usage を表示して終了します
  -v, --version   バージョン情報を表示して終了します

_SWITCHOVER_USAGE_
    
    SWITCHOVER_MS0001   => "Ctrl+C は本プログラムでは無効です\n",
    SWITCHOVER_MS0002   => "**** 実行準備 ****\n",
    SWITCHOVER_MS0003   => "[0]. 環境設定ファイル (pg-rex_tools.conf) の読み込みと両系のノード名を取得\n",
    SWITCHOVER_MS0004   => "...[OK]\n",
    SWITCHOVER_MS0005   => "...[NG]\n",
    SWITCHOVER_MS0008   => "[0]. 現在および系切り替え後のクラスタ状態を確認\n",
    SWITCHOVER_MS0009   => "クラスタ状態が以下の条件を満たしていないため系切り替えを実行できません\n".
                           " (1) Pacemaker、Corosync および PostgreSQL が両系で稼働している\n".
                           " (2) Master と Slave が存在している\n".
                           " (3) PostgreSQL が同期レプリケーション状態である\n",
    SWITCHOVER_MS0010   => "[ 現在のクラスタ状態 ]\n",
    SWITCHOVER_MS0011   => "[ 現在 / 系切り替え後のクラスタ状態 ]\n",
    SWITCHOVER_MS0012   => "系切り替え中は可用性が保証されません\n",
    SWITCHOVER_MS0013   => "また、現在 [0] に複数の Slave が存在しています\n",
    SWITCHOVER_MS0014   => "系切り替えを実行してもよろしいでしょうか？ (y/N) ",
    SWITCHOVER_MS0015   => "スクリプトを終了します\n",
    SWITCHOVER_MS0016   => "[0]. vacuumdb コマンドの実行\n",
    SWITCHOVER_MS0017   => "[0]. CHECKPOINT の実行\n",
    SWITCHOVER_MS0018   => "**** 系切り替えを実行 ****\n",
    SWITCHOVER_MS0019   => "[0]. Pacemaker の監視を停止\n",
    SWITCHOVER_MS0020   => "[0]. Master ([1]) の PostgreSQL を停止\n",
    SWITCHOVER_MS0021   => "[0]. Pacemaker の監視を再開し系切り替えを実行\n",
    SWITCHOVER_MS0022   => "[0]. [1] が新 Master になったことを確認\n",
    SWITCHOVER_MS0023   => "リソース起動確認処理のタイムアウト時間([0]秒)を経過したためスクリプトを終了します\n".
                           "[1] が起動していません\n".
                           "Pacemaker の状態の詳細は、crm_mon コマンドで確認してください\n",
    SWITCHOVER_MS0026   => "[0]. [1] の Pacemaker を停止\n",
    SWITCHOVER_MS0027   => "Pacemaker の停止確認処理のタイムアウト時間([0]秒)を経過したのでスクリプトを終了します\n".
                           "Pacemaker の状態の詳細は、crm_mon コマンドで確認してください\n",
    SWITCHOVER_MS0028   => "[0]. [1] で Slave を起動\n",
    SWITCHOVER_MS0030   => "**** [0] が Slave として起動しました ****\n",
    SWITCHOVER_MS0031   => "****************************************\n".
                           "**** 系切り替えが正常に完了しました ****\n".
                           "****************************************\n",
    SWITCHOVER_MS0032   => "\"[0]\" のコマンドの実行に失敗しました\n",
    SWITCHOVER_MS0033   => "**** [0] が Master として起動しました ****\n",

    COMMON_MS0001       => "crm_mon の実行に失敗しました\n",
    COMMON_MS0003       => "cib.xml ファイルにリソース ID \"[0]\" の \"[1]\" のパラメータが存在していません\n",
    COMMON_MS0004       => "環境設定ファイル (pg-rex_tools.conf) の [0] の指定がありません\n",
    COMMON_MS0005       => "環境設定ファイル (pg-rex_tools.conf) の [0] の設定は絶対パスで指定してください\n",
    COMMON_MS0006       => "環境設定ファイル (pg-rex_tools.conf) の STONITH の設定は enable または disable で指定してください\n",
    COMMON_MS0007       => "環境設定ファイル (pg-rex_tools.conf) の D-LAN_IPAddress の設定は2つの IP アドレスをカンマ区切りで指定してください\n",
    COMMON_MS0008       => "自身のノードの IP アドレスの取得に失敗しました\n",
    COMMON_MS0009       => "環境設定ファイル (pg-rex_tools.conf) の D-LAN_IPAddress の IP アドレスのいずれも自身のノードに存在していません\n",
    COMMON_MS0010       => "環境設定ファイル (pg-rex_tools.conf) の D-LAN_IPAddress の IP アドレスのいずれも相手のノードに存在していません\n",
    COMMON_MS0011       => "\"[0]\" のコマンドの実行に失敗しました\n",
    COMMON_MS0013       => "XLOG 位置の情報をパースできません\n",
    COMMON_MS0014       => "pg_controldata の値の取得に失敗しました\n",
    COMMON_MS0015       => "相手のノード名の取得に失敗しました\n",
    COMMON_MS0016       => "相手ノードへの ssh 接続に失敗しました\n",
    COMMON_MS0017       => "rsync コマンドの実行に失敗しました\n",
    COMMON_MS0018       => "scp コマンドの実行に失敗しました\n",
    COMMON_MS0019       => "corosync.conf に bindnetaddr の設定がありません\n",
    COMMON_MS0021       => "環境設定ファイル (pg-rex_tools.conf) の VIP_SLAVE の設定は enable または disable で指定してください\n",
    COMMON_MS0022       => "環境設定ファイル (pg-rex_tools.conf) の STONITH_ResourceID の設定は2つのリソース ID をカンマ区切りで指定してください\n",
    COMMON_MS0023       => "cib.xml \"[0]\" の読み込みに失敗しました\n",
    COMMON_MS0024       => "環境設定ファイル \"[0]\" の読み込みに失敗しました\n",
    COMMON_MS0025       => "自身のノードの corosync.conf \"[0]\" の読み込みに失敗しました\n",
    COMMON_MS0026       => "[0] ユーザで実行されているためスクリプトを終了します\n".
                           "root ユーザで再度実行してください\n",
    COMMON_MS0027       => "corosync.conf に bindnetaddr が2つ設定されていません\n".
                           "設定ミスの可能性がありますので、ご確認ください\n",
    COMMON_MS0028       => "環境設定ファイル \"[0]\" の書き込みに失敗しました\n",
    COMMON_MS0029       => "[0]@[1]'s password:",
    COMMON_MS0030       => "\nパスワードが入力されました\n",
    COMMON_MS0031       => "パスワードファイル \"[0]\" が存在しません\n",
    COMMON_MS0032       => "パスワードファイル \"[0]\" の読み込みに失敗しました\n",
    COMMON_MS0033       => "SSHパスワードが不正です\n",
    COMMON_MS0034       => "環境設定ファイル (pg-rex_tools.conf) の [0] の設定は、\n".
                           "manual、passfile、nopass のいずれかを指定してください\n",
    COMMON_MS0035       => "パスワードファイル \"[0]\" の権限が 600 ではありません\n",
    COMMON_MS0036       => "指定された PGPATH ([0]) に PostgreSQL コマンドが存在しません\n".
                           "環境設定ファイル (pg-rex_tools.conf) の PGPATH を環境にあわせて設定してください\n",
    COMMON_MS0037       => "PostgreSQL [0] には対応していません\n".
                           "PostgreSQL 9.4 または 9.5 を使用してください\n",
    COMMON_MS0038       => "Pacemaker [0] には対応していません\n".
                           "Pacemaker 1.1 を使用してください\n",
    COMMON_MS0039       => "[0] で bindnetaddr ([1]) に対応するネットワークインタフェースが見つかりませんでした\n",
    COMMON_MS0040       => "[0] で bindnetaddr ([1]) に属する IP アドレスの取得に失敗しました\n",
    COMMON_MS0041       => "相手ノードの corosync.conf \"[0]\" の読み込みに失敗しました\n",
    COMMON_MS0042       => "自身のノードで ifcheckd が停止しています\n",
    COMMON_MS0043       => "相手のノードで ifcheckd が停止しています\n",
    COMMON_MS0044       => "アーカイブディレクトリの状態を確認できませんでした: [0]\n",
    COMMON_MS0045       => "バックアップラベルファイルの一行目のフォーマットが正しくありません: [0]\n",
    COMMON_MS0046       => "DBクラスタの状態確認に失敗しました。: [0]\n",
    COMMON_MS0047       => "DBクラスタにアクセス中のプロセスが存在します。\n[0]",
    COMMON_MS0048       => "ロックファイル([0])の作成に失敗しました。: [1]\n",
    COMMON_MS0049       => "自身のノードで [0] が稼働しています。起動処理を中止します。\n",
    COMMON_MS0050       => "ロックファイル([0])の作成に失敗しました。\n",
    COMMON_MS0051       => "ロックファイル([0])の削除に失敗しました。: [1]\n",
};

1;
