/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.phosphoresce.commons.mail.MailAddressContainer;
import org.phosphoresce.commons.mail.MailConfiguration;
import org.phosphoresce.commons.mail.MailContent;
import org.phosphoresce.commons.mail.MailDeclareInterface;
import org.phosphoresce.commons.mail.exception.MailIOException;
import org.phosphoresce.commons.mail.exception.MailMessageException;
import org.phosphoresce.commons.mail.mail.MailSafeAccesserUtil;
import org.phosphoresce.commons.util.StringUtil;

public final class MailMessage
implements MailDeclareInterface {
    private Message message;

    MailMessage(Message message) {
        this.message = message;
    }

    public MailMessage(MailConfiguration configuration, MailAddressContainer container, MailContent content, Date date) throws MailMessageException {
        try {
            this.message = new MimeMessage(configuration.getSession());
            MimeMessage mimeMessage = (MimeMessage)this.message;
            mimeMessage.addFrom(container.getFromAddresses());
            mimeMessage.setReplyTo(container.getReplyAddresses());
            mimeMessage.addRecipients(Message.RecipientType.TO, container.getRecipientToAddresses());
            mimeMessage.addRecipients(Message.RecipientType.CC, container.getRecipientCcAddresses());
            mimeMessage.addRecipients(Message.RecipientType.BCC, container.getRecipientBccAddresses());
            mimeMessage.setSubject(content.getSubject(), content.getSubjectCharset());
            mimeMessage.setContent(content.createMultipart());
            mimeMessage.setSentDate(date);
        }
        catch (Exception e) {
            throw new MailMessageException("\u30e1\u30c3\u30bb\u30fc\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public MailMessage(File file) throws MailMessageException {
        try {
            FileInputStream is = new FileInputStream(file);
            this.message = new MimeMessage(null, (InputStream)is);
            is.close();
        }
        catch (Exception e) {
            throw new MailMessageException("\u30e1\u30c3\u30bb\u30fc\u30b8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    Message getMessage() {
        return this.message;
    }

    public String getMessageId() throws MailMessageException {
        try {
            return this.message instanceof MimeMessage ? ((MimeMessage)this.message).getMessageID() : "";
        }
        catch (Exception e) {
            throw new MailMessageException("\u30e1\u30c3\u30bb\u30fc\u30b8ID\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public String getId() throws MailMessageException {
        try {
            StringBuffer buffer = new StringBuffer();
            if (this.message.getSentDate() != null) {
                buffer.append(new SimpleDateFormat("yyyyMMdd24HHmmssSSS").format(this.message.getSentDate()));
            } else {
                buffer.append("00000000000000000");
            }
            buffer.append("_");
            if (this.message instanceof MimeMessage) {
                buffer.append(StringUtil.renderMD5Hash((String)((MimeMessage)this.message).getMessageID()));
            } else {
                buffer.append(StringUtil.renderMD5Hash((String)this.message.getSubject()));
            }
            return buffer.toString();
        }
        catch (Exception e) {
            throw new MailMessageException("\u30e1\u30fc\u30eb\u30e1\u30c3\u30bb\u30fc\u30b8\u306eID\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public Date getSendDate() throws MailMessageException {
        try {
            return this.message.getSentDate();
        }
        catch (Exception e) {
            throw new MailMessageException("\u9001\u4fe1\u65e5\u4ed8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public Date getReceivedDate() throws MailMessageException {
        try {
            return this.message.getReceivedDate();
        }
        catch (Exception e) {
            throw new MailMessageException("\u53d7\u4fe1\u65e5\u4ed8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public MailAddressContainer getRecipientsContainer() throws MailMessageException {
        try {
            MailAddressContainer container = new MailAddressContainer();
            container.addFrom(MailSafeAccesserUtil.getForm(this.message));
            container.addReply(MailSafeAccesserUtil.getReplyTo(this.message));
            container.addRecipientTo(MailSafeAccesserUtil.getRecipients(this.message, Message.RecipientType.TO));
            container.addRecipientCc(MailSafeAccesserUtil.getRecipients(this.message, Message.RecipientType.CC));
            container.addRecipientBcc(MailSafeAccesserUtil.getRecipients(this.message, Message.RecipientType.BCC));
            return container;
        }
        catch (Exception e) {
            throw new MailMessageException("\u9001\u4fe1\u5148\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public MailContent getMailContent() throws MailMessageException {
        return MailContent.createMailContent(this.message);
    }

    public void save(File file) throws MailIOException {
        try {
            File target = file.isDirectory() ? new File((file.getAbsolutePath().endsWith(File.separator) ? file.getAbsolutePath() : file.getAbsolutePath() + File.separator) + StringUtil.escapeFilename((String)this.getMailContent().getSubject(), (String)"_") + ".eml") : file;
            this.message.writeTo((OutputStream)new FileOutputStream(target));
        }
        catch (Exception e) {
            throw new MailIOException("\u30e1\u30fc\u30eb\u30e1\u30c3\u30bb\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public void save(String path) throws MailIOException {
        this.save(new File(path));
    }
}

