package org.phosphoresce.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

/**
 * IuWFNgɑ΂鑀s\bh񋟂NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2005/07/02	Kitagawa		VK쐬
 * 2007/09/24	Kitagawa		IuWFNgt@Co̓\bhǉ
 *-->
 */
public final class ObjectUtil {

	/**
	 * RXgN^<br>
	 */
	private ObjectUtil() {
		//
	}

	/**
	 * VACYC^tF[XĂIuWFNg̃fB[vRs[s܂B<br>
	 * @param object fB[vRs[ΏۃIuWFNg
	 * @return fB[vRs[ꂽIuWFNg
	 * @throws IOException ɃfB[vRs[sȂꍇɔ܂
	 * @throws ClassNotFoundException VACYꂽoCgz񂩂IuWFNgɕAłȂꍇɔ܂
	 */
	public static Serializable deepCopy(Serializable object) throws IOException, ClassNotFoundException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos = new ObjectOutputStream(baos);

		oos.writeObject(object);
		oos.flush();

		ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
		ObjectInputStream ois = new ObjectInputStream(bais);

		Serializable copyedObject = (Serializable) ois.readObject();

		oos.close();
		ois.close();

		return copyedObject;
	}

	/**
	 * w肳ꂽSerializableIuWFNgOutputStreamIuWFNgɏo͂܂B<br>
	 * @param object SerializableIuWFNg
	 * @param stream OutputStreamIuWFNg
	 * @throws IOException ɏo͂sȂꍇɔ
	 */
	public static void saveSerializableObject(Serializable object, OutputStream stream) throws IOException {
		ObjectOutputStream oos = new ObjectOutputStream(stream);
		oos.writeObject(object);
		oos.flush();
		oos.close();
	}

	/**
	 * w肳ꂽSerializableIuWFNgFileIuWFNgɏo͂܂B<br>
	 * @param object SerializableIuWFNg
	 * @param file FileIuWFNg
	 * @throws IOException ɏo͂sȂꍇɔ
	 */
	public static void saveSerializableObject(Serializable object, File file) throws IOException {
		FileOutputStream stream = new FileOutputStream(file);
		saveSerializableObject(object, stream);
		stream.close();
	}

	/**
	 * w肳ꂽSerializableIuWFNgt@Cɏo͂܂B<br>
	 * @param object SerializableIuWFNg
	 * @param filename t@C
	 * @throws IOException ɏo͂sȂꍇɔ
	 */
	public static void saveSerializableObject(Serializable object, String filename) throws IOException {
		saveSerializableObject(object, new File(filename));
	}

	/**
	 * w肳ꂽInputStreamIuWFNgIuWFNgǂݍ݂܂B<br>
	 * @param stream InputStreamIuWFNg
	 * @return ǂݍ񂾃IuWFNg
	 * @throws IOException ɓǂݍ߂Ȃꍇɔ
	 * @throws ClassNotFoundException ǂݍ񂾃IuWFNg̃NXȂꍇɔ
	 */
	public static Object loadSerializableObject(InputStream stream) throws IOException, ClassNotFoundException {
		ObjectInputStream ois = new ObjectInputStream(stream);
		Object object = ois.readObject();
		ois.close();
		return object;
	}

	/**
	 * w肳ꂽFileIuWFNgIuWFNgǂݍ݂܂B<br>
	 * @param file FileIuWFNg
	 * @return ǂݍ񂾃IuWFNg
	 * @throws IOException ɓǂݍ߂Ȃꍇɔ
	 * @throws ClassNotFoundException ǂݍ񂾃IuWFNg̃NXȂꍇɔ
	 */
	public static Object loadSerializableObject(File file) throws IOException, ClassNotFoundException {
		FileInputStream stream = new FileInputStream(file);
		Object object = loadSerializableObject(stream);
		stream.close();
		return object;
	}

	/**
	 * w肳ꂽt@CIuWFNgǂݍ݂܂B<br>
	 * @param filename t@C
	 * @return ǂݍ񂾃IuWFNg
	 * @throws IOException ɓǂݍ߂Ȃꍇɔ
	 * @throws ClassNotFoundException ǂݍ񂾃IuWFNg̃NXȂꍇɔ
	 */
	public static Object loadSerializableObject(String filename) throws IOException, ClassNotFoundException {
		return loadSerializableObject(new File(filename));
	}
}
