package org.phosphoresce.commons.eswing;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

import org.phosphoresce.commons.eswing.core.ESwingComponent;

/**
 * JDialoggNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class EDialog extends JDialog implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		getContentPane().setLayout(null);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		setResizable(false);

		getRootPane().getInputMap().put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "dispose");
		getRootPane().getActionMap().put("dispose", new AbstractAction() {
			public void actionPerformed(ActionEvent e) {
				dispose();
			}
		});
	}

	/**
	 * RXgN^<br>
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog()
	 */
	public EDialog() throws HeadlessException {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eDialogIuWFNg
	 * @param modal [_tO
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Dialog, boolean)
	 */
	public EDialog(Dialog owner, boolean modal) throws HeadlessException {
		super(owner, modal);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eDialogIuWFNg
	 * @param title _CAO^Cg
	 * @param modal [_tO
	 * @param gc GraphicsConfigurationIuWFNg
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Dialog, String, boolean, GraphicsConfiguration)
	 */
	public EDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
		super(owner, title, modal, gc);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eDialogIuWFNg
	 * @param title _CAO^Cg
	 * @param modal [_tO
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Dialog, String, boolean)
	 */
	public EDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
		super(owner, title, modal);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eDialogIuWFNg
	 * @param title _CAO^Cg
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Dialog, String)
	 */
	public EDialog(Dialog owner, String title) throws HeadlessException {
		super(owner, title);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eDialogIuWFNg
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Dialog)
	 */
	public EDialog(Dialog owner) throws HeadlessException {
		super(owner);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eFrameIuWFNg
	 * @param modal [_tO
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Frame, boolean)
	 */
	public EDialog(Frame owner, boolean modal) throws HeadlessException {
		super(owner, modal);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eFrameIuWFNg
	 * @param title _CAO^Cg
	 * @param modal [_tO
	 * @param gc GraphicsConfigurationIuWFNg
	 * @see JDialog#JDialog(Frame, String, boolean, GraphicsConfiguration)
	 */
	public EDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
		super(owner, title, modal, gc);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eFrameIuWFNg
	 * @param title _CAO^Cg
	 * @param modal [_tO
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Dialog, String, boolean)
	 */
	public EDialog(Frame owner, String title, boolean modal) throws HeadlessException {
		super(owner, title, modal);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eFrameIuWFNg
	 * @param title _CAO^Cg
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Frame, String)
	 */
	public EDialog(Frame owner, String title) throws HeadlessException {
		super(owner, title);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param owner eFrameIuWFNg
	 * @throws HeadlessException GraphicsEnvironment.isHeadless()trueԋpꍇɔ
	 * @see JDialog#JDialog(Frame)
	 */
	public EDialog(Frame owner) throws HeadlessException {
		super(owner);
		dressup();
	}
}
