/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.core;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.enumeration.Type;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;

public class Resource
implements Serializable {
    private CompareSession session;
    private Status status;
    private Type type;
    private File origin;
    private File destination;

    private Resource() {
    }

    public Resource(CompareSession session, Type type, Status status, File origin, File destination) {
        this.session = session;
        this.type = type;
        this.status = status;
        this.origin = origin;
        this.destination = destination;
    }

    public Resource(CompareSession session, Type type, File origin, File destination) {
        this(session, type, Status.UNSETTING, origin, destination);
    }

    public File getDestination() {
        return this.destination;
    }

    public File getOrigin() {
        return this.origin;
    }

    public Status getStatus() {
        return this.status;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        File target = null;
        target = this.status == Status.ADD ? this.destination : (this.status == Status.ADD ? this.origin : (this.status == Status.UPDATE ? this.destination : (this.status == Status.SAME ? this.origin : this.origin)));
        return target.getName();
    }

    public String getRelativePath() throws ResourceOperateException {
        try {
            CompareConfigure configure = this.session.getConfigure();
            File target = null;
            String path = "";
            if (this.status == Status.ADD) {
                target = this.destination;
                path = target.getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
            } else if (this.status == Status.ADD) {
                target = this.origin;
                path = target.getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
            } else if (this.status == Status.UPDATE) {
                target = this.destination;
                path = target.getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
            } else if (this.status == Status.SAME) {
                target = this.origin;
                path = target.getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
            } else {
                target = this.origin;
                path = target.getCanonicalPath().substring(configure.getOrigin().getCanonicalPath().length() + 1);
            }
            return path;
        }
        catch (Throwable e) {
            throw new ResourceOperateException("\u76f8\u5bfe\u30d1\u30b9\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public String[] getRelativePathArray() throws ResourceOperateException {
        String path = this.getRelativePath();
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, File.separator);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (this.type == Type.FILE) {
            list.remove(list.size() - 1);
        }
        if (this.type == Type.DIRECTORY) {
            list.remove(list.size() - 1);
        }
        return list.toArray(new String[list.size()]);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Resource other = (Resource)object;
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("Type=");
        buffer.append(this.type);
        buffer.append(",");
        buffer.append("Status=");
        buffer.append(this.status);
        buffer.append(",");
        buffer.append("Origin=");
        buffer.append(this.origin);
        buffer.append(",");
        buffer.append("Destination=");
        buffer.append(this.destination);
        buffer.append("}");
        return buffer.toString();
    }
}

