/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.core.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;
import org.phosphoresce.resourcecomp.Global;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.util.StringUtil;

public final class CompareConfigure
implements Serializable {
    private String encoding = "utf-8";
    private File origin;
    private File destination;
    private File resultWritePath;
    private File resourceWritePath;
    private Status[] targetStatus;
    private Class executerClass = Global.DEFAULT_CONTAINER_CLASS;
    private Class containerClass = Global.DEFAULT_CONTAINER_CLASS;
    private Class strategyClass = Global.DEFAULT_STRATEGY_CLASS;
    private Class filterClass = Global.DEFAULT_FILTER_CLASS;
    private Class monitorClass = Global.DEFAULT_MONITOR_CLASS;
    private Class resultWriterClass = Global.DEFAULT_RESULT_WRITER_CLASS;
    private Class resourceWriterClass = Global.DEFAULT_RESOURCE_WRITER_CLASS;

    CompareConfigure() throws IllegalConfigurationException {
        this.load();
    }

    private void load() throws IllegalConfigurationException {
        try {
            if (!new File("rcomp-config.properties").exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream("rcomp-config.properties");
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("executer");
            if (!StringUtil.isEmpty(value)) {
                this.executerClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("encoding"))) {
                this.encoding = value;
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.container"))) {
                this.containerClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.strategy"))) {
                this.strategyClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.filter"))) {
                this.filterClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.monitor"))) {
                this.monitorClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.resultWriter"))) {
                this.resultWriterClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.resultWriter"))) {
                this.resultWriterClass = Class.forName(value);
            }
            if (!StringUtil.isEmpty(value = properties.getProperty("plugin.resourceWriter"))) {
                this.resourceWriterClass = Class.forName(value);
            }
            stream.close();
        }
        catch (Throwable e) {
            throw new IllegalConfigurationException("\u6b63\u5e38\u306b\u74b0\u5883\u8a2d\u5b9a\u3092\u884c\u3046\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setDestination(String destination) {
        this.setDestination(new File(destination));
    }

    public File getOrigin() {
        return this.origin;
    }

    public void setOrigin(File origin) {
        this.origin = origin;
    }

    public void setOrigin(String origin) {
        this.setOrigin(new File(origin));
    }

    public File getResourceWritePath() {
        return this.resourceWritePath;
    }

    public void setResourceWritePath(File resourceWritePath) {
        this.resourceWritePath = resourceWritePath;
    }

    public void setResourceWritePath(String resourceWritePath) {
        this.resourceWritePath = new File(resourceWritePath);
    }

    public File getResultWritePath() {
        return this.resultWritePath;
    }

    public void setResultWritePath(File resultWritePath) {
        this.resultWritePath = resultWritePath;
    }

    public void setResultWritePath(String resultWritePath) {
        this.resultWritePath = new File(resultWritePath);
    }

    public Status[] getTargetStatus() {
        return this.targetStatus;
    }

    public void setTargetStatus(Status[] targetStatus) {
        this.targetStatus = targetStatus;
    }

    public Class getExecuterClass() {
        return this.executerClass;
    }

    public void setExecuterClass(Class executerClass) {
        this.executerClass = executerClass;
    }

    public Class getContainerClass() {
        return this.containerClass;
    }

    public void setContainerClass(Class containerClass) {
        this.containerClass = containerClass;
    }

    public Class getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(Class filterClass) {
        this.filterClass = filterClass;
    }

    public Class getMonitorClass() {
        return this.monitorClass;
    }

    public void setMonitorClass(Class monitorClass) {
        this.monitorClass = monitorClass;
    }

    public Class getResourceWriterClass() {
        return this.resourceWriterClass;
    }

    public void setResourceWriterClass(Class resourceWriterClass) {
        this.resourceWriterClass = resourceWriterClass;
    }

    public Class getResultWriterClass() {
        return this.resultWriterClass;
    }

    public void setResultWriterClass(Class resultWriterClass) {
        this.resultWriterClass = resultWriterClass;
    }

    public Class getStrategyClass() {
        return this.strategyClass;
    }

    public void setStrategyClass(Class strategyClass) {
        this.strategyClass = strategyClass;
    }
}

