/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.core.session;

import java.io.Serializable;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.exception.IllegalConfigurationException;
import org.phosphoresce.resourcecomp.plugin.container.CompareContainer;
import org.phosphoresce.resourcecomp.plugin.container.CompareContainerFactory;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilter;
import org.phosphoresce.resourcecomp.plugin.filter.CompareResourceFilterFactory;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitor;
import org.phosphoresce.resourcecomp.plugin.monitor.CompareMonitorFactory;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategy;
import org.phosphoresce.resourcecomp.plugin.strategy.CompareStrategyFactory;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriter;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriterFactory;
import org.phosphoresce.resourcecomp.plugin.writer.ResultWriter;
import org.phosphoresce.resourcecomp.plugin.writer.ResultWriterFactory;

public final class CompareSession
implements Serializable {
    private CompareConfigure configure;
    private CompareContainer container;

    public CompareConfigure getConfigure() throws IllegalConfigurationException {
        if (this.configure == null) {
            this.configure = new CompareConfigure();
        }
        return this.configure;
    }

    public CompareContainer getContainer() throws IllegalConfigurationException {
        if (this.container == null) {
            CompareContainerFactory factory = new CompareContainerFactory();
            factory.setTargetClass(this.getConfigure().getContainerClass());
            this.container = factory.create(this);
        }
        return this.container;
    }

    public CompareStrategy createCompareStrategy() throws IllegalConfigurationException {
        CompareStrategyFactory factory = new CompareStrategyFactory();
        factory.setTargetClass(this.getConfigure().getStrategyClass());
        return factory.create();
    }

    public CompareResourceFilter createCompareResourceFilter() throws IllegalConfigurationException {
        CompareResourceFilterFactory factory = new CompareResourceFilterFactory();
        factory.setTargetClass(this.getConfigure().getFilterClass());
        return factory.create();
    }

    public CompareMonitor createCompareMonitor() throws IllegalConfigurationException {
        CompareMonitorFactory factory = new CompareMonitorFactory();
        factory.setTargetClass(this.getConfigure().getMonitorClass());
        return factory.create();
    }

    public ResultWriter createResultWriter() throws IllegalConfigurationException {
        ResultWriterFactory factory = new ResultWriterFactory();
        factory.setTargetClass(this.getConfigure().getResultWriterClass());
        return factory.create(this, this.getConfigure().getTargetStatus());
    }

    public ResourceWriter createResourceWriter() throws IllegalConfigurationException {
        ResourceWriterFactory factory = new ResourceWriterFactory();
        factory.setTargetClass(this.getConfigure().getResourceWriterClass());
        return factory.create(this, this.getConfigure().getTargetStatus());
    }
}

