/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.container;

import java.io.File;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.enumeration.Type;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.IllegalEnumerationException;
import org.phosphoresce.resourcecomp.exception.ResourceOperateException;
import org.phosphoresce.resourcecomp.plugin.container.CompareAbstractContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class CompareDOMContainer
extends CompareAbstractContainer {
    private Document document;
    private Element root;
    private Transformer transformer;

    public CompareDOMContainer(CompareSession session) throws ResourceOperateException {
        super(session);
    }

    protected void init() throws ResourceOperateException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = builder.newDocument();
            this.root = this.document.createElement("resources");
            this.document.appendChild(this.root);
        }
        catch (Throwable e) {
            throw new ResourceOperateException("\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public void add(Resource resource) throws ResourceOperateException {
        Element parent = this.findDirectoryElement(resource.getRelativePathArray());
        if (resource.getType() == Type.DIRECTORY) {
            parent.appendChild(this.createDirectoryElement(resource));
        } else if (resource.getType() == Type.FILE) {
            parent.appendChild(this.createResrouceElement(resource));
        } else {
            throw new ResourceOperateException("\u4e0d\u6b63\u306a\u30ea\u30bd\u30fc\u30b9\u30bf\u30a4\u30d7\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f[" + resource.getType() + "]");
        }
    }

    public void remove(Resource resource) throws ResourceOperateException {
        Element parent = this.findDirectoryElement(resource.getRelativePathArray());
        NodeList list = parent.getChildNodes();
        for (int i = 0; i <= list.getLength() - 1; ++i) {
            Element element = (Element)list.item(i);
            if (!"resource".equals(element.getTagName()) || !resource.getName().equals(element.getAttribute("name"))) continue;
            parent.removeChild(element);
            break;
        }
    }

    public void removeAll(Collection collection) throws ResourceOperateException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Resource)) continue;
            Resource resource = (Resource)object;
            this.remove(resource);
        }
    }

    public boolean contains(Resource resource) throws ResourceOperateException {
        Element parent = this.findDirectoryElement(resource.getRelativePathArray());
        NodeList list = parent.getChildNodes();
        for (int i = 0; i <= list.getLength() - 1; ++i) {
            Element element = (Element)list.item(i);
            if ("resource".equals(element.getTagName()) && resource.getName().equals(element.getAttribute("name"))) {
                return true;
            }
            if (!"directory".equals(element.getTagName()) || !resource.getName().equals(element.getAttribute("name"))) continue;
            return true;
        }
        return false;
    }

    public List getResourceList() throws IllegalEnumerationException {
        return this.getResourceList(this.root, null);
    }

    public List getResourceList(Status[] status) throws IllegalEnumerationException {
        return this.getResourceList(this.root, status);
    }

    private List getResourceList(Element parent, Status[] status) throws IllegalEnumerationException {
        LinkedList<Resource> list = new LinkedList<Resource>();
        NodeList nodes = parent.getChildNodes();
        block0: for (int i = 0; i <= nodes.getLength() - 1; ++i) {
            Element element = (Element)nodes.item(i);
            if ("resource".equals(element.getTagName())) {
                Resource resource = new Resource(this.session, Type.FILE, Status.valueOf(element.getAttribute("status")), new File(element.getAttribute("origin")), new File(element.getAttribute("destination")));
                if (status == null) {
                    list.add(resource);
                    continue;
                }
                for (int j = 0; j <= status.length - 1; ++j) {
                    if (status[j] != resource.getStatus()) continue;
                    list.add(resource);
                    continue block0;
                }
                continue;
            }
            if (!"directory".equals(element.getTagName())) continue;
            list.addAll(this.getResourceList(element, status));
        }
        return list;
    }

    private Element findDirectoryElement(String[] paths) {
        Element parent = this.root;
        for (int i = 0; i <= paths.length - 1; ++i) {
            String path = paths[i];
            parent = this.findDirectoryElement(parent, path);
        }
        return parent;
    }

    private Element findDirectoryElement(Element parent, String path) {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i <= list.getLength() - 1; ++i) {
            Element element;
            if (!(list.item(i) instanceof Element) || !"directory".equals((element = (Element)list.item(i)).getTagName()) || !path.equals(element.getAttribute("name"))) continue;
            return element;
        }
        return (Element)parent.appendChild(this.createDirectoryElement(path));
    }

    private Element createDirectoryElement(String path) {
        Element element = this.document.createElement("directory");
        element.setAttribute("name", path);
        return element;
    }

    private Element createDirectoryElement(Resource resource) {
        return this.createDirectoryElement(resource.getName());
    }

    private Element createResrouceElement(Resource resource) throws ResourceOperateException {
        try {
            Status status = resource.getStatus();
            String name = "";
            name = status == Status.ADD ? resource.getDestination().getName() : (status == Status.DELETE ? resource.getOrigin().getName() : (status == Status.UPDATE ? resource.getOrigin().getName() : (status == Status.SAME ? resource.getOrigin().getName() : resource.getOrigin().getName())));
            Element element = this.document.createElement("resource");
            element.setAttribute("name", name);
            element.setAttribute("status", status.toString());
            element.setAttribute("origin", resource.getOrigin() == null ? "" : resource.getOrigin().getCanonicalPath());
            element.setAttribute("destination", resource.getDestination() == null ? "" : resource.getDestination().getCanonicalPath());
            return element;
        }
        catch (Throwable e) {
            throw new ResourceOperateException("\u30ea\u30bd\u30fc\u30b9\u30a2\u30af\u30bb\u30b9\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    public String toString() {
        try {
            CompareConfigure configure = this.session.getConfigure();
            StringWriter writer = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("/org/phosphoresce/resourcecomp/resource/xmlxslt.xsl")));
            transformer.setOutputProperty("encoding", configure.getEncoding());
            transformer.transform(new DOMSource(this.document), new StreamResult(writer));
            return writer.toString();
        }
        catch (Throwable e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(e.getClass().getName());
            buffer.append(": ");
            buffer.append(e.getLocalizedMessage());
            buffer.append("\n");
            StackTraceElement[] elements = e.getStackTrace();
            for (int i = 0; i <= elements.length - 1; ++i) {
                StackTraceElement element = elements[i];
                buffer.append("\t");
                buffer.append("at ");
                buffer.append(element.getClassName());
                buffer.append(".");
                buffer.append(element.getMethodName());
                buffer.append("(");
                buffer.append(element.getFileName());
                buffer.append(":");
                buffer.append(element.getLineNumber());
                buffer.append(")");
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

