/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.writer;

import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.exception.ExceptionHandler;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceWriter;

public abstract class ResourceAbstractWriter
implements ResourceWriter {
    protected CompareSession session;
    protected Status[] status;
    protected long size = 0L;
    protected long count = 0L;

    private ResourceAbstractWriter() {
    }

    public ResourceAbstractWriter(CompareSession session, Status[] status) {
        this.session = session;
        this.status = status;
    }

    public ResourceAbstractWriter(CompareSession session) {
        this.session = session;
        this.status = null;
    }

    public final void run() {
        try {
            this.write();
        }
        catch (CompareException e) {
            new ExceptionHandler(e).execute();
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getCount() {
        return this.count;
    }

    public abstract void write() throws CompareException;
}

