/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.resourcecomp.plugin.writer;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.phosphoresce.resourcecomp.core.Resource;
import org.phosphoresce.resourcecomp.core.enumeration.Status;
import org.phosphoresce.resourcecomp.core.session.CompareConfigure;
import org.phosphoresce.resourcecomp.core.session.CompareSession;
import org.phosphoresce.resourcecomp.exception.CompareException;
import org.phosphoresce.resourcecomp.plugin.writer.ResourceAbstractWriter;
import org.phosphoresce.resourcecomp.util.FileUtil;

public class ResourceFileWriter
extends ResourceAbstractWriter {
    public ResourceFileWriter(CompareSession session, Status[] status) {
        super(session, status);
    }

    public ResourceFileWriter(CompareSession session) {
        super(session);
    }

    public void write() throws CompareException {
        try {
            CompareConfigure configure = this.session.getConfigure();
            FileUtil.getFilePath(configure.getResourceWritePath()).mkdirs();
            String writePath = configure.getResourceWritePath().getCanonicalPath();
            writePath = writePath.endsWith(File.separator) ? writePath : writePath + File.separator;
            List targets = this.session.getContainer().getResourceList(this.status);
            this.size = targets.size();
            this.count = 0L;
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                ++this.count;
                Status[] status = configure.getTargetStatus();
                boolean validate = false;
                for (int i = 0; i <= status.length - 1; ++i) {
                    if (resource.getStatus() == Status.DELETE) {
                        validate = false;
                        break;
                    }
                    if (resource.getStatus() != status[i]) continue;
                    validate = true;
                    break;
                }
                if (!validate) continue;
                File file = resource.getDestination();
                String path = writePath + file.getCanonicalPath().substring(configure.getDestination().getCanonicalPath().length() + 1);
                String name = file.getName();
                File directory = new File(path.substring(0, path.length() - name.length()));
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                FileUtil.copy(file, new File(path));
            }
        }
        catch (Throwable e) {
            throw new CompareException("\u30ea\u30bd\u30fc\u30b9\u51fa\u529b\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

