<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * File Name Utilities
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: FilenameUtils.php 185 2008-01-31 16:21:02Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::IO;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::StringUtils;
* */

/**
 * FilenameUtils
 *
 *
 * @category   PHP
 * @package    Commons.IO
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_IO_FilenameUtils extends Commons_Lang_Object {

	private static $_instance = null;
	
	
	public function Commons_IO_FilenameUtils() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	public static function isAbsolute($path) {
		// including relative path.
		if (Commons_Lang_StringUtils::strpos($path, '/../') !== false
			|| Commons_Lang_StringUtils::strpos($path, '\..\\') !== false) {
			return false;
		}
		// UNIX
		elseif (Commons_Lang_StringUtils::startsWith($path, '/')) {
			return true;
		}
		// Windows
		elseif (preg_match('/^[a-z]:\\\\/i', $path)) {
			return true;
		}
		else {
			return false;
		}
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>