<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * CompareTo Builder
 * (based on org.apache.commons.lang.builder.CompareToBuilder)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: CompareToBuilder.php 80 2008-01-02 12:54:29Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang::Builder;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Util/Comparator.php';
/*
use Commons::Lang::Object;
use Commons::Util::Comparator;
*/

/**
 * CompareToBuilder
 *
 *
 * @category   PHP
 * @package    Commons.Lang.Builder
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_Builder_CompareToBuilder extends Commons_Lang_Object {
//class CompareToBuilder extends Object {
	
	/**
	 * Comparison
	 *
	 * @var int
	 */
	private $_comparison;


	/**
	 * Constructor
	 */
	public function Commons_Lang_Builder_CompareToBuilder() {
		parent::__construct();
		$this->_comparison = 0;
	}
	
	
	/**
	 * Appends super class compareTo value
	 *
	 * @param int $superCompareTo
	 * @return Commons_Lang_Builder_CompareToBuilder This current object
	 */
	public function appendSuper($superCompareTo) {
		if ($this->_comparison !== 0) {
			return $this;
		}
		$this->_comparison = $superCompareTo;
		return $this;
	}
	
	
	/**
	 * Appends to the builder the comparison of two variables.
	 *
	 * @param mixed $lhs the left hand side parameter
	 * @param mixed $rhs the right hand side parameter
	 * @param Commons_Util_Comparator $comparator
	 * @return self this builder
	 */
	public function append($lhs, $rhs, Commons_Util_Comparator $comparator = null) {
		if ($this->_comparison !== 0) {
			return $this;
		}
		// non-object's equality test, object's identity test
		if ($lhs === $rhs) {
			return $this;
		}
		if (is_null($lhs)) {
			$this->_comparison = -1;
			return $this;
		}
		if (is_null($rhs)) {
			$this->_comparison = +1;
			return $this;
		}
		
		if (is_array($lhs)) {
			// use PHP comparative operator's rule.
			$this->_comparison = (($lhs < $rhs) ? -1 : (($lhs > $rhs) ? 1 : 0));			
		}
		elseif (is_object($lhs)) {
			if (is_null($comparator)) {
				$this->_comparison = $lhs->compareTo($rhs);
			}
			else {
				$this->_comparison = $comparator->compare($lhs, $rhs);
			}
		}
		else {
			// use PHP comparative operator's rule.
			$this->_comparison = (($lhs < $rhs) ? -1 : (($lhs > $rhs) ? 1 : 0));			
		}
		
		return $this;
	}
	
	
	/**
	 * To comparison
	 *
	 * @return int
	 */
	public function toComparison() {
		return $this->_comparison;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>