<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Log4PHP Logger
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: Log4PHPLogger.php 368 2008-09-06 05:47:11Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging::Impl;

require_once 'log4php/LoggerManager.php';
require_once 'log4php/LoggerLevel.php';

require_once 'Commons/Lang/Object.php';
require_once 'Commons/IO/Serializable.php';
require_once 'Commons/Logging/Log.php';
/*
use Commons::Lang::Object;
use Commons::IO::Serializable;
use Commons::Logging::Log;
*/

/**
 * Log4PHPLogger
 *
 *
 * @category   PHP
 * @package    Commons.Logging.Impl
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Logging_Impl_Log4PHPLogger extends Logger
	implements Commons_Logging_Log, Commons_IO_Serializable {

	/**
	 * The fully qualified name of the Log4JLogger class.
	 * @var string
	 */
	private static $_FQCN = __CLASS__;

	/**
	 * Log to this logger
	 * @var 
	 */
	private $_logger = null;
	
	/**
	 * Logger name
	 * @var string
	 */
	private $_name = null;

	
	/**
	 * Constructor
	 *
	 * @param string|Logger $p1 logger name or Logger object.
	 */
	public function Commons_Logging_Impl_Log4PHPLogger($p1) {
		if (is_string($p1)) {
			$this->_name = $p1;
			$this->_logger = $this->getLogger();
		}
		elseif ($p1 instanceof Logger) {
			$this->_name = $p1->getName();
			$this->_logger = $p1;
		}
	}
	
	
	public function __destruct() {
	}

	
	/**
	 * Gets Log4PHP Logger instance.
	 *
	 * @return Logger
	 */
	public function getLogger() {
		if (is_null($this->_logger)) {
			$this->_logger = LoggerManager::getLogger($this->_name);
		}
		return $this->_logger;
	}
	
	
	/**
	 * Builds the message string.
	 *
	 * @param mixed $message message object.
	 * @param Exception $e exception object.
	 * @return string message.
	 */
	protected function buildMessage($message, $e) {
		if (is_null($message)) {
			$message = '<null>';
		}
		
		if (!is_null($e)) {
			return (string)$message . ' <' . $e->__toString() . '>';
		}
		else {
			return (string)$message;
		}
	}
	

	/**
	 * @since 1.0.3
	 */
	public function pushNDC($message) {
		LoggerNDC::push($message);
	}
	
	
	/**
	 * @since 1.0.3
	 */
	public function popNDC() {
		LoggerNDC::pop();
	}
	
	
	/**
	 * @since 1.0.3
	 */
	public function removeNDC() {
		LoggerNDC::remove();
	}
	
	
	/**
	 * @since 1.0.3
	 */
	public function clearNDC() {
		LoggerNDC::clear();
	}
	
	
	/**
	 * @since 1.0.3
	 */
	public function putMDC($key, $value) {
		LoggerMDC::put($key, $value);
	}
	
	
	/**
	 * @since 1.0.3
	 */
	public function removeMDC($key) {
		LoggerMDC::remove($key);
	}
	
	
	public function trace($message, $e = null) {
		$this->getLogger()->log(
			LoggerLevel::getLevelDebug(), $this->buildMessage($message, $e));
	}
	
	
	public function debug($message, $e = null) {
		$this->getLogger()->log(
			LoggerLevel::getLevelDebug(), $this->buildMessage($message, $e));
	}
	
	
	public function info($message, $e = null) {
		$this->getLogger()->log(
			LoggerLevel::getLevelInfo(), $this->buildMessage($message, $e));
	}
	
	
	public function warn($message, $e = null) {
		$this->getLogger()->log(
			LoggerLevel::getLevelWarn(), $this->buildMessage($message, $e));
	}
	
	
	public function error($message, $e = null) {
		$this->getLogger()->log(
			LoggerLevel::getLevelError(), $this->buildMessage($message, $e));
	}
	
	
	public function fatal($message, $e = null) {
		$this->getLogger()->log(
			LoggerLevel::getLevelFatal(), $this->buildMessage($message, $e));
	}
	
	
	public function isTraceEnabled() {
		return $this->getLogger()->isDebugEnabled();
	}
	
	
	public function isDebugEnabled() {
		return $this->getLogger()->isDebugEnabled();
	}

	
	public function isInfoEnabled() {
		return $this->getLogger()->isInfoEnabled();
	}
	
	
	public function isWarnEnabled() {
		return $this->getLogger()->isEnabledFor(LoggerLevel::getLevelWarn());
	}
	
	
	public function isErrorEnabled() {
		return $this->getLogger()->isEnabledFor(LoggerLevel::getLevelError());
	}
	
	
	public function isFatalEnabled() {
		return $this->getLogger()->isEnabledFor(LoggerLevel::getLevelFatal());
	}
	
	
	public function shutdown() {
		LoggerManager::shutdown();
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>