<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Default Object Table
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: DefaultObjectTable.php 328 2008-08-03 05:39:05Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.2
 */

//namespace Commons::Test::DataSet;

require_once 'PHPUnit/Extensions/Database/DataSet/AbstractTable.php';
require_once 'PHPUnit/Extensions/Database/DataSet/DefaultTableMetaData.php';

/**
 * DefaultObjectTable
 *
 *
 * @category   PHP
 * @package    Commons.Test.DataSet
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.2
 */
class Commons_Test_DataSet_DefaultObjectTable
	extends PHPUnit_Extensions_Database_DataSet_AbstractTable {
	
	private $originalCollection = null;
	
	
	/**
	 * Constructor
	 *
	 * @param array<bean/map> $collection array of bean or hash map.
	 * @param string $tableName
	 */
	public function Commons_Test_DataSet_DefaultObjectTable($collection, $tableName) {
		$this->originalCollection = $collection;
		
		$columns = array();
		$data = array();
		
		if (is_null($collection) || count($collection) === 0) {
			// do nothing.
		}
		// map (array)
		elseif (is_array($collection[0])) {
			$columns = array_keys($collection[0]);
			$data = $collection;
		}
		// bean
		else {
			$columns = $this->getAccessiblePropNames($collection[0]);
			foreach ($collection as $item) {
				$data[] = $this->bean2map($item);
			}
		}
		
		$this->setTableMetaData(
			new PHPUnit_Extensions_Database_DataSet_DefaultTableMetaData($tableName, $columns));
		$this->data = $data;
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Gets the original collection.
	 *
	 * @return array
	 */
	public function getOriginalCollection() {
		return $this->originalCollection;
	}
	
	
	/**
	 * Returns the map list (array(array('key' => 'value', ...), ...)).
	 *
	 * @return array
	 */
	public function toMapList() {
		return $this->data;
	}
	
	
	/**
	 * Transforms bean to hash map (PHP array)
	 *
	 * @param object $bean
	 * @return array map
	 */
	protected function bean2map($bean) {
		$accessiblePropNames = $this->getAccessiblePropNames($bean);
		
		$map = array();
		foreach ($accessiblePropNames as $accessiblePropName) {
			$getter = 'get' . $accessiblePropName;
			$map[$accessiblePropName] = $bean->$getter();
		}
		
		return $map;
	}
	
	
	/**
	 * Get the accessible properties' names.
	 *
	 * @param object $bean
	 * @return array names
	 */
	protected function getAccessiblePropNames($bean) {
		$getterPrefix = 'get';
		$getterPrefixLength = strlen($getterPrefix);
		
		$ref = new ReflectionObject($bean);
		
		$accessiblePropNames = array();
		$methods = $ref->getMethods();
		foreach ($methods as $method) {
			$methodName = $method->getName();
			if (Commons_Lang_StringUtils::startsWith($methodName, $getterPrefix)
				&& $method->isPublic()
				&& !$method->isStatic()) {
				
				$propName = substr($methodName, $getterPrefixLength);
				if ($propName) {
					$propName[0] = strtolower($propName[0]);
					$accessiblePropNames[] = $propName;
				}
			}
		}
		
		return $accessiblePropNames;
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>