<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Iterator Interface
 * (based on java.util.Iterator)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: Iterator.php 84 2008-01-03 06:13:52Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Util;


/**
 * Iterator
 *
 *
 * @category   PHP
 * @package    Commons.Util
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
interface Commons_Util_Iterator {

	/**
	 * Tests whether the next element of the collection remains or not
	 *
	 * @return bool true if there is the next element.
	 */
	public function hasNext();
	
	/**
	 * Gets the next element.
	 * 
	 * @return object the next element in the collection
	 * @throws NoSuchElementException if there are no more elements
	 */
	public function next();
	
	/**
	 * Removes the last element returned by next() from the underlying collection
	 * (OPTIONAL operation). This method can be called only ONCE after each
	 * call to next(). It does not affect what will be returned
	 * by subsequent calls to next().
	 *
	 * @throws Commons_Lang_IllegalStateException if next() has not been called yet
	 *         or remove() has already been called since the last call to next.
	 * @throws Commons_Lang_UnsupportedOperationException if this Iterator does not
	 *         support the remove() operation.
	 */
	public function remove();

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>