<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Pattern Syntax Exception
 * (based on java.util.regex.PatternSyntaxException)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PatternSyntaxException.php 384 2008-09-18 12:35:44Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.3
 */

//namespace Commons::Util::Regex;

require_once 'Commons/Lang/IllegalArgumentException.php';
/*
use Commons::Lang::IllegalArgumentException;
*/

/**
 * PatternSyntaxException
 *
 *
 * @category   PHP
 * @package    Commons.Util.Regex
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.3
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.3
 */
class Commons_Util_Regex_PatternSyntaxException extends Commons_Lang_IllegalArgumentException {
	
	/**
	 * A description of the error
	 *
	 * @var string
	 */
	private $desc = '';
	
	/**
	 * The erroneous pattern
	 *
	 * @var string
	 */
	private $pattern = '';
	
	
	/**
	 * Constructor
	 * 
	 * Supported signatures:
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, int $code);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, Exception $cause);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, Exception $cause, int $code);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, PEAR_Error $cause);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, PEAR_Error $cause, int $code);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, array $causes);
	 *  - Commons_Util_Regex_PatternSyntaxException(string $desc, string $regex, array $causes, int $code);
	 * @param string exception message
	 * @param string pattern
	 * @param int|Exception|PEAR_Error|array|null exception cause
	 * @param int|null exception code or null
	 */
	public function Commons_Util_Regex_PatternSyntaxException(
		$desc, $regex, $p3 = null, $p4 = null) {
			
		$this->desc = $desc;
		$this->pattern = $regex;
		$message = $this->desc . ': ' . $this->pattern;
		parent::__construct($message, $p3, $p4);
	}
	
	
	public function getDesc() {
		return $this->desc;
	}
	
	
	public function getPattern() {
		return $this->pattern;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>