/*
 * Decompiled with CFR 0.152.
 */
package citbach1_1;

import citbach1_1.ConstraintHandler;
import citbach1_1.Error;
import citbach1_1.Generator;
import citbach1_1.GeneratorAll;
import citbach1_1.GeneratorFactor;
import citbach1_1.InputFileData;
import citbach1_1.Inputer;
import citbach1_1.OutOfMaxNumOfTestcasesException;
import citbach1_1.Outputer;
import citbach1_1.ParameterModel;
import citbach1_1.Testcase;
import java.util.List;

public class Main {
    static int randomSeed = -1;
    static String modelFile;
    static int numOfIterations;
    static String seedFile;
    static String outputFile;
    static int strength;
    static final int MAX_LEVEL = 63;
    static final int MAX_ITERATIONS = 100000;
    static final int MAX_STRENGTH = 5;
    static final int Max_RandomSeed = 65535;
    static boolean debugMode;

    static {
        numOfIterations = 1;
        strength = 2;
        debugMode = false;
    }

    public static void main(String[] args) {
        try {
            String errorMessage = Main.processCommandArgument(args);
            Error.setOutputFile(outputFile);
            if (errorMessage != null) {
                Error.printError(errorMessage);
            }
            InputFileData inputfiledata = Inputer.readModel(modelFile);
            ConstraintHandler conhndl = new ConstraintHandler(inputfiledata.parameterList, inputfiledata.constraintList);
            List<Testcase> seed = Inputer.readSeed(seedFile, inputfiledata);
            List<Testcase> testSet = null;
            if (strength == -1) {
                try {
                    testSet = GeneratorAll.generate(new ParameterModel(inputfiledata.parameterList), conhndl);
                }
                catch (OutOfMaxNumOfTestcasesException e) {
                    Error.printError("\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u6570\u304c\u4e0a\u965065532\u3092\u8d85\u3048\u307e\u3057\u305f");
                }
                new Outputer(outputFile).outputResult(testSet, inputfiledata, modelFile, outputFile);
            } else {
                Generator generator = GeneratorFactor.newGenerator(new ParameterModel(inputfiledata.parameterList), inputfiledata.groupList, conhndl, seed, randomSeed, strength);
                try {
                    testSet = generator.generate();
                }
                catch (OutOfMaxNumOfTestcasesException e) {
                    testSet = null;
                }
                if (debugMode) {
                    System.err.println("random seed: " + randomSeed);
                }
                int i = 2;
                while (i < numOfIterations) {
                    int nextRandomSeed = (int)Math.floor(Math.random() * 65536.0);
                    generator = GeneratorFactor.newGenerator(new ParameterModel(inputfiledata.parameterList), inputfiledata.groupList, conhndl, seed, nextRandomSeed, strength);
                    if (debugMode) {
                        System.err.println("random seed: " + nextRandomSeed);
                    }
                    List<Testcase> nextTestSet = null;
                    try {
                        nextTestSet = generator.generate();
                    }
                    catch (OutOfMaxNumOfTestcasesException e) {
                        nextTestSet = null;
                    }
                    if (testSet != null && nextTestSet != null) {
                        if (nextTestSet.size() < testSet.size()) {
                            testSet = nextTestSet;
                            randomSeed = nextRandomSeed;
                        }
                    } else if (testSet == null && nextTestSet != null) {
                        testSet = nextTestSet;
                        randomSeed = nextRandomSeed;
                    }
                    ++i;
                }
                if (testSet == null) {
                    Error.printError("\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u6570\u304c\u4e0a\u965065532\u3092\u8d85\u3048\u307e\u3057\u305f");
                }
                new Outputer(outputFile).outputResult(testSet, inputfiledata, randomSeed, modelFile, seedFile, outputFile, strength, numOfIterations);
            }
            if (debugMode) {
                System.err.println("test set size: " + testSet.size());
            }
        }
        catch (OutOfMemoryError e) {
            Error.printError("\u30e1\u30e2\u30ea\u4e0d\u8db3\u3067\u3059\uff0e");
        }
        catch (Exception e) {
            Error.printError("\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
        }
    }

    private static String processCommandArgument(String[] args) {
        if (args.length == 0) {
            Error.printError("usage: java -jar Program.jar [-i input] [-o output] [-policy] ...");
        }
        if (args.length == 1 && args[0].equals("-policy")) {
            System.out.println("This software is distributed under the 2-clause BSD license.\nThe software contains Java classes from JDD, a Java BDD library developed by Arash Vahidi.\nJDD is free software distributed under the zlib license.\n\nCopyright (c) 2012, Tatsuhiro Tsuchiya\nAll rights reserved.\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\nRedistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\nRedistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
            System.exit(0);
        }
        String errorMessage = null;
        int i = 0;
        while (i + 1 < args.length) {
            block28: {
                String option = args[i];
                String str = args[i + 1];
                if (option.equals("-i")) {
                    modelFile = str;
                } else if (option.equals("-o")) {
                    outputFile = str;
                } else if (option.equals("-random")) {
                    try {
                        randomSeed = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        errorMessage = "\u30e9\u30f3\u30c0\u30e0\u30b7\u30fc\u30c9\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e";
                        break block28;
                    }
                    randomSeed = Math.abs(randomSeed) % 65536;
                } else if (option.equals("-c")) {
                    if (str.equals("all")) {
                        strength = -1;
                    } else {
                        try {
                            strength = Integer.parseInt(str);
                        }
                        catch (NumberFormatException e) {
                            errorMessage = "\u7db2\u7f85\u5ea6\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e";
                            break block28;
                        }
                        if (strength < 2 || 5 < strength) {
                            errorMessage = "\u7db2\u7f85\u5ea6\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e";
                        }
                    }
                } else if (option.equals("-repeat")) {
                    try {
                        numOfIterations = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        errorMessage = "\u304f\u308a\u8fd4\u3057\u6570\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e";
                        break block28;
                    }
                    if (numOfIterations <= 0 || numOfIterations > 100000) {
                        errorMessage = "\u304f\u308a\u8fd4\u3057\u6570\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e";
                    }
                } else if (option.equals("-s")) {
                    seedFile = str;
                } else if (option.equals("-debug")) {
                    debugMode = true;
                } else {
                    errorMessage = "\u7121\u52b9\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e";
                }
            }
            i += 2;
        }
        if (randomSeed == -1) {
            randomSeed = (int)Math.floor(Math.random() * 65536.0);
        }
        return errorMessage;
    }
}

