/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.sets;

import jdd.bdd.sets.BDDSetEnumeration;
import jdd.bdd.sets.BDDUniverse;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.sets.Set;
import jdd.util.sets.SetEnumeration;

public class BDDSet
implements Set {
    static int[] dum = new int[]{3, 4, 5, 2};
    private BDDUniverse universe;
    private boolean[] internal_minterm;
    int bdd;

    public double cardinality() {
        return this.universe.satCount(this.bdd);
    }

    public void free() {
        this.universe.deref(this.bdd);
    }

    public boolean equals(Set set) {
        boolean bl = false;
        if (this.bdd == ((BDDSet)set).bdd) {
            bl = true;
        }
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.bdd == 0) {
            bl = true;
        }
        return bl;
    }

    public void assign(Set set) {
        this.universe.deref(this.bdd);
        this.bdd = this.universe.ref(((BDDSet)set).bdd);
    }

    public void clear() {
        this.universe.deref(this.bdd);
        this.bdd = 0;
    }

    void show() {
        this.universe.printSet(this.bdd);
    }

    public boolean memberDC(int[] nArray) {
        int n = this.universe.vectorToBDD(nArray);
        int n2 = this.universe.or(n, this.bdd);
        boolean bl = false;
        if (n2 == this.bdd) {
            bl = true;
        }
        boolean bl2 = bl;
        this.universe.deref(n);
        return bl2;
    }

    public boolean member(int[] nArray) {
        this.universe.vectorToMinterm(nArray, this.internal_minterm);
        return this.universe.member(this.bdd, this.internal_minterm);
    }

    public boolean remove(int[] nArray) {
        int n = this.universe.vectorToBDD(nArray);
        int n2 = this.universe.ref(this.universe.not(n));
        this.universe.deref(n);
        int n3 = this.universe.ref(this.universe.and(this.bdd, n2));
        this.universe.deref(n2);
        if (n3 == this.bdd) {
            this.universe.deref(n3);
            return false;
        }
        this.universe.deref(this.bdd);
        this.bdd = n3;
        return true;
    }

    public boolean insert(int[] nArray) {
        int n = this.universe.vectorToBDD(nArray);
        int n2 = this.universe.ref(this.universe.or(this.bdd, n));
        if (n2 == this.bdd) {
            this.universe.deref(n2);
            return false;
        }
        this.universe.deref(this.bdd);
        this.bdd = n2;
        return true;
    }

    public Set copy() {
        return new BDDSet(this.universe, this.bdd);
    }

    public Set invert() {
        int n = this.universe.ref(this.universe.not(this.bdd));
        BDDSet bDDSet = new BDDSet(this.universe, this.universe.removeDontCares(n));
        this.universe.deref(n);
        return bDDSet;
    }

    public Set union(Set set) {
        return new BDDSet(this.universe, this.universe.or(this.bdd, ((BDDSet)set).bdd));
    }

    public Set intersection(Set set) {
        return new BDDSet(this.universe, this.universe.and(this.bdd, ((BDDSet)set).bdd));
    }

    public Set diff(Set set) {
        BDDSet bDDSet = (BDDSet)set;
        int n = this.universe.ref(this.universe.not(bDDSet.bdd));
        int n2 = this.universe.and(this.bdd, n);
        this.universe.deref(n);
        return new BDDSet(this.universe, n2);
    }

    public int compare(Set set) {
        BDDSet bDDSet = (BDDSet)set;
        if (bDDSet.bdd == this.bdd) {
            return 0;
        }
        int n = this.universe.or(this.bdd, bDDSet.bdd);
        if (n == this.bdd) {
            return 1;
        }
        if (n == bDDSet.bdd) {
            return -1;
        }
        return Integer.MAX_VALUE;
    }

    public SetEnumeration elements() {
        return new BDDSetEnumeration(this.universe, this.bdd);
    }

    public void show(String string) {
        JDDConsole.out.print(string + " = ");
        if (this.bdd == 0) {
            JDDConsole.out.println("empty set");
            return;
        }
        JDDConsole.out.print("{\n  ");
        SetEnumeration setEnumeration = this.elements();
        int n = 0;
        while (setEnumeration.hasMoreElements()) {
            int[] nArray = setEnumeration.nextElement();
            this.universe.print(nArray);
            if ((n += nArray.length + 1) > 20) {
                n = 0;
                JDDConsole.out.print("\n  ");
                continue;
            }
            JDDConsole.out.print(" ");
        }
        if (n != 0) {
            JDDConsole.out.println();
        }
        JDDConsole.out.println("\r}");
        setEnumeration.free();
    }

    public static void internal_test() {
        Test.start("BDDSet");
        BDDUniverse bDDUniverse = new BDDUniverse(dum);
        Set set = bDDUniverse.createEmptySet();
        Set set2 = bDDUniverse.createFullSet();
        int[] nArray = new int[4];
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        Test.check(set.insert(nArray), "v not in S1 before");
        Test.check(set.insert(nArray) ^ true, "v in S1 after");
        Test.checkEquality(set.cardinality(), 1.0, "Cardinality 1 after inserting v");
        Test.check(set.member(nArray), "v \\in S1");
        Test.check(set.remove(nArray), "v removed from S1");
        Test.check(set.member(nArray) ^ true, "v \\not\\in S1");
        Test.check(set.remove(nArray) ^ true, "v already removed from S1 and not in S1 anymore");
        Test.checkEquality(set.cardinality(), 0.0, "S1 empty again");
        Test.check(set.isEmpty(), "S1 is empty");
        Test.check(set2.isEmpty() ^ true, "S2 is not empty");
        Set set3 = set.invert();
        Test.check(set3.equals(set2), "(NOT  emptyset) = fullset");
        set3.free();
        Set set4 = set2.copy();
        Test.check(set4.equals(set2), "copy() test");
        set4.clear();
        Test.check(set4.equals(set), "clear() test");
        set4.free();
        Set set5 = bDDUniverse.createEmptySet();
        Set set6 = bDDUniverse.createEmptySet();
        Set set7 = bDDUniverse.createEmptySet();
        nArray[3] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        nArray[0] = 0;
        set5.insert(nArray);
        set7.insert(nArray);
        nArray[3] = 1;
        nArray[2] = 1;
        nArray[1] = 1;
        nArray[0] = 1;
        set6.insert(nArray);
        set7.insert(nArray);
        Set set8 = set6.union(set5);
        Test.check(set8.equals(set7), "union() - test");
        set8.free();
        Set set9 = set7.diff(set6);
        Set set10 = set7.diff(set5);
        Test.check(set9.equals(set5), "diff() - test 1");
        Test.check(set10.equals(set6), "diff() - test 2");
        set9.free();
        set10.free();
        Set set11 = set7.intersection(set6);
        Set set12 = set7.intersection(set5);
        Test.check(set11.equals(set6), "intersection() - test 1");
        Test.check(set12.equals(set5), "intersection() - test 2");
        set11.free();
        set12.free();
        Test.checkEquality(set6.compare(set6), 0, "x1 = x1");
        Test.checkEquality(set7.compare(set6), 1, "x1  < x10");
        Test.checkEquality(set6.compare(set7), -1, "x10 > x1");
        Test.checkEquality(set7.compare(set5), 1, "x10 > x0");
        Test.checkEquality(set5.compare(set7), -1, "x0  < x0");
        Test.checkEquality(set6.compare(set5), Integer.MAX_VALUE, "x10 ?? x0");
        set.free();
        set2.free();
        Test.end();
    }

    BDDSet(BDDUniverse bDDUniverse, int n) {
        this.universe = bDDUniverse;
        this.bdd = this.universe.ref(n);
        this.internal_minterm = new boolean[this.universe.numberOfBits()];
    }
}

