/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.sets;

import jdd.bdd.BDD;
import jdd.bdd.BDDUtil;
import jdd.bdd.sets.BDDSet;
import jdd.bdd.sets.SubDomain;
import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.sets.Set;
import jdd.util.sets.Universe;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDDUniverse
extends BDD
implements Universe {
    static int[] dum = new int[]{3, 4, 5, 1};
    private int[] int_subdomains;
    private int[] int_bits;
    private double domainsize;
    private int num_subdomains;
    private int all;
    private int bits;
    private SubDomain[] subdomains;
    private int[] sat_vec;
    private int sat_curr;
    private int sat_level;
    private int sat_next;
    private int sat_index;
    private int sat_bit;

    public void free() {
        this.cleanup();
        this.subdomains = null;
    }

    int vectorToBDD(int[] nArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < this.num_subdomains) {
            if (nArray[n2] != -1) {
                int n3 = this.ref(this.and(n, this.subdomains[n2].numbers[nArray[n2]]));
                this.deref(n);
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    void vectorToMinterm(int[] nArray, boolean[] blArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.num_subdomains) {
            if (nArray[n2] != -1) {
                BDDUtil.numberToMinterm(nArray[n2], this.int_bits[n2], n, blArray);
                n += this.int_bits[n2];
            }
            ++n2;
        }
    }

    public int cardinality(int[] nArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < this.num_subdomains) {
            if (nArray[n2] == -1) {
                n *= this.subdomains[n2].getSize();
            }
            ++n2;
        }
        return n;
    }

    public Set createEmptySet() {
        return new BDDSet(this, 0);
    }

    public Set createFullSet() {
        return new BDDSet(this, this.all);
    }

    public Set simplify(Set set, Set set2) {
        int n = this.restrict(((BDDSet)set).bdd, ((BDDSet)set2).bdd);
        return new BDDSet(this, n);
    }

    public double domainSize() {
        return this.domainsize;
    }

    public int subdomainCount() {
        return this.num_subdomains;
    }

    public int numberOfBits() {
        return this.bits;
    }

    int removeDontCares(int n) {
        return this.and(n, this.all);
    }

    public void print(int[] nArray) {
        JDDConsole.out.print("<");
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                JDDConsole.out.print(", ");
            }
            if (nArray[n] == -1) {
                JDDConsole.out.print("-");
            } else {
                JDDConsole.out.print("" + nArray[n]);
            }
            ++n;
        }
        JDDConsole.out.print(">");
    }

    public void randomMember(int[] nArray) {
        int n = 0;
        while (n < this.num_subdomains) {
            nArray[n] = (int)(Math.random() * (double)this.int_subdomains[n]);
            ++n;
        }
    }

    public void satOneVector(int n, int[] nArray) {
        this.sat_vec = nArray;
        this.sat_bit = 0;
        this.sat_index = 0;
        this.sat_level = 0;
        this.sat_curr = 0;
        this.sat_next = this.subdomains[0].bits;
        this.satOneVector_rec(n);
        while (this.sat_index < this.num_subdomains) {
            this.satOneVector_insert(false);
        }
        this.sat_vec = null;
    }

    private final void satOneVector_insert(boolean bl) {
        if (bl) {
            this.sat_curr |= 1 << this.sat_bit;
        }
        if (++this.sat_level == this.sat_next) {
            this.sat_vec[this.sat_index++] = this.sat_curr;
            this.sat_curr = 0;
            this.sat_bit = 0;
            if (this.sat_index < this.num_subdomains) {
                this.sat_next += this.subdomains[this.sat_index].bits;
            }
        } else {
            ++this.sat_bit;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void satOneVector_rec(int var1_1) {
        if (var1_1 >= 2) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.satOneVector_insert(false);
lbl4:
            // 2 sources

            ** while (this.getVar((int)var1_1) > this.sat_level)
        }
lbl5:
        // 1 sources

        if (this.getLow(var1_1) == 0) {
            this.satOneVector_insert(true);
            this.satOneVector_rec(this.getHigh(var1_1));
        } else {
            this.satOneVector_insert(false);
            this.satOneVector_rec(this.getLow(var1_1));
        }
    }

    public static void internal_test() {
        Test.start("BDDUniverse");
        BDDUniverse bDDUniverse = new BDDUniverse(dum);
        Set set = bDDUniverse.createEmptySet();
        Set set2 = bDDUniverse.createFullSet();
        Test.checkEquality(set.cardinality(), 0.0, "Empty set has zero cardinality");
        Test.checkEquality(set2.cardinality(), bDDUniverse.domainSize(), "Full set as large as the universe");
        Test.checkEquality(bDDUniverse.cardinality(dum), 1, "Single cardinality");
        BDDUniverse.dum[0] = -1;
        Test.checkEquality(bDDUniverse.cardinality(dum), 3, "DC leads to higher cardinality");
        set.free();
        set2.free();
        Test.end();
    }

    private final /* synthetic */ void this() {
        this.sat_vec = null;
    }

    public BDDUniverse(int[] nArray) {
        super(1000, 1000);
        this.this();
        this.num_subdomains = nArray.length;
        this.int_subdomains = Array.clone(nArray);
        this.int_bits = new int[this.num_subdomains];
        this.subdomains = new SubDomain[this.num_subdomains];
        this.domainsize = 1.0;
        this.bits = 0;
        int n = 0;
        while (n < this.num_subdomains) {
            this.subdomains[n] = new SubDomain(this, this.int_subdomains[n]);
            this.domainsize *= (double)this.int_subdomains[n];
            this.int_bits[n] = this.subdomains[n].bits;
            this.bits += this.subdomains[n].bits;
            ++n;
        }
        this.all = 1;
        n = 0;
        while (n < this.num_subdomains) {
            int n2 = this.ref(this.and(this.all, this.subdomains[n].all));
            this.deref(this.all);
            this.all = n2;
            ++n;
        }
    }
}

