/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import jdd.util.Allocator;
import jdd.util.Test;
import jdd.util.math.FastRandom;

public final class Array {
    public static final int[] resize(int[] nArray, int n, int n2) {
        int[] nArray2 = Allocator.allocateIntArray(n2);
        if (n > n2) {
            n = n2;
        }
        Array.fast_copy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static final short[] resize(short[] sArray, int n, int n2) {
        short[] sArray2 = Allocator.allocateShortArray(n2);
        if (n > n2) {
            n = n2;
        }
        Array.fast_copy(sArray, 0, sArray2, 0, n);
        return sArray2;
    }

    public static final void copy(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (nArray == nArray2 && n2 < n3 && n2 + n >= n3) {
            Array.fast_copy_backward(nArray, n2, nArray2, n3, n);
            return;
        }
        Array.fast_copy(nArray, n2, nArray2, n3, n);
    }

    private static final void fast_copy(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        System.arraycopy(nArray, n, nArray2, n2, n3);
    }

    private static final void fast_copy(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        System.arraycopy(sArray, n, sArray2, n2, n3);
    }

    private static final void fast_copy_foward(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n2 + n4] = nArray[n + n4];
            ++n4;
        }
    }

    private static final void fast_copy_foward(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            sArray2[n2 + n4] = sArray[n + n4];
            ++n4;
        }
    }

    private static final void fast_copy_backward(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        while (n3 != 0) {
            nArray2[n2 + --n3] = nArray[n + n3];
        }
    }

    public static final int[] clone(int[] nArray) {
        int[] nArray2 = Allocator.allocateIntArray(nArray.length);
        Array.fast_copy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final boolean[] clone(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    public static final void set(int[] nArray, int n) {
        Array.set(nArray, n, nArray.length);
    }

    public static final void set(int[] nArray, int n, int n2) {
        int n3 = n2;
        while (n3 != 0) {
            nArray[--n3] = n;
        }
    }

    public static final void set(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        while (n != 0) {
            blArray[--n] = bl;
        }
    }

    public static final int count(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        while (n3 != 0) {
            if (nArray[--n3] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int count(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (blArray[n3] == bl) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static final void reverse(Object[] objectArray, int n) {
        int n2 = n / 2;
        --n;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n - n3;
            Object object = objectArray[n4];
            objectArray[n4] = objectArray[n3];
            objectArray[n3] = object;
            ++n3;
        }
    }

    public static final void reverse(int[] nArray, int n) {
        int n2 = n / 2;
        --n;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n - n3;
            int n5 = nArray[n4];
            nArray[n4] = nArray[n3];
            nArray[n3] = n5;
            ++n3;
        }
    }

    public static final void reverse(double[] dArray, int n) {
        int n2 = n / 2;
        --n;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n - n3;
            double d = dArray[n4];
            dArray[n4] = dArray[n3];
            dArray[n3] = d;
            ++n3;
        }
    }

    public static final void shuffle(int[] nArray) {
        Array.shuffle(nArray, nArray.length);
    }

    public static final void shuffle(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = FastRandom.mtrand() % n;
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
        }
    }

    public static final void disturb(int[] nArray, int n) {
        if (n < 16) {
            Array.shuffle(nArray, n);
        } else {
            int n2 = Math.max(4, n / 20);
            while (n2-- > 0) {
                int n3 = FastRandom.mtrand() % n;
                int n4 = FastRandom.mtrand() % n;
                int n5 = nArray[n4];
                nArray[n4] = nArray[n3];
                nArray[n3] = n5;
            }
        }
    }

    public static final int[] permutation(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        Array.shuffle(nArray);
        return nArray;
    }

    public static final boolean equals(boolean[] blArray, boolean[] blArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (blArray[n2] != blArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean equals(short[] sArray, short[] sArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (sArray[n2] != sArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean equals(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean equals(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final void internal_test() {
        Test.start("Array");
        int[] nArray = new int[]{2, 3};
        int[] nArray2 = Array.resize(nArray, 2, 5);
        boolean bl = false;
        if (nArray2.length == 5) {
            bl = true;
        }
        Test.check(bl, "new array size OK");
        boolean bl2 = false;
        if (nArray2[0] == 2 && nArray2[1] == 3) {
            bl2 = true;
        }
        Test.check(bl2, "old data copied");
        int[] nArray3 = Array.resize(nArray, 2, 1);
        boolean bl3 = false;
        if (nArray3.length == 1) {
            bl3 = true;
        }
        Test.check(bl3, "new array size OK, even when decreasing");
        Array.set(nArray2, 5);
        int n = 0;
        while (n < nArray2.length) {
            boolean bl4 = false;
            if (nArray2[n] == 5) {
                bl4 = true;
            }
            Test.check(bl4, "array set");
            ++n;
        }
        int[] nArray4 = new int[1024];
        int n2 = 0;
        while (n2 < 1024) {
            nArray4[n2] = n2;
            ++n2;
        }
        Test.checkEquality(nArray4[0], 0, "Im an idiot");
        Array.copy(nArray4, nArray4, 1023, 0, 1);
        Test.checkEquality(nArray4[0], 0, "Im still an idiot");
        Test.checkEquality(nArray4[1], 0, "backward_copy 1");
        Test.checkEquality(nArray4[1023], 1022, "backward_copy 2");
        Array.copy(nArray4, nArray4, 1023, 1, 0);
        Test.checkEquality(nArray4[3], 3, "forward_copy 1");
        Test.checkEquality(nArray4[1023], 1022, "forward_copy 2, not touched!");
        Test.checkEquality(nArray4[1022], 1022, "forward_copy 3, has been chagned back!");
        Test.end();
    }
}

