/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import jdd.util.JDDConsole;
import jdd.util.Test;

public class Digits {
    public static int log2_ceil(int n) {
        int n2 = 1;
        while (1L << n2 < (long)n) {
            ++n2;
        }
        return n2;
    }

    public static int closest_log2(int n) {
        long l;
        int n2 = Digits.log2_ceil(n);
        long l2 = (1L << n2) - (long)n;
        return l2 < (l = (long)n - (1L << n2 - 1)) ? n2 : n2 - 1;
    }

    public static int maxUniquePairs(int n) {
        if (n == 0 || n == 1) {
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        return n - 1 + Digits.maxUniquePairs(n - 1);
    }

    public static double getPercent(double d) {
        return Digits.getWithDecimals(100.0 * d, 2);
    }

    public static double getWithDecimals(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static void printNumber(long l) {
        Digits.printNumberWith(l, 1000L);
    }

    public static void printNumber1024(long l) {
        Digits.printNumberWith(l, 1024L);
    }

    private static final void printNumberWith(long l, long l2) {
        long l3 = l2 * l2;
        long l4 = l2 * l3;
        long l5 = l2 * l4;
        if (l > l5) {
            JDDConsole.out.print(Digits.numberDivided(l, l5) + "T ");
        } else if (l > l4) {
            JDDConsole.out.print(Digits.numberDivided(l, l4) + "G ");
        } else if (l > l3) {
            JDDConsole.out.print(Digits.numberDivided(l, l3) + "M ");
        } else if (l > l2) {
            JDDConsole.out.print(Digits.numberDivided(l, l2) + "k ");
        } else {
            JDDConsole.out.print("" + l + ' ');
        }
    }

    public static double numberDivided(double d, long l) {
        int n = (int)(100.0 * (d + (double)(l / 200L)) / (double)l);
        return (double)n / 100.0;
    }

    public static void internal_test() {
        Test.start("Digits");
        Test.checkEquality(Digits.log2_ceil(3), 2, "log2_ceil (1)");
        Test.checkEquality(Digits.log2_ceil(4), 2, "log2_ceil (2)");
        Test.checkEquality(Digits.log2_ceil(10), 4, "log2_ceil (3)");
        Test.checkEquality(Digits.log2_ceil(16), 4, "log2_ceil (4)");
        Test.checkEquality(Digits.log2_ceil(17), 5, "log2_ceil (5)");
        Test.checkEquality(Digits.closest_log2(5), 2, "closest_log2 (1)");
        Test.checkEquality(Digits.closest_log2(4), 2, "closest_log2 (2)");
        Test.checkEquality(Digits.closest_log2(7), 3, "closest_log2 (3)");
        Test.checkEquality(Digits.closest_log2(16), 4, "closest_log2 (4)");
        Test.checkEquality(Digits.closest_log2(17), 4, "closest_log2 (5)");
        Test.checkEquality(Digits.closest_log2(31), 5, "closest_log2 (5)");
        Test.end();
    }
}

