/*
 * Decompiled with CFR 0.152.
 */
package jdd.examples;

import jdd.bdd.Permutation;
import jdd.bdd.debug.ProfiledBDD2;
import jdd.util.JDDConsole;

public class Milner
extends ProfiledBDD2 {
    private int N;
    private int[] normvar;
    private int[] primvar;
    private int[] c;
    private int[] cp;
    private int[] t;
    private int[] tp;
    private int[] h;
    private int[] hp;
    private int I;
    private int T;
    private int normvarset;
    private Permutation pairs;

    public Milner(int n) {
        super(100000, 30000);
        int n2;
        this.N = n;
        this.normvar = new int[n * 3];
        this.primvar = new int[n * 3];
        this.c = new int[n];
        this.cp = new int[n];
        this.h = new int[n];
        this.hp = new int[n];
        this.t = new int[n];
        this.tp = new int[n];
        for (n2 = 0; n2 < n * 3; ++n2) {
            this.normvar[n2] = this.createVar();
            this.primvar[n2] = this.createVar();
        }
        this.pairs = this.createPermutation(this.primvar, this.normvar);
        this.normvarset = 1;
        for (n2 = 0; n2 < this.normvar.length; ++n2) {
            this.normvarset = this.andTo(this.normvarset, this.normvar[n2]);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.c[n2] = this.normvar[n2 * 3];
            this.t[n2] = this.normvar[n2 * 3 + 1];
            this.h[n2] = this.normvar[n2 * 3 + 2];
            this.cp[n2] = this.primvar[n2 * 3];
            this.tp[n2] = this.primvar[n2 * 3 + 1];
            this.hp[n2] = this.primvar[n2 * 3 + 2];
        }
        this.I = this.initial_state(this.t, this.h, this.c);
        this.T = this.transitions(this.t, this.tp, this.h, this.hp, this.c, this.cp);
    }

    private int andA(int n, int[] nArray, int[] nArray2, int n2) {
        for (int i = 0; i < this.N; ++i) {
            if (i == n2) continue;
            int n3 = this.ref(this.biimp(nArray[i], nArray2[i]));
            n = this.andTo(n, n3);
            this.deref(n3);
        }
        return n;
    }

    private int diff(int n, int n2) {
        int n3 = this.ref(this.not(n2));
        int n4 = this.and(n3, n);
        this.deref(n3);
        return n4;
    }

    private int transitions(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int n = 0;
        for (int i = 0; i < this.N; ++i) {
            int n2 = this.ref(this.diff(nArray5[i], nArray6[i]));
            int n3 = this.ref(this.diff(nArray2[i], nArray[i]));
            n2 = this.andTo(n2, n3);
            this.deref(n3);
            n2 = this.andTo(n2, nArray4[i]);
            n2 = this.andA(n2, nArray5, nArray6, i);
            n2 = this.andA(n2, nArray, nArray2, i);
            int n4 = n2 = this.andA(n2, nArray3, nArray4, i);
            n2 = this.ref(this.diff(nArray3[i], nArray4[i]));
            n2 = this.andTo(n2, nArray6[(i + 1) % this.N]);
            n2 = this.andA(n2, nArray5, nArray6, (i + 1) % this.N);
            n2 = this.andA(n2, nArray3, nArray4, i);
            n2 = this.andA(n2, nArray, nArray2, this.N);
            n4 = this.orTo(n4, n2);
            this.deref(n2);
            n2 = this.ref(this.not(nArray2[i]));
            n2 = this.andTo(n2, nArray[i]);
            n2 = this.andA(n2, nArray, nArray2, i);
            n2 = this.andA(n2, nArray3, nArray4, this.N);
            int n5 = this.andA(n2, nArray5, nArray6, this.N);
            n3 = this.ref(this.or(n4, n5));
            this.deref(n4);
            this.deref(n5);
            n = this.orTo(n, n3);
            this.deref(n3);
        }
        return n;
    }

    private int initial_state(int[] nArray, int[] nArray2, int[] nArray3) {
        this.I = 1;
        for (int i = 0; i < this.N; ++i) {
            int n = this.ref(i == 0 ? nArray3[i] : this.not(nArray3[i]));
            n = this.andTo(n, this.not(nArray2[i]));
            n = this.andTo(n, this.not(nArray[i]));
            this.I = this.andTo(this.I, n);
            this.deref(n);
        }
        return this.I;
    }

    public int reachable_states() {
        int n;
        int n2;
        int n3 = 0;
        do {
            n2 = n3;
            int n4 = this.ref(this.relProd(n3, this.T, this.normvarset));
            this.deref(n3);
            n = this.ref(this.replace(n4, this.pairs));
            this.deref(n4);
        } while (n2 != (n3 = this.orTo(n, this.I)));
        return n3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            int n = -1;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-v")) {
                    bl = true;
                    continue;
                }
                n = Integer.parseInt(stringArray[i]);
            }
            if (n > 0) {
                long l = System.currentTimeMillis();
                Milner milner = new Milner(n);
                int n2 = milner.reachable_states();
                long l2 = System.currentTimeMillis();
                if (bl) {
                    milner.showStats();
                    JDDConsole.out.println("Simulation of " + n + " milner cyclers");
                    JDDConsole.out.println("SatCount(R) = " + milner.satCount(n2));
                    JDDConsole.out.println("Calc        = " + (double)n * Math.pow(2.0, 1 + n) * Math.pow(2.0, 3 * n));
                    JDDConsole.out.println("Time: " + (l2 - l) + " [ms]");
                } else {
                    JDDConsole.out.println("" + n + " milner cyclers, time: " + (l2 - l) + " [ms]");
                }
                milner.cleanup();
                return;
            }
        }
        JDDConsole.out.println("Usage: java jdd.examples.Milner [-v] <number of cyclers>");
    }
}

