/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import jdd.graph.Node;
import jdd.util.Dot;
import jdd.util.JDDConsole;

public class Topology {
    Vector nodes = null;
    Vector children = null;
    boolean disjoint = false;
    static int dot_internal = 0;

    public void add(Node node) {
        if (this.nodes == null) {
            this.nodes = new Vector();
        }
        this.nodes.add(node);
    }

    public void add(Topology topology) {
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(topology);
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Vector getChildren() {
        return this.children;
    }

    public Topology simplify() {
        if (this.nodes == null) {
            if (this.children == null) {
                return null;
            }
            if (this.children.size() == 1) {
                Enumeration enumeration = this.children.elements();
                Topology topology = (Topology)enumeration.nextElement();
                return topology;
            }
        }
        return this;
    }

    public void show() {
        Object object;
        Enumeration enumeration;
        if (this.nodes != null) {
            enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                JDDConsole.out.print(" " + ((Node)object).label);
            }
        }
        if (this.children != null) {
            enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                object = (Topology)enumeration.nextElement();
                JDDConsole.out.print(" (");
                ((Topology)object).show();
                JDDConsole.out.print(") ");
            }
        }
    }

    public void showDot(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("digraph G {");
            printStream.println("\tgraph [splines=false overlap=false];");
            if (Dot.scaleable()) {
                printStream.println("\tsize = \"7.5,20\";");
            }
            printStream.println("\tcenter = true;");
            dot_internal = 0;
            int n = this.show_dot_rec(printStream);
            printStream.println("\t intialXXX [label=\"\", style=invis, height=0, width=0];");
            printStream.println("\t intialXXX -> internal_" + n + "[style=bold];");
            printStream.println("}\n");
            printStream.close();
            Dot.showDot(string);
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Topology.showDot failed: " + iOException);
        }
    }

    private int show_dot_rec(PrintStream printStream) {
        int n;
        Object object;
        Enumeration enumeration;
        int n2 = dot_internal++;
        if (this.disjoint) {
            printStream.println("\t internal_" + n2 + " [label=\"(disjoint)\", shape=box,color=red];");
        } else {
            printStream.println("\t internal_" + n2 + " [label=\"LL\", shape=point];");
        }
        if (this.nodes != null) {
            enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                ++dot_internal;
                printStream.println("\t " + n + " [label=\"" + ((Node)object).label + "\"];");
                printStream.println("\t internal_" + n2 + " -> " + n + ";");
            }
        }
        if (this.children != null) {
            enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                object = (Topology)enumeration.nextElement();
                n = super.show_dot_rec(printStream);
                printStream.println("\t internal_" + n2 + " -> internal_" + n + ";");
            }
        }
        return n2;
    }
}

