/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.List;
import v1.ConstraintHandler;
import v1.Error;
import v1.GList;
import v1.Generator;
import v1.Main;
import v1.OutOfMaxNumOfTestcasesException;
import v1.ParameterModel;
import v1.ResultOfGenerateOneTest;
import v1.Testcase;
import v1.TripleTable;

class Generator3
extends Generator {
    Generator3(ParameterModel parametermodel, GList groupList, ConstraintHandler constrainthandler, List<Testcase> seed, long randomseed) {
        super(parametermodel, groupList, constrainthandler, seed, randomseed);
    }

    @Override
    List<Testcase> generate() throws OutOfMaxNumOfTestcasesException {
        ArrayList<Testcase> res = new ArrayList<Testcase>();
        TripleTable tab = new TripleTable(this.parametermodel);
        List<List<Testcase>> tupleSequenceList = this.generateTupleSequenceList();
        int numOfUncoveredTuples = this.checkAllTuples(tab);
        ArrayList[] uncovTab = new ArrayList[this.parametermodel.size];
        this.initializeUncovTab(uncovTab, tab);
        int seedrownum = 0;
        while (numOfUncoveredTuples > 0 || this.hasTuplesToCover(tupleSequenceList)) {
            ResultOfGenerateOneTest newresult = this.generateOneTest(tab, seedrownum, uncovTab, tupleSequenceList);
            res.add(newresult.test);
            if (res.size() > 65532) {
                throw new OutOfMaxNumOfTestcasesException();
            }
            numOfUncoveredTuples -= newresult.numOfCoveredTuples;
            seedrownum = newresult.nextSeedRow;
        }
        return res;
    }

    private int checkAllTuples(TripleTable tab) {
        int numOfTriples = 0;
        int i = 0;
        while (i < this.numOfParameters - 2) {
            int j = i + 1;
            while (j < this.numOfParameters - 1) {
                int k = j + 1;
                while (k < this.numOfParameters) {
                    byte v1 = 0;
                    while (v1 < this.parametermodel.range[i]) {
                        byte v2 = 0;
                        while (v2 < this.parametermodel.range[j]) {
                            byte v3 = 0;
                            while (v3 < this.parametermodel.range[k]) {
                                assert (i < j && j < k);
                                Testcase triple = new Testcase(this.numOfParameters);
                                triple.quantify();
                                triple.set(i, v1);
                                triple.set(j, v2);
                                triple.set(k, v3);
                                if (!this.constrainthandler.isPossible(triple)) {
                                    tab.set(i, v1, j, v2, k, v3);
                                } else {
                                    ++numOfTriples;
                                }
                                v3 = (byte)(v3 + 1);
                            }
                            v2 = (byte)(v2 + 1);
                        }
                        v1 = (byte)(v1 + 1);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return numOfTriples;
    }

    private void initializeUncovTab(ArrayList<Integer>[] uncovTab, TripleTable tab) {
        assert (this.parametermodel.size == uncovTab.length);
        int p = 0;
        while (p < this.parametermodel.size) {
            uncovTab[p] = new ArrayList();
            byte v = 0;
            while (v < this.parametermodel.range[p]) {
                int sum = 0;
                int p1 = 0;
                while (p1 < this.parametermodel.size - 1) {
                    int p2 = p1 + 1;
                    while (p2 < this.parametermodel.size) {
                        if (p != p1 && p != p2) {
                            byte v1 = 0;
                            while (v1 < this.parametermodel.range[p1]) {
                                byte v2 = 0;
                                while (v2 < this.parametermodel.range[p2]) {
                                    if (!tab.get(p, v, p1, v1, p2, v2)) {
                                        ++sum;
                                    }
                                    v2 = (byte)(v2 + 1);
                                }
                                v1 = (byte)(v1 + 1);
                            }
                        }
                        ++p2;
                    }
                    ++p1;
                }
                uncovTab[p].add(sum);
                v = (byte)(v + 1);
            }
            ++p;
        }
    }

    private ResultOfGenerateOneTest generateOneTest(TripleTable tab, int seedrownum, ArrayList<Integer>[] uncovTab, List<List<Testcase>> tupleSequenceList) {
        Testcase tmp = new Testcase(this.parametermodel.size);
        tmp.quantify();
        boolean isSeedUsed = false;
        if (this.seed.size() > 0 && seedrownum < this.seed.size()) {
            isSeedUsed = true;
            Testcase seedrow = (Testcase)this.seed.get(seedrownum);
            int i = 0;
            while (i < this.parametermodel.size) {
                tmp.set(i, seedrow.get(i));
                ++i;
            }
        }
        if (!this.constrainthandler.isPossible(tmp)) {
            Error.printError(Main.language == Main.Language.JP ? "seed\u306e" + (seedrownum + 1) + "\u884c\u76ee\u304c\u5236\u7d04\u9055\u53cd\u3067\u3059" : "The" + (seedrownum + 1) + "th seeding row violates the constraints.");
            return null;
        }
        boolean isGroupUsed = this.addGroupedTuples(tmp, tupleSequenceList);
        Testcase temptest = this.generateTempTest(tmp, tab, uncovTab);
        if (!isSeedUsed && !isGroupUsed && this.computeNewlyCoveredTuples(tab, temptest) == 0) {
            this.addUncoveredTuple(tmp, tab, uncovTab);
            temptest = this.generateTempTest(tmp, tab, uncovTab);
        }
        this.finallizeUncoverTable(uncovTab, tab, temptest);
        int newtuples = this.finalizeTupleTable(tab, temptest);
        ResultOfGenerateOneTest res = new ResultOfGenerateOneTest();
        res.test = temptest;
        res.numOfCoveredTuples = newtuples;
        res.nextSeedRow = isSeedUsed ? seedrownum + 1 : seedrownum;
        return res;
    }

    private void finallizeUncoverTable(ArrayList<Integer>[] uncovTab, TripleTable tab, Testcase temptest) {
        int p = 0;
        while (p < this.parametermodel.size) {
            int numCovered = 0;
            byte v = temptest.get(p);
            if (v >= 0) {
                int p1 = 0;
                while (p1 < this.parametermodel.size - 1) {
                    int p2 = p1 + 1;
                    while (p2 < this.parametermodel.size) {
                        byte v2;
                        byte v1;
                        if (p != p1 && p != p2 && (v1 = temptest.get(p1)) >= 0 && (v2 = temptest.get(p2)) >= 0 && !tab.get(p, v, p1, v1, p2, v2)) {
                            ++numCovered;
                        }
                        ++p2;
                    }
                    ++p1;
                }
                int numUncovered = uncovTab[p].get(v);
                uncovTab[p].set(v, numUncovered - numCovered);
            }
            ++p;
        }
    }

    private int finalizeTupleTable(TripleTable tab, Testcase test) {
        int numOfNewlyCoveredTuples = 0;
        int p0 = 0;
        while (p0 < this.numOfParameters - 2) {
            int p1 = p0 + 1;
            while (p1 < this.numOfParameters - 1) {
                int p2 = p1 + 1;
                while (p2 < this.numOfParameters) {
                    if (!tab.get(p0, test.get(p0), p1, test.get(p1), p2, test.get(p2))) {
                        tab.set(p0, test.get(p0), p1, test.get(p1), p2, test.get(p2));
                        ++numOfNewlyCoveredTuples;
                    }
                    ++p2;
                }
                ++p1;
            }
            ++p0;
        }
        return numOfNewlyCoveredTuples;
    }

    private void addUncoveredTuple(Testcase tmp, TripleTable tab, ArrayList<Integer>[] uncovTab) {
        int p0 = 0;
        while (p0 < this.numOfParameters - 2) {
            byte v0 = 0;
            while (v0 < this.parametermodel.range[p0]) {
                if (uncovTab[p0].get(v0) != 0) {
                    int p1 = p0 + 1;
                    while (p1 < this.numOfParameters - 1) {
                        byte v1 = 0;
                        while (v1 < this.parametermodel.range[p1]) {
                            if (uncovTab[p1].get(v1) != 0) {
                                int p2 = p1 + 1;
                                while (p2 < this.numOfParameters) {
                                    byte v2 = 0;
                                    while (v2 < this.parametermodel.range[p2]) {
                                        if (!tab.get(p0, v0, p1, v1, p2, v2)) {
                                            tmp.set(p0, v0);
                                            tmp.set(p1, v1);
                                            tmp.set(p2, v2);
                                            return;
                                        }
                                        v2 = (byte)(v2 + 1);
                                    }
                                    ++p2;
                                }
                            }
                            v1 = (byte)(v1 + 1);
                        }
                        ++p1;
                    }
                }
                v0 = (byte)(v0 + 1);
            }
            ++p0;
        }
    }

    private boolean addGroupedTuples(Testcase tmp, List<List<Testcase>> tupleSequenceList) {
        boolean isGroupAdded = false;
        block0: for (List<Testcase> TupleSequence : tupleSequenceList) {
            int i = 0;
            while (i < TupleSequence.size()) {
                Testcase tuple = TupleSequence.get(i);
                if (tmp.superimpose(tuple, this.constrainthandler)) {
                    TupleSequence.remove(i);
                    isGroupAdded = true;
                    continue block0;
                }
                ++i;
            }
        }
        return isGroupAdded;
    }

    private Testcase generateTempTest(Testcase seedrow, TripleTable tab, ArrayList<Integer>[] uncovTab) {
        Testcase tmp = seedrow.makeClone();
        int[] parametersequence = new int[this.parametermodel.size];
        int i = 0;
        while (i < this.parametermodel.size) {
            parametersequence[i] = i;
            ++i;
        }
        i = 1;
        while (i < this.parametermodel.size) {
            int dst = this.rnd.nextInt(i + 1);
            int tmppara = parametersequence[i];
            parametersequence[i] = parametersequence[dst];
            parametersequence[dst] = tmppara;
            ++i;
        }
        i = 0;
        while (i < this.parametermodel.size) {
            int p = parametersequence[i];
            if (tmp.get(p) < 0) {
                int newlyCoveredTuples = -1;
                byte bestValue = -1;
                byte v = 0;
                while (v < this.parametermodel.range[p]) {
                    int newtuples;
                    tmp.set(p, v);
                    if (this.constrainthandler.isPossible(tmp) && (newtuples = this.computeNewlyCoveredTuples(tmp, p, tab)) > newlyCoveredTuples) {
                        bestValue = v;
                        newlyCoveredTuples = newtuples;
                    }
                    v = (byte)(v + 1);
                }
                if (bestValue == -1) {
                    Error.printError(Main.language == Main.Language.JP ? "seed\u306b\u5236\u7d04\u9055\u53cd\u306e\u884c\u304c\u3042\u308a\u307e\u3059" : "Some seeding row violates the constraints.");
                    return null;
                }
                if (newlyCoveredTuples == 0) {
                    bestValue = -1;
                    int possibleTuples = -1;
                    ArrayList<Byte> candidateValues = new ArrayList<Byte>();
                    byte v2 = 0;
                    while (v2 < this.parametermodel.range[p]) {
                        tmp.set(p, v2);
                        if (this.constrainthandler.isPossible(tmp)) {
                            int newtuples = uncovTab[p].get(v2);
                            if (newtuples > possibleTuples) {
                                bestValue = v2;
                                possibleTuples = newtuples;
                            }
                            if (newtuples == 0 && possibleTuples == 0) {
                                candidateValues.add(v2);
                            }
                        }
                        v2 = (byte)(v2 + 1);
                    }
                    if (possibleTuples == 0) {
                        bestValue = (Byte)candidateValues.get(this.rnd.nextInt(candidateValues.size()));
                    }
                }
                tmp.set(p, bestValue);
            }
            ++i;
        }
        return tmp;
    }

    private int computeNewlyCoveredTuples(Testcase test, int p, TripleTable tab) {
        int numOfNewlyCoveredTuples = 0;
        int p1 = 0;
        while (p1 < this.numOfParameters - 1) {
            int p2 = p1 + 1;
            while (p2 < this.numOfParameters) {
                if (p != p1 && p != p2 && test.get(p1) >= 0 && test.get(p2) >= 0 && !tab.get(p, test.get(p), p1, test.get(p1), p2, test.get(p2))) {
                    ++numOfNewlyCoveredTuples;
                }
                ++p2;
            }
            ++p1;
        }
        return numOfNewlyCoveredTuples;
    }

    private int computeNewlyCoveredTuples(TripleTable tab, Testcase test) {
        int numOfNewlyCoveredTuples = 0;
        int p0 = 0;
        while (p0 < this.numOfParameters - 2) {
            int p1 = p0 + 1;
            while (p1 < this.numOfParameters - 1) {
                int p2 = p1 + 1;
                while (p2 < this.numOfParameters) {
                    if (!tab.get(p0, test.get(p0), p1, test.get(p1), p2, test.get(p2))) {
                        ++numOfNewlyCoveredTuples;
                    }
                    ++p2;
                }
                ++p1;
            }
            ++p0;
        }
        return numOfNewlyCoveredTuples;
    }
}

