package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.field.FieldItem;

public class AutoCheck  implements Serializable{

	int errorCount;

	private boolean isReturn;

	public AutoCheck() {
		errorCount = 0;
		isReturn = false;
	}

	public boolean isReturn() {
		return isReturn;
	}

	public int runCheck(CheckerStocker checkerStocker, Map<String, FieldItem> rootFieldMap, FieldMap fieldMap,ErrorMessageStocker errorMessageStocker) {

		//	O[vtB[hiWI{^j̒l}bv쐬
		HashMap<String, String> groupValueMap = new HashMap<String, String>();
		for (String fieldName : rootFieldMap.keySet()) {
			FieldItem fieldItem = rootFieldMap.get(fieldName);
			if(fieldItem.getCtrl().getCtrlProcesser().isGroupItem()){
				String baseFieldName = fieldItem.getCtrl().getBaseName();
				String suffixName = fieldName.substring(fieldItem.getCtrl().getName().length());	//	[vTtBbNX߂
//				int index = fieldName.indexOf('$');
//				if (index >= 0) {
//					baseFieldName = fieldName.substring(0, index);
//					suffixName = fieldName.substring(index);
//				}
				
				String groupFieldName = baseFieldName + HtmlTools.changeSuffix(suffixName, fieldItem.getCtrl().getGroupLevel());
				if (fieldItem.isChecked()) {
					groupValueMap.put(groupFieldName,  (String) fieldItem.getValue());
				}
			}
		}
		
		for (int i = 0; i < checkerStocker.size(); i++) {

			//	O[vtB[hiWI{^j̃`FbNʃ}bv쐬
			HashMap<String, Boolean> groupCheckedMap = new HashMap<String, Boolean>();

			CheckerItem checkerItem = checkerStocker.getCheckItem(i);

			if (checkerItem.getMode() == CheckerItem.MODE_CHECKER) {

				for (String fieldName : rootFieldMap.keySet()) {

					FieldItem fieldItem = rootFieldMap.get(fieldName);
					String baseFieldName = fieldItem.getCtrl().getBaseName();
					String suffixName = fieldName.substring(fieldItem.getCtrl().getName().length());	//	[vTtBbNX߂
//					String baseFieldName = fieldName;
//					int index = fieldName.indexOf('$');
//					if (index >= 0) {
//						baseFieldName = fieldName.substring(0, index);
//					}


					// `FbNΏۃtB[hmF
					if (baseFieldName.equals(checkerItem.getFieldName())) {
						

						//	O[vtB[hłȂ̊mF
						if(!fieldItem.getCtrl().getCtrlProcesser().isGroupItem()){

							//	O[vtB[hłȂtB[h
							String value = (String) fieldItem.getValue();
	
							try {
								for (Checker checker : checkerItem.getCheckers()) {
									checker.check((String) value);
								}
							} catch (PirkaCheckException e) {
								errorCount++;
								fieldItem.setErrorFlag(true);
								// G[bZ[Wǉ
								if (checkerItem.getPrikaMessage() == null) {
									if (checkerItem.getErrorMessage() == null || checkerItem.getErrorMessage().length() <= 0) {
										errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), e.getMessage());
									} else {
										errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getErrorMessage());
									}
								} else {
									errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getPrikaMessage());
								}
							}

						}else{
							
							//	O[vtB[h
//							String suffixName = "";
//							if (index >= 0) {
//								suffixName = fieldName.substring(index);
//							}
							String groupFieldName = baseFieldName + HtmlTools.changeSuffix(suffixName, fieldItem.getCtrl().getGroupLevel());

							//	`FbNmF
							if(!groupCheckedMap.containsKey(groupFieldName)) {
								
								//	͒l擾
								String value = "";
								if(groupValueMap.containsKey(groupFieldName)){
									value = (String) groupValueMap.get(groupFieldName);
								}

								try {
									for (Checker checker : checkerItem.getCheckers()) {
										checker.check((String) value);
									}
									groupCheckedMap.put(groupFieldName, true);

								} catch (PirkaCheckException e) {

									groupCheckedMap.put(groupFieldName, false);
									errorCount++;
									fieldItem.setErrorFlag(true);
									// G[bZ[Wǉ
									if (checkerItem.getPrikaMessage() == null) {
										if (checkerItem.getErrorMessage() == null || checkerItem.getErrorMessage().length() <= 0) {
											errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), e.getMessage());
										} else {
											errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getErrorMessage());
										}
									} else {
										errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getPrikaMessage());
									}
								}
							}else{
								if(!groupCheckedMap.get(groupFieldName)){
									errorCount++;
									fieldItem.setErrorFlag(true);
								}
							}
						}
					}
				}
			} else if (checkerItem.getMode() == CheckerItem.MODE_CHECK_AND_TELLER) {
				for (CheckAndTeller checkAndTeller : checkerItem.getCheckAndTellers()) {
					checkAndTeller.setFieldMap(fieldMap);
					checkAndTeller.setErrorMessageStocker(errorMessageStocker);
					if (!checkAndTeller.check()) {
						errorCount++;
					}
				}
			} else if (checkerItem.getMode() == CheckerItem.MODE_BREAKER) {
				if (errorCount > 0) {
					return errorCount;
				}
			} else if (checkerItem.getMode() == CheckerItem.MODE_RETURNER) {
				if (errorCount > 0) {
					isReturn = true;
					return errorCount;
				}
			}

		}
		return errorCount;
	}
}
