/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.math.BigDecimal;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;
import jp.oarts.pirka.core.util.check.message.PirkaStandardMessage;
import jp.oarts.pirka.core.util.format.PirkaFormatUtil;

public class PirkaCheckerNumericRange
implements Checker {
    private static final long serialVersionUID = -1879615178277880975L;
    private MODE mode;
    private long minLong;
    private long maxLong;
    private BigDecimal minBigDecimal;
    private BigDecimal maxBigDecimal;

    public PirkaCheckerNumericRange(int minInt, int maxInt) {
        this.mode = MODE.longVal;
        this.minLong = minInt;
        this.maxLong = maxInt;
    }

    public PirkaCheckerNumericRange(long minLong, long maxLong) {
        this.mode = MODE.longVal;
        this.minLong = minLong;
        this.maxLong = maxLong;
    }

    public PirkaCheckerNumericRange(BigDecimal minBigDecimal, BigDecimal maxBigDecimal) {
        this.mode = MODE.realVal;
        this.minBigDecimal = minBigDecimal;
        this.maxBigDecimal = maxBigDecimal;
    }

    public void check(String value) throws PirkaCheckException {
        if (value.length() <= 0) {
            return;
        }
        if (this.mode == MODE.longVal) {
            Long num = PirkaFormatUtil.parseLong(value);
            if (num == null) {
                throw new PirkaCheckException(PirkaStandardMessage.NUMERIC_ERROR, new String[0]);
            }
            if (num < this.minLong || this.maxLong < num) {
                throw new PirkaCheckException(PirkaStandardMessage.NUMERIC_RANGE_ERROR, "" + this.minLong, "" + this.maxLong);
            }
        } else {
            BigDecimal num = PirkaFormatUtil.parseBigDecimal(value);
            if (num == null) {
                throw new PirkaCheckException(PirkaStandardMessage.NUMERIC_ERROR, new String[0]);
            }
            if (this.minBigDecimal.compareTo(num) > 0 || this.maxBigDecimal.compareTo(num) < 0) {
                throw new PirkaCheckException(PirkaStandardMessage.NUMERIC_RANGE_ERROR, this.minBigDecimal.toString(), this.maxBigDecimal.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        longVal,
        realVal;

    }
}

