package jp.oarts.pirka.sample;

import java.util.Map;

import jp.oarts.pirka.core.app.EntryPoint;
import jp.oarts.pirka.core.kernel.TempFileManager;
import jp.oarts.pirka.core.win.PirkaWindow;
import jp.oarts.pirka.sample.instruction.is102800.SubWinSubA1;
import jp.oarts.pirka.sample.instruction.is102800.SubWinSubB;

/**
 * pirkatTv Gg[|Cg
 */
public class ReverseLookupEntryPoint extends EntryPoint {

	/**
	 * ʂԂ܂
	 * 
	 * @return	
	 */
	@Override
	protected PirkaWindow getInitWindow(Map<String, String[]> reqMap) {
		return new ReverseLookup();
	}

	/**
	 * TuʂԂ܂iEChE̕\@TvŎgp܂j
	 * 
	 * @return	Tu
	 */
	@Override
	protected PirkaWindow getSubWindow(Map<String, String[]> reqMap) {
		String[] params = reqMap.get("win");
		if (params != null && params.length > 0) {
			if ("A".equalsIgnoreCase(params[0])) {
				return new SubWinSubA1();
			}
			if ("B".equalsIgnoreCase(params[0])) {
				return new SubWinSubB();
			}
		}
		return null;
	}

	/* ( Javadoc)
	 * @see jp.oarts.pirka.core.app.EntryPoint#getTempFileManager()
	 */
	@Override
	public TempFileManager getTempFileManager() {
		return MemTempFileManager.getInstance();
	}


}
