package jp.oarts.pirka.sample.instruction.is101400;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * pirkatTv [v̎g
 */
public class LoopSample extends PirkaWindow {

	List<ListData> list;

	/**
	 * RXgN^
	 */
	public LoopSample() {
		list = new LinkedList<ListData>();
		list.add(new ListData("ǂ̂m点", "XYZ", "2007/06/10 19:00:05", //
				"20:0030قǓdC_̂ߒd܂B"));
		list.add(new ListData("Û݂mF", "USJs", "2007/06/10 13:05:23", //
				"p肪Ƃ܂B\nLɁAU荞݂ɂ܂̂ŁAA܂B"));
		list.add(new ListData("[C.NET Japan Info Mail]@uGWjAtH[QOOVv", "C.NET Japan", "2007/06/09 20:05:23", //
				"̃[C.NET_IDo^҂̕ɂ肵Ă܂B\ne킨₢킹͖{[̂ēǂ݉B"));
		list.add(new ListData("ykaba.comzẴ{[iX􎄂ȂEEE", "kaba.com", "2007/06/09 13:00:02", //
				"݂Ȃ܁Aɂ́B\nJohbgR،cƓ̐_cƐ\܂B\n\n{͉Ẵ{[iXV[Yɂ" //
						+ "yMzyv`zƁA\n̋ƂȂĂykaba}V[zЉĂ܂B"));
		setLoop();
	}

	/**
	 * ^CgNNbN
	 */
	public void titleLink() {
		int[] indexs = getActionLoopIndex();

		FieldMap field = getFieldMap();
		field.setValue("msg", "\n" + list.get(indexs[0]).title + "\n\n" + list.get(indexs[0]).msg);
	}

	/**
	 * 폜{^
	 */
	public void deleteButton() {
		FieldMap field = getFieldMap();
		for (int i = field.getFieldMapSize("loopItem") - 1; i >= 0; i--) {
			FieldMap loopField = field.getFieldMap("loopItem", i);
			if (loopField.getValueBoolean("deleteFlag")) {
				list.remove(i);
			}
		}
		setLoop();
		field.setValue("msg", "");
	}

	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

	/**
	 * [vZbg
	 */
	private void setLoop() {
		FieldMap field = getFieldMap();
		field.clearFieldMap("loopItem");
		int no = 1;
		for (ListData data : list) {
			FieldMap loopField = createLoopFieldMap("loopItem");
			loopField.setValue("deleteFlag", false);
			loopField.setValue("no", "" + (no++));
			loopField.setValue("title", data.title);
			loopField.setValue("senderName", data.senderName);
			loopField.setValue("dateTime", data.dateTime);
			field.addFieldMap("loopItem", loopField);
		}
	}

	/**
	 * Xgf[^NX
	 */
	class ListData implements Serializable {
		public String title;

		public String senderName;

		public String dateTime;

		public String msg;

		public ListData(String title, String senderName, String dateTime, String msg) {
			this.title = title;
			this.senderName = senderName;
			this.dateTime = dateTime;
			this.msg = msg;
		}
	}
}
