package jp.oarts.pirka.sample.instruction.is102100;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * pirkatTv t@CAbv[hʂ̍
 */
public class FileUploadSample extends PirkaWindow {

	/**
	 * Abv[h{^
	 */
	public void uploadButton() {
		try {
			FieldMap field = getFieldMap();
			String fileName = (String) field.getValueString("fileItem");
			field.setValue("fileName", fileName);

			if (fileName != null && fileName.length() > 0) {
				InputStream is = field.getInputStream("fileItem"); //	oInputStreampirkaN[ŶŖIɃN[YȂĂ悢
				byte[] buffer = getByte(is);
				field.setValue("fileContents", new String(buffer));
			}
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * CvbgXg[oCgɕϊ
	 * @param is		CvbgXg[
	 * @return			oCg
	 * @throws IOException
	 */
	private byte[] getByte(InputStream is) throws IOException {

		if (is == null) {
			return new byte[0];
		}

		byte[] buffer = new byte[2048];
		ByteArrayOutputStream baos = null;

		try {
			baos = new ByteArrayOutputStream();

			while (true) {
				int len = is.read(buffer);
				if (len <= 0) {
					break;
				}
				baos.write(buffer, 0, len);
			}
			baos.flush();
			return baos.toByteArray();
		} finally {
			if (baos != null) {
				baos.close();
			}
		}
	}

	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

}
