package jp.oarts.pirka.test.view;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.win.PirkaWindow;

public class OldServletTest01 extends PirkaWindow {

	public OldServletTest01() {
		FieldMap field = getFieldMap();
		field.setOfficialFieldName("count1", "i001");
		field.setOfficialFieldName("count2", "i002");

		addCheck("count1", PirkaChecker.intValue);
		addCheck("count2", PirkaChecker.intValue);
		addErrorCheckReturner();
	}

	public void preDraw() {
		FieldMap field = getFieldMap();
		field.setValue("msg", "v" + ((Integer) getSession("item001") + (Integer) getSession("item002")) + "̏iJ[gɓĂ܂");
	}

	public PirkaWindow cartIn1() {
		FieldMap field = getFieldMap();
		if (field.getValueString("count1").length() <= 0) {
			field.setError("count1", true);
			addError("i001", "ʂIĂ");
			return this;
		}
		int count = field.getValueInt("count1");
		int baseCount = (Integer) getSession("item001");
		putSession("item001", count + baseCount);
		return this;
	}

	public PirkaWindow cartIn2() {
		FieldMap field = getFieldMap();
		if (field.getValueString("count2").length() <= 0) {
			field.setError("count2", true);
			addError("i002", "ʂIĂ");
			return this;
		}
		int count = field.getValueInt("count2");
		int baseCount = (Integer) getSession("item002");
		putSession("item002", count + baseCount);
		return this;
	}

	public PirkaWindow bill() {
		return new OldServletTest02();
	}

	public PirkaWindow returnButton() {
		return new OldServletTestMenu();
	}
	
	public void onElse(){
		System.out.println("onElse!!");
	}
}
